/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmledit.guiutil.TabbedSplitPane;
import com.xmlmind.xmledit.guiutil.TearOffTab;
import com.xmlmind.xmleditapp.kit.AppPane;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.LayoutSpec;
import com.xmlmind.xmleditapp.kit.gui.PaneRef;
import com.xmlmind.xmleditapp.kit.gui.PaneSpec;
import java.awt.Component;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;

final class Panes
extends GUIItemSpec {
    public static final double DEFAULT_WIDTH = 0.25;
    public static final double DEFAULT_TOP_HEIGHT = 0.5;
    public PaneRef[] panes;
    public double width;
    public double topHeight;
    public boolean isLeftPanes;
    private String elementLocalName;
    private ArrayList paneList;
    private int insert;

    public Panes(String string) {
        this.elementLocalName = string;
        this.isLeftPanes = string.equals("leftPanes");
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if (this.elementLocalName.equals(string)) {
            if (this.systemId == null) {
                this.recordLocation(gUISpec);
                this.paneList = new ArrayList();
                this.width = GUIItemSpec.getDouble(attributes, "width", 0.0, 1.0, -1.0);
                this.topHeight = GUIItemSpec.getDouble(attributes, "topHeight", 0.0, 1.0, -1.0);
            } else {
                GUIItemSpec.unknownChildElement(string, gUISpec);
            }
        } else if ("pane".equals(string)) {
            String string2 = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (string2 == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            } else {
                PaneRef paneRef = new PaneRef();
                paneRef.name = string2;
                String string3 = GUIItemSpec.getNMTOKEN(attributes, "position", null);
                paneRef.atBottom = "bottom".equals(string3);
                paneRef.selected = GUIItemSpec.getBoolean(attributes, "selected", false);
                if (!this.paneList.contains(paneRef)) {
                    this.paneList.add(paneRef);
                }
            }
        } else if ("insert".equals(string)) {
            this.insert = this.paneList.isEmpty() ? 2 : 1;
        } else {
            GUIItemSpec.unknownChildElement(string, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        if (this.elementLocalName.equals(string)) {
            gUISpec.popLoader();
            if (this.paneList.size() == 0) {
                this.invalidElement(string, gUISpec);
            } else {
                Panes panes = null;
                if (gUISpec.layout != null) {
                    panes = this.isLeftPanes ? gUISpec.layout.leftPanes : gUISpec.layout.rightPanes;
                }
                if (panes != null && this.insert != 0) {
                    int n2;
                    if (this.width < 0.0) {
                        this.width = panes.width;
                    }
                    if (this.topHeight < 0.0) {
                        this.topHeight = panes.topHeight;
                    }
                    if (this.insert == 1) {
                        n2 = 0;
                        while (n2 < panes.panes.length) {
                            PaneRef paneRef = panes.panes[n2];
                            if (!this.paneList.contains(paneRef)) {
                                this.paneList.add(paneRef);
                            }
                            ++n2;
                        }
                    } else {
                        n2 = panes.panes.length - 1;
                        while (n2 >= 0) {
                            PaneRef paneRef = panes.panes[n2];
                            if (!this.paneList.contains(paneRef)) {
                                this.paneList.add(0, paneRef);
                            }
                            --n2;
                        }
                    }
                } else {
                    if (this.width < 0.0) {
                        this.width = 0.25;
                    }
                    if (this.topHeight < 0.0) {
                        this.topHeight = 0.5;
                    }
                }
                this.panes = new PaneRef[this.paneList.size()];
                this.paneList.toArray(this.panes);
                LayoutSpec layoutSpec = (LayoutSpec)gUISpec.topLoader();
                if (this.insert != 0) {
                    layoutSpec.insert = true;
                }
                if (this.isLeftPanes) {
                    layoutSpec.leftPanes = this;
                } else {
                    layoutSpec.rightPanes = this;
                }
            }
            this.paneList = null;
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.print(this.elementLocalName);
        if (this.width != 0.25) {
            printWriter.print(" width=");
            printWriter.print(this.width);
        }
        if (this.topHeight != 0.5) {
            printWriter.print(" topHeight=");
            printWriter.print(this.topHeight);
        }
        printWriter.println(':');
        int n = 0;
        while (n < this.panes.length) {
            PaneRef paneRef = this.panes[n];
            printWriter.print('\t');
            printWriter.print(paneRef.name);
            if (paneRef.atBottom) {
                printWriter.print(" position=bottom");
            }
            if (paneRef.selected) {
                printWriter.print(" selected");
            }
            printWriter.println();
            ++n;
        }
    }

    public Component createPanes(GUISpec gUISpec) {
        AppPane[] appPaneArray = new AppPane[this.panes.length];
        AppPane appPane = null;
        int n = 0;
        HashMap hashMap = gUISpec.paneSet;
        int n2 = 0;
        while (n2 < this.panes.length) {
            PaneRef paneRef = this.panes[n2];
            PaneSpec paneSpec = (PaneSpec)hashMap.get(paneRef.name);
            if (paneSpec == null) {
                this.componentNotDefined("pane", paneRef.name, gUISpec);
            } else {
                AppPane appPane2 = paneSpec.createPane(gUISpec);
                if (appPane2 != null) {
                    appPaneArray[n2] = appPane = appPane2;
                    ++n;
                }
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return (Component)((Object)appPane);
            }
        }
        return this.compose(appPaneArray);
    }

    private TabbedSplitPane compose(AppPane[] appPaneArray) {
        TabbedSplitPane tabbedSplitPane = new TabbedSplitPane();
        tabbedSplitPane.setTabPlacement(this.isLeftPanes ? 3 : 1);
        tabbedSplitPane.setVerticalSplit(false);
        tabbedSplitPane.setEndTabAtOppositeSide(false);
        tabbedSplitPane.setHorizontalRatio(this.topHeight);
        TearOffTab tearOffTab = null;
        TearOffTab tearOffTab2 = null;
        int n = 0;
        while (n < this.panes.length) {
            AppPane appPane = appPaneArray[n];
            if (appPane != null) {
                PaneRef paneRef = this.panes[n];
                boolean bl = !paneRef.atBottom;
                Component component = (Component)((Object)appPane);
                component.setName(appPane.getId());
                TearOffTab tearOffTab3 = new TearOffTab(appPane.getLabel(), appPane.getIcon(), component, bl, true, false);
                if (paneRef.selected) {
                    if (tearOffTab == null && bl) {
                        tearOffTab = tearOffTab3;
                    } else if (tearOffTab2 == null && !bl) {
                        tearOffTab2 = tearOffTab3;
                    }
                }
                tabbedSplitPane.addTab(tearOffTab3);
            }
            ++n;
        }
        if (tearOffTab != null) {
            tabbedSplitPane.selectTab(tearOffTab);
        }
        if (tearOffTab2 != null) {
            tabbedSplitPane.selectTab(tearOffTab2);
        }
        return tabbedSplitPane;
    }
}

