/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.gui.ActionSpec;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.ToolSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.xml.sax.Attributes;

class StatusBarSpec
extends GUIItemSpec {
    public static final int ITEM_TYPE_SEPARATOR = 0;
    public static final int ITEM_TYPE_ACTION = 1;
    public static final int ITEM_TYPE_TOOL = 2;
    public static final int ITEM_TYPE_TOOL_BAR_ITEMS = 3;
    public String name;
    public String helpId;
    protected Item[] items;
    protected String elementLocalName;
    private int insert;

    public StatusBarSpec() {
        this("statusBar");
    }

    protected StatusBarSpec(String string) {
        this.elementLocalName = string;
    }

    protected HashMap getStatusBarSet(GUISpec gUISpec) {
        return gUISpec.statusBarSet;
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if (this.elementLocalName.equals(string)) {
            if (this.systemId == null) {
                this.recordLocation(gUISpec);
                this.name = GUIItemSpec.getNMTOKEN(attributes, "name", null);
                if (this.name == null) {
                    GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
                }
                this.helpId = GUIItemSpec.getNMTOKEN(attributes, "helpId", null);
            } else {
                GUIItemSpec.unknownChildElement(string, gUISpec);
            }
        } else if ("insert".equals(string)) {
            this.insert = this.items == null ? 2 : 1;
        } else if ("separator".equals(string)) {
            this.addItem(0, null, 0.0);
        } else if ("action".equals(string)) {
            String string2 = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (string2 == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            } else {
                this.addItem(1, string2, 0.0);
            }
        } else if ("tool".equals(string)) {
            String string3 = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (string3 == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            } else {
                double d = GUIItemSpec.getDouble(attributes, "stretch", 0.0, 1000.0, 0.0);
                this.addItem(2, string3, d);
            }
        } else {
            GUIItemSpec.unknownChildElement(string, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        if (this.elementLocalName.equals(string)) {
            gUISpec.popLoader();
            if (this.name == null || this.items == null) {
                this.invalidElement(this.elementLocalName, gUISpec);
            } else {
                HashMap hashMap = this.getStatusBarSet(gUISpec);
                StatusBarSpec statusBarSpec = (StatusBarSpec)hashMap.get(this.name);
                if (statusBarSpec == null || this.insert == 0) {
                    hashMap.put(this.name, this);
                } else {
                    statusBarSpec.merge(this);
                }
            }
        }
    }

    protected void addItem(int n, String string, double d) {
        Item item = new Item();
        item.type = n;
        item.name = string;
        item.stretch = d;
        if (this.items == null) {
            this.items = new Item[]{item};
        } else {
            int n2 = this.items.length;
            Item[] itemArray = new Item[n2 + 1];
            System.arraycopy(this.items, 0, itemArray, 0, n2);
            itemArray[n2] = item;
            this.items = itemArray;
        }
    }

    private void merge(StatusBarSpec statusBarSpec) {
        if (statusBarSpec.helpId != null) {
            this.helpId = statusBarSpec.helpId;
        }
        if (statusBarSpec.insert == 1) {
            int n = statusBarSpec.items.length;
            int n2 = this.items.length;
            Item[] itemArray = new Item[n + n2];
            System.arraycopy(statusBarSpec.items, 0, itemArray, 0, n);
            System.arraycopy(this.items, 0, itemArray, n, n2);
            this.items = itemArray;
        } else {
            int n = this.items.length;
            int n3 = statusBarSpec.items.length;
            Item[] itemArray = new Item[n + n3];
            System.arraycopy(this.items, 0, itemArray, 0, n);
            System.arraycopy(statusBarSpec.items, 0, itemArray, n, n3);
            this.items = itemArray;
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.print(this.elementLocalName);
        printWriter.print(' ');
        printWriter.print(this.name);
        if (this.helpId != null) {
            printWriter.print(" helpId=");
            printWriter.print(this.helpId);
        }
        printWriter.println();
        int n = 0;
        while (n < this.items.length) {
            Item item = this.items[n];
            printWriter.print("* ");
            switch (item.type) {
                case 0: {
                    printWriter.print("separator");
                    break;
                }
                case 1: {
                    printWriter.print("action");
                    break;
                }
                case 2: {
                    printWriter.print("tool");
                    break;
                }
                case 3: {
                    printWriter.print("toolBarItems");
                }
            }
            if (item.name != null) {
                printWriter.print(' ');
                printWriter.print(item.name);
            }
            if (item.stretch > 0.0) {
                printWriter.print(" stretch=");
                printWriter.print(item.stretch);
            }
            printWriter.println();
            ++n;
        }
    }

    public JPanel createStatusBar(boolean bl, GUISpec gUISpec) {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 1;
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        boolean bl2 = false;
        int n = 0;
        while (n < this.items.length) {
            object2 = this.items[n];
            switch (((Item)object2).type) {
                case 0: {
                    object = new JSeparator(1);
                    gridBagConstraints.fill = 3;
                    gridBagConstraints.weightx = 0.0;
                    jPanel.add((Component)object, gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    break;
                }
                case 1: {
                    object = (ActionSpec)gUISpec.actionSet.get(((Item)object2).name);
                    if (object == null) {
                        this.componentNotDefined("action", ((Item)object2).name, gUISpec);
                        break;
                    }
                    AppPart appPart = ((ActionSpec)object).createAction(gUISpec);
                    if (appPart == null) break;
                    JButton jButton = new JButton((Action)((Object)appPart));
                    if (((AppAction)appPart).getIcon() != null) {
                        DialogUtil.configureToolBarButton(jButton);
                    } else {
                        jButton.setFocusable(false);
                    }
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.weightx = 0.0;
                    jPanel.add((Component)jButton, gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    break;
                }
                case 2: {
                    object = (ToolSpec)gUISpec.toolSet.get(((Item)object2).name);
                    if (object == null) {
                        this.componentNotDefined("tool", ((Item)object2).name, gUISpec);
                        break;
                    }
                    AppPart appPart = ((ToolSpec)object).createTool(gUISpec);
                    if (appPart == null) break;
                    ((Component)((Object)appPart)).setFocusable(false);
                    if (((Item)object2).stretch > 0.0) {
                        gridBagConstraints.fill = 2;
                        gridBagConstraints.weightx = ((Item)object2).stretch;
                        bl2 = true;
                    } else {
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.weightx = 0.0;
                    }
                    jPanel.add((Component)((Object)appPart), gridBagConstraints);
                    ++gridBagConstraints.gridx;
                }
            }
            ++n;
        }
        if (!bl2) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            object2 = new Dimension(1, 1);
            object = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            jPanel.add((Component)new Box.Filler((Dimension)object2, (Dimension)object2, (Dimension)object), gridBagConstraints);
        }
        if (this.helpId != null) {
            gUISpec.app.setHelpId(jPanel, this.helpId);
        }
        return jPanel;
    }

    public static final class Item {
        public int type;
        public String name;
        public double stretch;
    }
}

