/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.StatusBarSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolBarList;
import com.xmlmind.xmleditapp.kit.gui.ToolBarSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolSpec;
import java.awt.Component;
import java.io.PrintWriter;
import org.xml.sax.Attributes;

class ToolBarRef
extends GUIItemSpec {
    public static final int TYPE_TOOL_BAR = 0;
    public static final int TYPE_TOOL = 1;
    public static final int TYPE_STATUS_BAR = 2;
    public static final int TYPE_GROUP = 3;
    public int type;
    public String name;
    public double stretch;
    protected String elementLocalName;

    public ToolBarRef(String string) {
        this.elementLocalName = string;
        this.type = "toolBar".equals(string) ? 0 : ("tool".equals(string) ? 1 : ("statusBar".equals(string) ? 2 : 3));
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if (this.elementLocalName.equals(string)) {
            if (this.systemId == null) {
                this.recordLocation(gUISpec);
                this.name = GUIItemSpec.getNMTOKEN(attributes, "name", null);
                if (this.name == null) {
                    GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
                }
                this.stretch = GUIItemSpec.getDouble(attributes, "stretch", 0.0, 1000.0, 0.0);
            } else {
                GUIItemSpec.unknownChildElement(string, gUISpec);
            }
        } else {
            GUIItemSpec.unknownChildElement(string, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        gUISpec.popLoader();
        if (this.name != null) {
            ((ToolBarList)((Object)gUISpec.topLoader())).addToolBar(this);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ToolBarRef)) {
            return false;
        }
        ToolBarRef toolBarRef = (ToolBarRef)object;
        return this.type == toolBarRef.type && this.name.equals(toolBarRef.name);
    }

    public void list(PrintWriter printWriter) {
        printWriter.print('\t');
        printWriter.print(this.elementLocalName);
        printWriter.print(' ');
        printWriter.print(this.name);
        if (this.stretch > 0.0) {
            printWriter.print(" stretch=");
            printWriter.print(this.stretch);
        }
        printWriter.println();
    }

    public Component createToolBar(boolean bl, GUISpec gUISpec) {
        Component component = null;
        switch (this.type) {
            case 0: {
                ToolBarSpec toolBarSpec = (ToolBarSpec)gUISpec.toolBarSet.get(this.name);
                if (toolBarSpec == null) {
                    this.componentNotDefined("toolBar", this.name, gUISpec);
                    break;
                }
                component = toolBarSpec.createToolBar(bl, gUISpec);
                break;
            }
            case 1: {
                ToolSpec toolSpec = (ToolSpec)gUISpec.toolSet.get(this.name);
                if (toolSpec == null) {
                    this.componentNotDefined("tool", this.name, gUISpec);
                    break;
                }
                component = (Component)((Object)toolSpec.createTool(gUISpec));
                break;
            }
            case 2: {
                StatusBarSpec statusBarSpec = (StatusBarSpec)gUISpec.statusBarSet.get(this.name);
                if (statusBarSpec == null) {
                    this.componentNotDefined("statusBar", this.name, gUISpec);
                    break;
                }
                component = statusBarSpec.createStatusBar(bl, gUISpec);
            }
        }
        return component;
    }
}

