/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.gui.ActionSpec;
import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.Msg;
import com.xmlmind.xmleditapp.kit.gui.StatusBarSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolBarItemsSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolSpec;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JToolBar;
import org.xml.sax.Attributes;

final class ToolBarSpec
extends StatusBarSpec {
    public ToolBarSpec() {
        super("toolBar");
    }

    protected HashMap getStatusBarSet(GUISpec gUISpec) {
        return gUISpec.toolBarSet;
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if ("toolBarItems".equals(string)) {
            String string2 = GUIItemSpec.getNMTOKEN(attributes, "name", null);
            if (string2 == null) {
                GUIItemSpec.missingOrInvalidAttribute("name", gUISpec);
            } else {
                this.addItem(3, string2, 0.0);
            }
        } else {
            super.startElement(string, attributes, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        if ("toolBar".equals(string)) {
            super.endElement(string, cArray, n, gUISpec);
            if (this.name != null && this.items != null) {
                HashMap hashMap = gUISpec.toolBarSet;
                ToolBarSpec toolBarSpec = (ToolBarSpec)hashMap.get(this.name);
                int n2 = toolBarSpec.items.length - 1;
                int n3 = 0;
                while (n3 <= n2) {
                    StatusBarSpec.Item item = toolBarSpec.items[n3];
                    if (item.type == 3 && n3 != n2) {
                        this.invalidElement2("toolBar", Msg.msg("toolBarItemsMustBeLast"), gUISpec);
                        hashMap.remove(this.name);
                        break;
                    }
                    ++n3;
                }
            }
        }
    }

    public JToolBar createToolBar(boolean bl, GUISpec gUISpec) {
        JToolBar jToolBar = new JToolBar(bl ? 1 : 0);
        int n = 0;
        while (n < this.items.length) {
            StatusBarSpec.Item item = this.items[n];
            switch (item.type) {
                case 0: {
                    jToolBar.addSeparator();
                    break;
                }
                case 1: {
                    GUIItemSpec gUIItemSpec = (ActionSpec)gUISpec.actionSet.get(item.name);
                    if (gUIItemSpec == null) {
                        this.componentNotDefined("action", item.name, gUISpec);
                        break;
                    }
                    AppPart appPart = ((ActionSpec)gUIItemSpec).createAction(gUISpec);
                    if (appPart == null) break;
                    jToolBar.add((Action)((Object)appPart));
                    break;
                }
                case 2: {
                    GUIItemSpec gUIItemSpec = (ToolSpec)gUISpec.toolSet.get(item.name);
                    if (gUIItemSpec == null) {
                        this.componentNotDefined("tool", item.name, gUISpec);
                        break;
                    }
                    AppPart appPart = ((ToolSpec)gUIItemSpec).createTool(gUISpec);
                    if (appPart == null) break;
                    jToolBar.add((Component)((Object)appPart));
                    break;
                }
                case 3: {
                    GUIItemSpec gUIItemSpec = (ToolBarItemsSpec)gUISpec.toolBarItemsSet.get(item.name);
                    if (gUIItemSpec == null) {
                        this.componentNotDefined("toolBarItems", item.name, gUISpec);
                        break;
                    }
                    ((ToolBarItemsSpec)gUIItemSpec).createToolBarItems(jToolBar, gUISpec);
                }
            }
            ++n;
        }
        DialogUtil.configureToolBar(jToolBar);
        if (this.helpId != null) {
            gUISpec.app.setHelpId(jToolBar, this.helpId);
        }
        return jToolBar;
    }
}

