/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.gui;

import com.xmlmind.xmleditapp.kit.gui.GUIItemSpec;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import com.xmlmind.xmleditapp.kit.gui.Group;
import com.xmlmind.xmleditapp.kit.gui.LayoutSpec;
import com.xmlmind.xmleditapp.kit.gui.ToolBarList;
import com.xmlmind.xmleditapp.kit.gui.ToolBarRef;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.xml.sax.Attributes;

final class ToolBars
extends GUIItemSpec
implements ToolBarList {
    public static final int POSITION_TOP = 0;
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_LEFT = 2;
    public static final int POSITION_RIGHT = 3;
    public ToolBarRef[] toolBars;
    public int position;
    private String elementLocalName;
    private int insert;
    private ArrayList toolBarList;

    public ToolBars(String string) {
        this.elementLocalName = string;
        this.position = string.startsWith("top") ? 0 : (string.startsWith("bottom") ? 1 : (string.startsWith("left") ? 2 : 3));
    }

    public void startElement(String string, Attributes attributes, GUISpec gUISpec) {
        if (this.elementLocalName.equals(string)) {
            if (this.systemId == null) {
                this.recordLocation(gUISpec);
                this.toolBarList = new ArrayList();
            } else {
                GUIItemSpec.unknownChildElement(string, gUISpec);
            }
        } else if ("toolBar".equals(string) || "tool".equals(string) || "statusBar".equals(string)) {
            ToolBarRef toolBarRef = new ToolBarRef(string);
            gUISpec.pushLoader(toolBarRef);
            toolBarRef.startElement(string, attributes, gUISpec);
        } else if ("group".equals(string)) {
            Group group = new Group();
            gUISpec.pushLoader(group);
            group.startElement(string, attributes, gUISpec);
        } else if ("insert".equals(string)) {
            this.insert = this.toolBarList.isEmpty() ? 2 : 1;
        } else {
            GUIItemSpec.unknownChildElement(string, gUISpec);
        }
    }

    public void endElement(String string, char[] cArray, int n, GUISpec gUISpec) {
        if (this.elementLocalName.equals(string)) {
            gUISpec.popLoader();
            if (this.toolBarList.size() == 0) {
                this.invalidElement(string, gUISpec);
            } else {
                int n2;
                ToolBars toolBars = null;
                if (gUISpec.layout != null) {
                    switch (this.position) {
                        case 0: {
                            toolBars = gUISpec.layout.topToolBars;
                            break;
                        }
                        case 1: {
                            toolBars = gUISpec.layout.bottomToolBars;
                            break;
                        }
                        case 2: {
                            toolBars = gUISpec.layout.leftToolBars;
                            break;
                        }
                        default: {
                            toolBars = gUISpec.layout.rightToolBars;
                        }
                    }
                }
                if (toolBars != null && this.insert != 0) {
                    ToolBarRef toolBarRef;
                    if (this.insert == 1) {
                        n2 = 0;
                        while (n2 < toolBars.toolBars.length) {
                            toolBarRef = toolBars.toolBars[n2];
                            if (!this.toolBarList.contains(toolBarRef)) {
                                this.toolBarList.add(toolBarRef);
                            }
                            ++n2;
                        }
                    } else {
                        n2 = toolBars.toolBars.length - 1;
                        while (n2 >= 0) {
                            toolBarRef = toolBars.toolBars[n2];
                            if (!this.toolBarList.contains(toolBarRef)) {
                                this.toolBarList.add(0, toolBarRef);
                            }
                            --n2;
                        }
                    }
                }
                this.toolBars = new ToolBarRef[this.toolBarList.size()];
                this.toolBarList.toArray(this.toolBars);
                n2 = 0;
                switch (this.position) {
                    case 2: 
                    case 3: {
                        int n3 = 0;
                        while (n3 < this.toolBars.length) {
                            ToolBarRef toolBarRef = this.toolBars[n3];
                            switch (toolBarRef.type) {
                                case 1: 
                                case 2: {
                                    n2 = 1;
                                    break;
                                }
                                case 3: {
                                    if (((Group)toolBarRef).checkVertical()) break;
                                    n2 = 1;
                                }
                            }
                            ++n3;
                        }
                        break;
                    }
                }
                if (n2 != 0) {
                    this.invalidElement(string, gUISpec);
                } else {
                    LayoutSpec layoutSpec = (LayoutSpec)gUISpec.topLoader();
                    if (this.insert != 0) {
                        layoutSpec.insert = true;
                    }
                    switch (this.position) {
                        case 0: {
                            layoutSpec.topToolBars = this;
                            break;
                        }
                        case 1: {
                            layoutSpec.bottomToolBars = this;
                            break;
                        }
                        case 2: {
                            layoutSpec.leftToolBars = this;
                            break;
                        }
                        default: {
                            layoutSpec.rightToolBars = this;
                        }
                    }
                }
            }
            this.toolBarList = null;
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.print(this.elementLocalName);
        printWriter.println(':');
        int n = 0;
        while (n < this.toolBars.length) {
            this.toolBars[n].list(printWriter);
            ++n;
        }
    }

    public void addToolBar(ToolBarRef toolBarRef) {
        if (!this.toolBarList.contains(toolBarRef)) {
            this.toolBarList.add(toolBarRef);
        }
    }

    public Component createToolBars(GUISpec gUISpec) {
        boolean bl = this.position > 1;
        Component[] componentArray = new Component[this.toolBars.length];
        Component component = null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.toolBars.length) {
            ToolBarRef toolBarRef = this.toolBars[n2];
            Component component2 = toolBarRef.createToolBar(bl, gUISpec);
            if (component2 != null) {
                componentArray[n2] = component = component2;
                ++n;
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return component;
            }
        }
        return this.compose(bl, componentArray);
    }

    private Component compose(boolean bl, Component[] componentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 1;
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 1;
        if (bl) {
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
        } else {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (bl) {
            int n = 0;
            while (n < componentArray.length) {
                Component component = componentArray[n];
                if (component != null) {
                    jPanel.add(component, gridBagConstraints);
                    ++gridBagConstraints.gridx;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < componentArray.length) {
                Component component = componentArray[n];
                if (component != null) {
                    jPanel.add(component, gridBagConstraints);
                    ++gridBagConstraints.gridy;
                }
                ++n;
            }
        }
        return jPanel;
    }
}

