/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.part.Msg;

public abstract class AllDocumentsAction
extends LengthyAction {
    protected boolean isSaveAllNeeded() {
        boolean bl = false;
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        int n = 0;
        while (n < openedDocumentArray.length) {
            if (openedDocumentArray[n].isSaveNeeded()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    protected boolean savingAll() {
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        int n = 0;
        while (n < openedDocumentArray.length) {
            OpenedDocument openedDocument = openedDocumentArray[n];
            if (openedDocument.isSaveNeeded() && openedDocument.isSaveAsNeeded()) {
                Alert.showInfo(this.app.getDialogParent(), Msg.msg("someDocumentsNeedSaveAs", openedDocument.getLabel()));
                return false;
            }
            ++n;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < openedDocumentArray.length) {
            OpenedDocument openedDocument = openedDocumentArray[n2];
            if (openedDocument.isSaveNeeded() && !openedDocument.saving()) {
                bl = true;
                break;
            }
            ++n2;
        }
        return !bl;
    }

    protected boolean saveAll(boolean bl) {
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        int n = 0;
        while (n < openedDocumentArray.length) {
            OpenedDocument openedDocument2 = openedDocumentArray[n];
            if (openedDocument2.isSaveNeeded()) {
                if (bl && openedDocument2.canCheckValidity() && openedDocument2.checkValidity() != null && openedDocument2 == openedDocument && this.app.getPreferences().getBoolean("showValidityPaneOnSave", false)) {
                    this.app.ensurePartIsVisible("checkValidityPane");
                }
                String string = openedDocument2.getLabel();
                this.app.showStatus(Msg.msg("savingDocument", string), false);
                if (!openedDocument2.save()) {
                    this.app.showStatus("", true);
                    return false;
                }
                this.app.showStatus(Msg.msg("documentSaved", string), true);
            }
            ++n;
        }
        return true;
    }
}

