/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.part.Msg;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class AutoSavePart
implements AppPart,
ActionListener {
    private App app;
    private String id;
    private int autoSaveInterval;
    private int autoSaveTimeoutMillis;
    private Timer timer;
    private static final String MODIFICATION_COUNT_AFTER_LAST_SAVE = "MODIFICATION_COUNT_AFTER_LAST_SAVE";

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
        Preferences preferences = this.app.getPreferences();
        this.autoSaveInterval = preferences.getInt("autoSaveInterval", -1000000, 1000000, -300);
        this.autoSaveTimeoutMillis = preferences.getInt("autoSaveTimeout", 10, 86400, 30);
        this.autoSaveTimeoutMillis *= 1000;
        this.activeEditorChanged();
    }

    public void flushPreferences() {
    }

    public void namespacePrefixesChanged() {
    }

    public void validityStateChanged() {
    }

    public void undoStateChanged() {
    }

    public void editingContextChanged() {
    }

    public boolean isEditingContextSensitive() {
        return false;
    }

    public void activeEditorChanged() {
        if (this.autoSaveInterval <= 0 || this.app.getActiveEditor() == null) {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        } else if (this.timer == null) {
            this.timer = new Timer(1000, this);
            this.timer.setRepeats(true);
            this.timer.setCoalesce(true);
            this.timer.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null && window instanceof Dialog && ((Dialog)window).isModal()) {
            return;
        }
        boolean bl = false;
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        int n = 0;
        while (n < openedDocumentArray.length) {
            int n2;
            int n3;
            OpenedDocument openedDocument = openedDocumentArray[n];
            if (openedDocument.isSaveNeeded() && !openedDocument.isSaveAsNeeded() && (n3 = openedDocument.getModificationCount()) > 0) {
                boolean bl2 = false;
                Integer n4 = (Integer)openedDocument.getProperty(MODIFICATION_COUNT_AFTER_LAST_SAVE);
                n2 = n4 == null ? 0 : n4;
                if (n3 - n2 >= this.autoSaveInterval) {
                    bl2 = true;
                } else if (System.currentTimeMillis() - openedDocument.lastModified() >= (long)this.autoSaveTimeoutMillis) {
                    bl2 = true;
                }
                if (bl2) {
                    String string = openedDocument.getLabel();
                    this.app.showStatus(Msg.msg("autoSavingDocument", string), false);
                    if (!openedDocument.saving() || !openedDocument.save()) {
                        this.app.showStatus("", true);
                        break;
                    }
                    this.app.showStatus(Msg.msg("documentAutoSaved", string), true);
                    if (openedDocument != this.app.getActiveOpenedDocument()) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                AppPart[] appPartArray = this.app.getParts();
                n2 = 0;
                while (n2 < appPartArray.length) {
                    appPartArray[n2].saveStateChanged();
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void saveStateChanged() {
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        int n = 0;
        while (n < openedDocumentArray.length) {
            OpenedDocument openedDocument = openedDocumentArray[n];
            if (!openedDocument.isSaveNeeded()) {
                openedDocument.putProperty(MODIFICATION_COUNT_AFTER_LAST_SAVE, new Integer(openedDocument.getModificationCount()));
            }
            ++n;
        }
    }
}

