/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.guiutil.ChooseFile;
import com.xmlmind.xmledit.guiutil.ChooseURL;
import com.xmlmind.xmledit.guiutil.FilterByExtension;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.URLHistory;
import com.xmlmind.xmleditapp.kit.part.Msg;
import com.xmlmind.xmleditapp.urlchooser.URLChooserDialog;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public final class ChooseURLSupport
implements ChooseURL.URLChooser {
    private App app;
    private URLChooserDialog urlChooser;
    private static ChooseURLSupport instance = null;

    private ChooseURLSupport(App app) {
        this.app = app;
        ChooseURL.setURLChooser(this);
    }

    public void addToHistory(URL uRL) {
        URLHistory uRLHistory = (URLHistory)this.app.getProperty("lastOpenedFiles");
        if (uRLHistory != null) {
            uRLHistory.add(uRL);
        }
    }

    public void removeFromHistory(URL uRL) {
        URLHistory uRLHistory = (URLHistory)this.app.getProperty("lastOpenedFiles");
        if (uRLHistory != null) {
            uRLHistory.remove(uRL);
        }
    }

    public URL selectOpenURL() {
        boolean bl = this.app.getPreferences().getBoolean("useURLChooser", false);
        if (!bl) {
            File file = this.selectOpenFile();
            if (file == null) {
                return null;
            }
            return FileUtil.fileToURL(file);
        }
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        URL uRL = openedDocument == null || openedDocument.isSaveAsNeeded() ? null : openedDocument.getLocation();
        if (uRL == null && (uRL = this.getLastOpenedFile()) == null) {
            uRL = FileUtil.fileToURL(this.untitledFile());
        }
        return this.getURLChooser().selectOpenFile(uRL != null ? URLUtil.getDirectory(uRL) : null, this.getLastVisitedFiles());
    }

    public URL selectSaveURL() {
        return this.selectSaveURL(null, this.app.getPreferences().getBoolean("useURLChooser", false));
    }

    public URL selectSaveURL(URL uRL) {
        return this.selectSaveURL(uRL, this.app.getPreferences().getBoolean("useURLChooser", false));
    }

    public URL selectSaveURL(URL uRL, boolean bl) {
        int n;
        URL uRL2;
        if (!bl) {
            File file = this.selectSaveFile(FileUtil.urlToFile(uRL));
            if (file == null) {
                return null;
            }
            return FileUtil.fileToURL(file);
        }
        URL uRL3 = null;
        String string = null;
        if (uRL != null) {
            uRL3 = URLUtil.getDirectory(uRL);
            string = URLUtil.getRawBaseName(uRL);
        } else {
            OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
            uRL2 = openedDocument == null || openedDocument.isSaveAsNeeded() ? null : openedDocument.getLocation();
            if (uRL2 == null && (uRL2 = this.getLastOpenedFile()) == null) {
                uRL2 = FileUtil.fileToURL(this.untitledFile());
            }
            if (uRL2 != null) {
                uRL3 = URLUtil.getDirectory(uRL2);
            }
        }
        uRL2 = this.getURLChooser().selectSaveFile(uRL3, string, this.getLastVisitedFiles());
        if (uRL2 != null && URLUtil.exists(uRL2) && (n = JOptionPane.showConfirmDialog(this.app.getDialogParent(), Msg.msg("overwriteFile", URLUtil.toLabel(uRL2)), Msg.msg("confirm"), 2)) != 0) {
            return null;
        }
        return uRL2;
    }

    public File selectOpenFile() {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        File file = openedDocument == null || openedDocument.isSaveAsNeeded() ? null : FileUtil.urlToFile(openedDocument.getLocation());
        if (file == null && (file = this.getLastOpenedLocalFile()) == null) {
            file = this.untitledFile();
        }
        File file2 = file.getAbsoluteFile().getParentFile();
        JFileChooser jFileChooser = new JFileChooser(file2);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(ChooseFile.getChooserTitle(false, false));
        this.addFileFilters(jFileChooser, null, false);
        int n = jFileChooser.showOpenDialog(this.app.getDialogParent());
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public File selectSaveFile(File file) {
        int n;
        Serializable serializable;
        File file2;
        if (file != null) {
            file2 = file.getParentFile();
        } else {
            OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
            serializable = openedDocument == null || openedDocument.isSaveAsNeeded() ? null : FileUtil.urlToFile(openedDocument.getLocation());
            if (serializable == null && (serializable = this.getLastOpenedLocalFile()) == null) {
                serializable = this.untitledFile();
            }
            file2 = ((File)serializable).getAbsoluteFile().getParentFile();
        }
        serializable = new JFileChooser(file2);
        ((JFileChooser)serializable).setFileSelectionMode(0);
        ((JFileChooser)serializable).setDialogTitle(ChooseFile.getChooserTitle(false, true));
        this.addFileFilters((JFileChooser)serializable, file, true);
        if (file != null) {
            ((JFileChooser)serializable).setSelectedFile(file);
        }
        if ((n = ((JFileChooser)serializable).showSaveDialog(this.app.getDialogParent())) == 0) {
            int n2;
            File file3 = ((JFileChooser)serializable).getSelectedFile();
            if (file3.exists() && (n2 = JOptionPane.showConfirmDialog(this.app.getDialogParent(), Msg.msg("overwriteFile", file3), Msg.msg("confirm"), 2)) != 0) {
                return null;
            }
            return file3;
        }
        return null;
    }

    private void addFileFilters(JFileChooser jFileChooser, File file, boolean bl) {
        FilterByExtension filterByExtension;
        ArrayList<FilterByExtension> arrayList = new ArrayList<FilterByExtension>();
        FilterByExtension filterByExtension2 = null;
        if (file != null && (filterByExtension = FilterByExtension.create(file)) != null) {
            arrayList.add(filterByExtension);
            filterByExtension2 = filterByExtension;
        }
        URL[] uRLArray = this.getLastOpenedFiles();
        int n = 0;
        while (n < uRLArray.length) {
            filterByExtension = FilterByExtension.create(uRLArray[n]);
            if (filterByExtension != null && !arrayList.contains(filterByExtension)) {
                arrayList.add(filterByExtension);
                if (filterByExtension2 == null) {
                    filterByExtension2 = filterByExtension;
                }
            }
            ++n;
        }
        filterByExtension = new FilterByExtension("xml");
        if (!arrayList.contains(filterByExtension)) {
            arrayList.add(filterByExtension);
        }
        if (!bl) {
            filterByExtension2 = null;
        }
        ChooseFile.addFileFilters(jFileChooser, arrayList, filterByExtension2);
    }

    private URLChooserDialog getURLChooser() {
        if (this.urlChooser == null) {
            this.urlChooser = new URLChooserDialog(this.app.getDialogParent(), true);
        }
        return this.urlChooser;
    }

    private File untitledFile() {
        String string = System.getProperty("user.home");
        if (string != null) {
            return new File(string + File.separatorChar + "Untitled.xml");
        }
        return new File("Untitled.xml");
    }

    private URL getLastOpenedFile() {
        URLHistory uRLHistory = (URLHistory)this.app.getProperty("lastOpenedFiles");
        if (uRLHistory != null) {
            return uRLHistory.lastAdded();
        }
        return null;
    }

    private File getLastOpenedLocalFile() {
        URLHistory uRLHistory = (URLHistory)this.app.getProperty("lastOpenedFiles");
        if (uRLHistory != null) {
            return uRLHistory.lastAddedFile();
        }
        return null;
    }

    private URL[] getLastOpenedFiles() {
        URLHistory uRLHistory = (URLHistory)this.app.getProperty("lastOpenedFiles");
        if (uRLHistory != null) {
            return uRLHistory.getAll();
        }
        return URLHistory.EMPTY;
    }

    private URL[] getLastVisitedFiles() {
        URL[] uRLArray = this.getLastOpenedFiles();
        URL uRL = this.app.getPreferences().getURL("lastSaveCopyURL", null);
        if (uRL == null) {
            return uRLArray;
        }
        int n = 0;
        while (n < uRLArray.length) {
            if (uRLArray[n].equals(uRL)) {
                return uRLArray;
            }
            ++n;
        }
        URL[] uRLArray2 = new URL[uRLArray.length + 1];
        System.arraycopy(uRLArray, 0, uRLArray2, 0, uRLArray.length);
        uRLArray2[uRLArray.length] = uRL;
        return uRLArray2;
    }

    public URL chooseOpenFileURL(Component component, URL uRL) {
        if (this.app.getPreferences().getBoolean("useURLChooser", false)) {
            return this.getURLChooser().selectOpenFile(uRL);
        }
        return ChooseURL.defaultChooseOpenFileURL(component, uRL);
    }

    public URL chooseSaveFileURL(Component component, URL uRL) {
        if (this.app.getPreferences().getBoolean("useURLChooser", false)) {
            return this.getURLChooser().selectSaveFile(uRL);
        }
        return ChooseURL.defaultChooseSaveFileURL(component, uRL);
    }

    public URL chooseOpenDirectoryURL(Component component, URL uRL) {
        if (this.app.getPreferences().getBoolean("useURLChooser", false)) {
            return this.getURLChooser().selectOpenDirectory(uRL);
        }
        return ChooseURL.defaultChooseOpenDirectoryURL(component, uRL);
    }

    public URL chooseSaveDirectoryURL(Component component, URL uRL) {
        if (this.app.getPreferences().getBoolean("useURLChooser", false)) {
            return this.getURLChooser().selectSaveDirectory(uRL);
        }
        return ChooseURL.defaultChooseSaveDirectoryURL(component, uRL);
    }

    public static ChooseURLSupport getInstance(App app) {
        if (instance == null) {
            instance = new ChooseURLSupport(app);
        }
        return instance;
    }
}

