/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.guiutil.ThinBorder;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.command.CopyAsInclusion;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppTool;
import com.xmlmind.xmleditapp.kit.part.Msg;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextField;

public class ClipboardContentTool
extends JTextField
implements AppTool,
MouseListener {
    private Color normalColor;
    private Color dimmedColor;
    private String helpId;
    private App app;
    private String id;
    private static final String TEXT_LABEL = new Text().toLabel();

    public ClipboardContentTool() {
        Font font = this.getFont();
        Font font2 = new Font(font.getFamily(), font.getStyle(), Math.max(10, font.getSize() - 2));
        Color color = this.getBackground();
        this.setColumns(20);
        this.setEditable(false);
        this.setFont(font2);
        this.setBorder(new ThinBorder(color, false, 0, 0));
        this.normalColor = this.getForeground();
        Color color2 = color.darker().darker();
        this.dimmedColor = new Color(color2.getRed(), color2.getGreen(), Math.min(255, color2.getBlue() + 32));
        this.addMouseListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.showLog(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showLog(mouseEvent);
    }

    private void showLog(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.viewContent();
        }
    }

    private void viewContent() {
        String string = Clipboard.get(this);
        if (string == null) {
            string = "";
        }
        Alert.showInfo(this.app.getDialogParent(), Msg.msg("clipboardContent"), string, false, 20, 60);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void setHelpId(String string) {
        this.helpId = string;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
    }

    public void flushPreferences() {
    }

    public void activeEditorChanged() {
        this.editingContextChanged();
    }

    public void editingContextChanged() {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null) {
            boolean bl;
            String string;
            String string2 = Clipboard.get(this);
            if (string2 == null || string2.length() == 0) {
                string = "";
                bl = false;
            } else {
                Node[] nodeArray = documentView.getElementEditor().getPastableNodes(string2);
                string = ClipboardContentTool.nodesToLabel(nodeArray);
                bl = ClipboardContentTool.fromCopyAsInclusion(nodeArray);
            }
            this.setForeground(bl ? this.dimmedColor : this.normalColor);
            this.setText(string);
        }
    }

    private static final String nodesToLabel(Node[] nodeArray) {
        String string = nodeArray == null ? TEXT_LABEL : (nodeArray.length == 1 ? nodeArray[0].toLabel() : "[" + nodeArray.length + "]");
        return string;
    }

    private static final boolean fromCopyAsInclusion(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1 || !(nodeArray[0] instanceof Element)) {
            return false;
        }
        Element element = (Element)nodeArray[0];
        return element.hasAttribute(CopyAsInclusion.SOURCE_DOCUMENT_ATTRIBUTE);
    }

    public boolean isEditingContextSensitive() {
        return true;
    }

    public void namespacePrefixesChanged() {
    }

    public void saveStateChanged() {
    }

    public void validityStateChanged() {
    }

    public void undoStateChanged() {
    }
}

