/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.ClipboardFormat;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ChooseFile;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppTool;
import com.xmlmind.xmleditapp.kit.part.Msg;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ClipboardTool
extends JButton
implements AppTool,
MouseListener,
ActionListener {
    private String helpId;
    private App app;
    private String id;
    private JPopupMenu popupMenu = null;
    private File lastOpenedFile = null;
    private File lastSavedFile = null;
    private ClipboardFormat clipboardFormat = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$kit$part$ClipboardTool;

    public ClipboardTool() {
        Image image = ImageResource.get(class$com$xmlmind$xmleditapp$kit$part$ClipboardTool == null ? (class$com$xmlmind$xmleditapp$kit$part$ClipboardTool = ClipboardTool.class$("com.xmlmind.xmleditapp.kit.part.ClipboardTool")) : class$com$xmlmind$xmleditapp$kit$part$ClipboardTool, "clipboard.gif");
        this.setIcon(new ImageIcon(image));
        DialogUtil.configureToolBarButton(this);
        this.setToolTipText(Msg.msg("viewClipboardContent"));
        this.addMouseListener(this);
        this.setActionCommand("viewContent");
        this.addActionListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.showMenu(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showMenu(mouseEvent);
    }

    private void showMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            DialogUtil.showMenu(this.getPopupMenu(), this);
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem jMenuItem = this.popupMenu.add(Msg.msg("viewClipboardContent"));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("viewContent");
            jMenuItem = this.popupMenu.add(Msg.msg("loadClipboardFromFile"));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("loadFromFile");
            jMenuItem = this.popupMenu.add(Msg.msg("saveClipboardToFile"));
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("saveToFile");
        }
        return this.popupMenu;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("viewContent")) {
            this.viewContent();
        } else if (string.equals("loadFromFile")) {
            this.loadFromFile();
        } else if (string.equals("saveToFile")) {
            this.saveToFile();
        }
    }

    private void viewContent() {
        String string = Clipboard.get(this);
        if (string == null) {
            string = "";
        }
        Alert.showInfo(this.app.getDialogParent(), Msg.msg("clipboardContent"), string, false, 20, 60);
    }

    private void loadFromFile() {
        File file = ChooseFile.chooseOpenFile(this.app.getDialogParent(), this.lastOpenedFile);
        if (file == null) {
            return;
        }
        this.lastOpenedFile = file;
        if (this.clipboardFormat == null) {
            this.clipboardFormat = new ClipboardFormat();
        }
        Document document = null;
        String string = null;
        Node[] nodeArray = null;
        String string2 = null;
        this.app.showStatus(Msg.msg("loadingFile", file), false);
        this.app.waitCursor(true);
        try {
            document = this.app.getXMLLoader().doLoadDocument(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (document == null) {
            try {
                string = FileUtil.loadString(file);
            }
            catch (IOException iOException) {
                string2 = MiscUtil.reason(iOException);
            }
        } else {
            nodeArray = this.clipboardFormat.convertToNodes(document);
            string = this.clipboardFormat.formatNodes(nodeArray, nodeArray.length, null);
        }
        this.app.waitCursor(false);
        if (string2 != null) {
            this.app.showStatus("", true);
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotOpen", file, string2));
            return;
        }
        this.app.showStatus(Msg.msg("fileLoaded", file), true);
        Clipboard.put(this, string);
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null) {
            documentView.getMarkManager().notifyContextChangeListeners();
        }
    }

    private void saveToFile() {
        Node[] nodeArray;
        String string = Clipboard.get(this);
        if (string == null) {
            Alert.showInfo(this.app.getDialogParent(), Msg.msg("clipboardIsEmpty"));
            return;
        }
        File file = ChooseFile.chooseSaveFile(this.app.getDialogParent(), this.lastSavedFile);
        if (file == null) {
            return;
        }
        this.lastSavedFile = file;
        if (this.clipboardFormat == null) {
            this.clipboardFormat = new ClipboardFormat();
        }
        String string2 = (nodeArray = this.clipboardFormat.parseNodes(string)) == null ? null : "UTF-8";
        String string3 = null;
        this.app.showStatus(Msg.msg("savingFile", file), false);
        this.app.waitCursor(true);
        try {
            FileUtil.saveString(string, file, string2);
        }
        catch (IOException iOException) {
            string3 = MiscUtil.reason(iOException);
        }
        this.app.waitCursor(false);
        if (string3 == null) {
            this.app.showStatus(Msg.msg("fileSaved", file), true);
        } else {
            this.app.showStatus("", true);
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotSave", file, string3));
        }
    }

    public void setHelpId(String string) {
        this.helpId = string;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
    }

    public void flushPreferences() {
    }

    public void namespacePrefixesChanged() {
    }

    public void saveStateChanged() {
    }

    public void validityStateChanged() {
    }

    public void undoStateChanged() {
    }

    public void editingContextChanged() {
    }

    public boolean isEditingContextSensitive() {
        return false;
    }

    public void activeEditorChanged() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

