/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.CloseDocumentAction;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.part.Msg;
import com.xmlmind.xmleditapp.kit.part.RecordCommandSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;

public class CloseAction
extends LengthyAction
implements CloseDocumentAction,
Command,
RecordCommandSupport.ExecutableStep {
    protected OpenedDocument openedDoc;

    protected boolean init() {
        this.openedDoc = this.app.getActiveOpenedDocument();
        return this.openedDoc != null;
    }

    protected void exec() {
        this.doExec();
    }

    protected Object doExec() {
        if (this.openedDoc == null) {
            return Command.EXECUTION_FAILED;
        }
        if (this.openedDoc.isSaveNeeded() && !CloseAction.canDiscardChanges(this.openedDoc)) {
            this.openedDoc = null;
            return Command.EXECUTION_FAILED;
        }
        if (!this.openedDoc.closing()) {
            this.openedDoc = null;
            return Command.EXECUTION_FAILED;
        }
        this.app.removeOpenedDocument(this.openedDoc);
        this.openedDoc = null;
        return null;
    }

    public void updateEnabled() {
        this.setEnabled(this.app.getActiveOpenedDocument() != null);
    }

    public static final boolean canDiscardChanges(OpenedDocument openedDocument) {
        App app = openedDocument.getApp();
        int n = JOptionPane.showConfirmDialog(app.getDialogParent(), Msg.msg("saveChanges", openedDocument.getLabel()), Msg.msg("confirm"), 1);
        switch (n) {
            case 0: {
                String string = openedDocument.getLabel();
                if (openedDocument.isSaveAsNeeded()) {
                    Alert.showInfo(app.getDialogParent(), Msg.msg("documentNeedsSaveAs", string));
                    return false;
                }
                app.showStatus(Msg.msg("savingDocument", string), false);
                if (!openedDocument.saving() || !openedDocument.save()) {
                    app.showStatus("", true);
                    return false;
                }
                app.showStatus(Msg.msg("documentSaved", string), true);
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeDocument(OpenedDocument openedDocument) {
        Object object;
        this.openedDoc = openedDocument;
        this.app.waitCursor(true);
        try {
            object = this.doExec();
            Object var4_3 = null;
            this.app.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.app.waitCursor(false);
            throw throwable;
        }
        return object != Command.EXECUTION_FAILED;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.openedDoc = null;
        if (string != null && string.length() > 0) {
            File file;
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null && (file = new File(string)).isFile()) {
                uRL = FileUtil.fileToURL(file);
            }
            if (uRL != null) {
                this.openedDoc = this.app.getOpenedDocument(uRL);
            }
        } else {
            this.openedDoc = this.app.getActiveOpenedDocument();
        }
        return this.openedDoc != null;
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        return RecordCommandSupport.executeCommand(this, gadget, string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        this.app.waitCursor(true);
        try {
            object = this.doExec();
            Object var7_6 = null;
            this.app.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.app.waitCursor(false);
            throw throwable;
        }
        return object;
    }
}

