/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.MenuInfo;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.AppMenuItems;
import com.xmlmind.xmleditapp.kit.EditAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class ConfigSpecificMenuItems
extends AppMenuItems
implements MenuListener {
    private int firstConfigSpecificItem;
    private String originalLabel;
    private int originalMnemonic;
    private Configuration installedConfig;
    private boolean hasConfigSpecificActions;
    private EditAction[] configSpecificActions1;
    private EditAction[] configSpecificActions2;
    private String specName;

    public void initMenu(JMenu jMenu) {
        super.initMenu(jMenu);
        this.firstConfigSpecificItem = jMenu.getItemCount();
        this.originalLabel = jMenu.getText();
        this.originalMnemonic = jMenu.getMnemonic();
        if (this.firstConfigSpecificItem == 0) {
            jMenu.setEnabled(false);
        }
        jMenu.addMenuListener(this);
    }

    public void setSpecificationName(String string) {
        this.specName = string;
    }

    public String getSpecificationName() {
        return this.specName;
    }

    public void activeEditorChanged() {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument == null) {
            if (this.installedConfig != null) {
                if (this.hasConfigSpecificActions) {
                    this.uninstallConfigSpecificMenu();
                }
                this.installedConfig = null;
            }
        } else {
            Configuration configuration = openedDocument.getConfiguration();
            if (configuration != this.installedConfig) {
                if (this.installedConfig != null) {
                    if (this.hasConfigSpecificActions) {
                        this.uninstallConfigSpecificMenu();
                    }
                    this.installedConfig = null;
                }
                if (configuration != null) {
                    MenuInfo.MenuSpec menuSpec;
                    MenuInfo menuInfo = (MenuInfo)configuration.get("menu");
                    if (menuInfo != null && (menuSpec = menuInfo.getMenuSpec(this.specName)) != null) {
                        this.installConfigSpecificMenu(menuSpec);
                    }
                    this.installedConfig = configuration;
                }
            }
        }
        this.editingContextChanged();
    }

    private void uninstallConfigSpecificMenu() {
        int n = this.menu.getItemCount() - 1;
        while (n >= this.firstConfigSpecificItem) {
            this.menu.remove(n);
            --n;
        }
        this.hasConfigSpecificActions = false;
        this.configSpecificActions1 = null;
        this.configSpecificActions2 = null;
        if (this.firstConfigSpecificItem == 0) {
            this.menu.setText(this.originalLabel);
            this.menu.setMnemonic(this.originalMnemonic);
            this.menu.setEnabled(this.menu.getItemCount() > 0);
        }
    }

    private void installConfigSpecificMenu(MenuInfo.MenuSpec menuSpec) {
        this.hasConfigSpecificActions = true;
        if (this.firstConfigSpecificItem > 0) {
            this.menu.addSeparator();
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int[] nArray = new int[1];
        this.addMenuItems(this.menu, menuSpec.items, arrayList, arrayList2, nArray);
        int n = arrayList.size();
        if (n > 0) {
            this.configSpecificActions1 = new EditAction[n];
            arrayList.toArray(this.configSpecificActions1);
        } else {
            this.configSpecificActions1 = null;
        }
        n = arrayList2.size();
        if (n > 0) {
            this.configSpecificActions2 = new EditAction[n];
            arrayList2.toArray(this.configSpecificActions2);
        } else {
            this.configSpecificActions2 = null;
        }
        if (this.firstConfigSpecificItem == 0) {
            this.menu.setText(DialogUtil.buttonLabel(menuSpec.label));
            char c = DialogUtil.buttonMnemonic(menuSpec.label);
            if (c != '\u0000') {
                this.menu.setMnemonic(c);
            }
            this.menu.setEnabled(this.menu.getItemCount() > 0);
        }
    }

    private void addMenuItems(JMenu jMenu, MenuInfo.MenuItemSpec[] menuItemSpecArray, ArrayList arrayList, ArrayList arrayList2, int[] nArray) {
        int n = 0;
        while (n < menuItemSpecArray.length) {
            Object object;
            MenuInfo.MenuItemSpec menuItemSpec = menuItemSpecArray[n];
            if (menuItemSpec instanceof MenuInfo.MenuSpec) {
                object = (MenuInfo.MenuSpec)menuItemSpec;
                JMenu jMenu2 = new JMenu(DialogUtil.buttonLabel(((MenuInfo.MenuSpec)object).label));
                char c = DialogUtil.buttonMnemonic(((MenuInfo.MenuSpec)object).label);
                if (c != '\u0000') {
                    jMenu2.setMnemonic(c);
                }
                AppMenuItems.setNonIconic(jMenu2);
                jMenu.add(jMenu2);
                this.addMenuItems(jMenu2, ((MenuInfo.MenuSpec)object).items, arrayList, arrayList2, nArray);
            } else if (menuItemSpec.label == null) {
                jMenu.addSeparator();
            } else {
                object = new EditAction(menuItemSpec.commandName, menuItemSpec.commandParameter, true);
                ((AppAction)object).initApp(this.app, this.editActionId(nArray));
                ((AbstractAction)object).putValue("Name", DialogUtil.buttonLabel(menuItemSpec.label));
                char c = DialogUtil.buttonMnemonic(menuItemSpec.label);
                if (c != '\u0000') {
                    ((AbstractAction)object).putValue("MnemonicKey", new Integer(Character.toUpperCase(c)));
                }
                if (menuItemSpec.icon != null) {
                    ((AbstractAction)object).putValue("SmallIcon", menuItemSpec.icon);
                } else {
                    AppMenuItems.setNonIconic((Action)object);
                }
                if (menuItemSpec.accelerator != null && !this.app.isReservedKeyStroke(menuItemSpec.accelerator)) {
                    ((AbstractAction)object).putValue("AcceleratorKey", menuItemSpec.accelerator);
                    arrayList.add(object);
                } else {
                    arrayList2.add(object);
                }
                JMenuItem jMenuItem = jMenu.add((Action)object);
            }
            ++n;
        }
    }

    private String editActionId(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(this.id);
        stringBuffer.append('.');
        int n = nArray[0];
        nArray[0] = n + 1;
        stringBuffer.append(Integer.toString(n));
        return stringBuffer.toString();
    }

    public void editingContextChanged() {
        if (this.configSpecificActions1 != null) {
            int n = 0;
            while (n < this.configSpecificActions1.length) {
                this.configSpecificActions1[n].updateEnabled();
                ++n;
            }
        }
    }

    public boolean isEditingContextSensitive() {
        return true;
    }

    public void menuSelected(MenuEvent menuEvent) {
        if (this.configSpecificActions2 != null) {
            int n = 0;
            while (n < this.configSpecificActions2.length) {
                this.configSpecificActions2[n].updateEnabled();
                ++n;
            }
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }
}

