/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.ToolBarInfo;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.AppToolBarItems;
import com.xmlmind.xmleditapp.kit.EditAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class ConfigSpecificToolBarItems
extends AppToolBarItems {
    protected int firstConfigSpecificButton;
    protected Configuration installedConfig;
    protected EditAction[] configSpecificActions;
    protected String specName;

    public void initToolBar(JToolBar jToolBar) {
        super.initToolBar(jToolBar);
        this.firstConfigSpecificButton = jToolBar.getComponentCount();
        if (this.firstConfigSpecificButton == 0) {
            jToolBar.add(new Placeholder(jToolBar.getOrientation() == 1));
        }
    }

    public void setSpecificationName(String string) {
        this.specName = string;
    }

    public String getSpecificationName() {
        return this.specName;
    }

    public void activeEditorChanged() {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument == null) {
            if (this.installedConfig != null) {
                if (this.configSpecificActions != null) {
                    this.uninstallConfigSpecificButtons();
                }
                this.installedConfig = null;
            }
        } else {
            Configuration configuration = openedDocument.getConfiguration();
            if (configuration != this.installedConfig) {
                if (this.installedConfig != null) {
                    if (this.configSpecificActions != null) {
                        this.uninstallConfigSpecificButtons();
                    }
                    this.installedConfig = null;
                }
                if (configuration != null) {
                    this.installConfigSpecificButtons(configuration);
                    this.installedConfig = configuration;
                }
            }
        }
        this.editingContextChanged();
        this.toolBar.revalidate();
        this.toolBar.repaint();
    }

    protected void uninstallConfigSpecificButtons() {
        int n = this.toolBar.getComponentCount() - 1;
        while (n >= this.firstConfigSpecificButton) {
            this.toolBar.remove(n);
            --n;
        }
        this.configSpecificActions = null;
        if (this.firstConfigSpecificButton == 0) {
            this.toolBar.add(new Placeholder(this.toolBar.getOrientation() == 1));
        }
    }

    protected void installConfigSpecificButtons(Configuration configuration) {
        ToolBarInfo.ButtonSpec[] buttonSpecArray;
        ToolBarInfo toolBarInfo = (ToolBarInfo)configuration.get("toolBar");
        if (toolBarInfo != null && (buttonSpecArray = toolBarInfo.getButtonSpecs(this.specName)) != null) {
            this.installConfigSpecificButtons(buttonSpecArray);
        }
    }

    protected void installConfigSpecificButtons(ToolBarInfo.ButtonSpec[] buttonSpecArray) {
        if (this.firstConfigSpecificButton == 0) {
            this.toolBar.remove(0);
        } else {
            this.toolBar.addSeparator();
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        int n = 0;
        int n2 = 0;
        while (n2 < buttonSpecArray.length) {
            Object object;
            Serializable serializable;
            ToolBarInfo.ButtonSpec buttonSpec = buttonSpecArray[n2];
            if (buttonSpec.commandName != null) {
                serializable = new EditAction(buttonSpec.commandName, buttonSpec.commandParameter, true);
                ((AppAction)serializable).initApp(this.app, this.editActionId(n++));
                arrayList.add(serializable);
                ((AbstractAction)serializable).putValue("SmallIcon", buttonSpec.icon);
                if (buttonSpec.toolTip != null) {
                    ((AbstractAction)serializable).putValue("ShortDescription", buttonSpec.toolTip);
                }
                object = this.toolBar.add((Action)((Object)serializable));
                ((Component)object).setFocusable(false);
                DialogUtil.configureToolBarButton((AbstractButton)object);
            } else if (buttonSpec.menu != null) {
                serializable = new JButton(buttonSpec.icon);
                ((Component)serializable).setFocusable(false);
                if (buttonSpec.toolTip != null) {
                    ((JComponent)serializable).setToolTipText(buttonSpec.toolTip);
                }
                DialogUtil.configureToolBarButton((AbstractButton)serializable);
                this.toolBar.add((Component)serializable);
                object = buttonSpec.menu;
                final EditAction[] editActionArray = new EditAction[((ToolBarInfo.MenuItemSpec[])object).length];
                final JPopupMenu jPopupMenu = new JPopupMenu();
                int n3 = 0;
                while (n3 < editActionArray.length) {
                    Object object2 = object[n3];
                    if (((ToolBarInfo.MenuItemSpec)object2).commandName == null) {
                        editActionArray[n3] = null;
                        jPopupMenu.addSeparator();
                    } else {
                        EditAction editAction = new EditAction(((ToolBarInfo.MenuItemSpec)object2).commandName, ((ToolBarInfo.MenuItemSpec)object2).commandParameter, true);
                        editAction.initApp(this.app, this.editActionId(n++));
                        editActionArray[n3] = editAction;
                        editAction.putValue("Name", ((ToolBarInfo.MenuItemSpec)object2).label);
                        if (((ToolBarInfo.MenuItemSpec)object2).icon != null) {
                            editAction.putValue("SmallIcon", ((ToolBarInfo.MenuItemSpec)object2).icon);
                        }
                        jPopupMenu.add(editAction);
                    }
                    ++n3;
                }
                ((Component)serializable).addMouseListener(new MouseAdapter((JButton)serializable){
                    private final /* synthetic */ JButton val$menuButton;
                    {
                        this.val$menuButton = jButton;
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                        int n = 0;
                        while (n < editActionArray.length) {
                            if (editActionArray[n] != null) {
                                editActionArray[n].updateEnabled();
                            }
                            ++n;
                        }
                        jPopupMenu.show(this.val$menuButton, 0, this.val$menuButton.getHeight());
                    }
                });
            } else {
                this.toolBar.addSeparator();
            }
            ++n2;
        }
        this.configSpecificActions = new EditAction[arrayList.size()];
        arrayList.toArray(this.configSpecificActions);
    }

    protected String editActionId(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.id);
        stringBuffer.append('.');
        stringBuffer.append(Integer.toString(n));
        return stringBuffer.toString();
    }

    public void editingContextChanged() {
        if (this.configSpecificActions != null) {
            int n = 0;
            while (n < this.configSpecificActions.length) {
                this.configSpecificActions[n].updateEnabled();
                ++n;
            }
        }
    }

    public boolean isEditingContextSensitive() {
        return true;
    }

    protected static final class Placeholder
    extends Component {
        private boolean vertical;
        private static final int MARGIN = 1;
        private static final int GAP = 1;
        private static final int MAJOR_SIZE = 5;
        private static final int MINOR_SIZE = 3;

        public Placeholder(boolean bl) {
            this.vertical = bl;
        }

        public boolean isFocusable() {
            return false;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            if (this.vertical) {
                return new Dimension(19, 13);
            }
            return new Dimension(13, 19);
        }

        public void paint(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(this.getBackground());
            if (this.vertical) {
                int n3 = (n - 5) / 2;
                int n4 = 1;
                int n5 = 0;
                while (n5 < 3) {
                    graphics.fill3DRect(n3, n4, 5, 3, true);
                    n4 += 4;
                    ++n5;
                }
            } else {
                int n6 = 1;
                int n7 = (n2 - 5) / 2;
                int n8 = 0;
                while (n8 < 3) {
                    graphics.fill3DRect(n6, n7, 3, 5, true);
                    n6 += 4;
                    ++n8;
                }
            }
        }
    }
}

