/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.dialog.AttributeEditor;
import com.xmlmind.xmledit.dialog.AttributeEditorEvent;
import com.xmlmind.xmledit.dialog.AttributeEditorListener;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class EditAttributePane
extends AttributeEditor
implements AppPane {
    private String label;
    private Icon icon;
    private String helpId;
    private App app;
    private String id;

    public EditAttributePane() {
        super(false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentView documentView;
                if (EditAttributePane.this.getElement() != null) {
                    EditAttributePane.this.resetElement();
                }
                if ((documentView = EditAttributePane.this.app.getActiveDocumentView()) != null) {
                    documentView.requestFocus();
                }
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
        AttributeEditorListener attributeEditorListener = new AttributeEditorListener(){

            public void attributeEdited(AttributeEditorEvent attributeEditorEvent) {
                DocumentView documentView = EditAttributePane.this.app.getActiveDocumentView();
                if (documentView != null) {
                    if (documentView.hasCommandListeners()) {
                        String string = null;
                        StringBuffer stringBuffer = new StringBuffer();
                        switch (attributeEditorEvent.getId()) {
                            case 1: {
                                string = "putAttribute";
                                stringBuffer.append("[implicitElement] ");
                                stringBuffer.append(attributeEditorEvent.getAttributeName().toString());
                                stringBuffer.append(' ');
                                stringBuffer.append(StringUtil.quoteArgument(attributeEditorEvent.getAttributeNewValue()));
                                break;
                            }
                            case 2: {
                                string = "removeAttribute";
                                stringBuffer.append("[implicitElement] ");
                                stringBuffer.append(attributeEditorEvent.getAttributeName().toString());
                                break;
                            }
                            case 3: {
                                string = "removeAttribute";
                                stringBuffer.append("[force][implicitElement] ");
                                stringBuffer.append(attributeEditorEvent.getAttributeName().toString());
                            }
                        }
                        if (string != null) {
                            documentView.notifyCommandListeners(string, stringBuffer.toString(), -1, -1);
                        }
                    }
                    if (attributeEditorEvent.getUsingForm()) {
                        documentView.requestFocus();
                    }
                }
            }
        };
        this.addAttributeEditorListener(attributeEditorListener);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setHelpId(String string) {
        this.helpId = string;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
    }

    public void flushPreferences() {
    }

    public void activeEditorChanged() {
        Document document = this.app.getActiveDocument();
        if (this.getDocument() != document) {
            this.setDocument(document);
        }
        this.editingContextChanged();
    }

    public void editingContextChanged() {
        Element element = null;
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null) {
            MarkManager markManager = documentView.getMarkManager();
            NodeMark nodeMark = markManager.getSelected();
            NodeMark nodeMark2 = markManager.getSelected2();
            TextLocation textLocation = markManager.getDot();
            TextLocation textLocation2 = markManager.getMark();
            Node node = null;
            if (nodeMark == null) {
                if (textLocation != null) {
                    node = textLocation.getNode();
                    if (textLocation2 == null || textLocation2.getTextNode() == node && textLocation2.getOffset() == textLocation.getOffset()) {
                        element = node.getParentElement();
                    }
                }
            } else {
                node = nodeMark.getNode();
                if (nodeMark2 == null && node.getNodeType() == 4) {
                    element = (Element)node;
                }
            }
        }
        this.setElement(element);
    }

    public boolean isEditingContextSensitive() {
        return true;
    }

    public void namespacePrefixesChanged() {
        this.resetElement();
    }

    public void validityStateChanged() {
    }

    public void saveStateChanged() {
    }

    public void undoStateChanged() {
    }
}

