/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.part.ChooseURLSupport;
import com.xmlmind.xmleditapp.kit.part.RecordCommandSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class EditInclusionAction
extends LengthyAction
implements Command,
RecordCommandSupport.ExecutableStep {
    protected URL inclusionURL;
    protected boolean toolTipInitialized;
    protected String disabledToolTip;
    protected String enabledToolTipStart;
    protected String enabledToolTipEnd;
    protected URL parameterURL = null;
    protected boolean isInclusion = false;

    protected boolean init() {
        return true;
    }

    protected void exec() {
        if (this.inclusionURL != null) {
            this.doExec(this.inclusionURL, this.app.getActiveOpenedDocument());
        }
    }

    protected Object doExec(URL uRL, OpenedDocument openedDocument) {
        OpenedDocument openedDocument2 = this.app.getOpenedDocument(uRL);
        if (openedDocument2 != null) {
            this.app.setActiveOpenedDocument(openedDocument2);
        } else {
            openedDocument2 = this.app.createOpenedDocument();
            if (!openedDocument2.opening(uRL, openedDocument)) {
                return Command.EXECUTION_FAILED;
            }
            if (!openedDocument2.open(uRL, openedDocument)) {
                this.app.getDialogParent().getToolkit().beep();
                ChooseURLSupport.getInstance(this.app).removeFromHistory(uRL);
                return Command.EXECUTION_FAILED;
            }
            this.app.addOpenedDocument(openedDocument2);
            ChooseURLSupport.getInstance(this.app).addToHistory(uRL);
            if (openedDocument2.canCheckValidity()) {
                openedDocument2.checkValidity();
            }
        }
        return openedDocument2.getDocument();
    }

    public void updateEnabled() {
        URL uRL = this.inclusionURL;
        DocumentView documentView = this.app.getActiveDocumentView();
        this.inclusionURL = documentView != null ? EditInclusionAction.findInclusionURL(documentView) : null;
        this.setEnabled(this.inclusionURL != null);
        if (!MiscUtil.eq(uRL, this.inclusionURL)) {
            this.updateToolTip();
        }
    }

    protected static final URL findInclusionURL(DocumentView documentView) {
        Object object;
        Object object2;
        MarkManager markManager = documentView.getMarkManager();
        if (markManager == null) {
            return null;
        }
        Element element = null;
        NodeMark nodeMark = markManager.getSelected();
        if (nodeMark != null) {
            NodeMark nodeMark2;
            object2 = nodeMark.getNode();
            element = object2 == (object = (nodeMark2 = markManager.getSelected2()) != null ? nodeMark2.getNode() : object2) ? (object2 instanceof Element ? (Element)object2 : ((Node)object2).getParentElement()) : ((Node)object2).getParentElement();
        } else {
            object2 = markManager.getDot();
            if (object2 == null) {
                return null;
            }
            object = markManager.getMark();
            if (object != null && (((TextLocation)object).getTextNode() != ((TextLocation)object2).getTextNode() || ((TextLocation)object).getOffset() != ((TextLocation)object2).getOffset())) {
                return null;
            }
            element = ((TextLocation)object2).getTextNode().getParentElement();
        }
        while (element != null) {
            object2 = (InclusionInfo)element.getProperty("INCLUSION_INFO");
            if (object2 != null) {
                return ((InclusionInfo)object2).getDocumentLocation(element);
            }
            element = element.getParentElement();
        }
        return null;
    }

    protected final void updateToolTip() {
        if (!this.toolTipInitialized) {
            this.toolTipInitialized = true;
            this.disabledToolTip = (String)this.getValue("ShortDescription");
            if (this.disabledToolTip != null) {
                int n = this.disabledToolTip.lastIndexOf(" [");
                if (n < 0) {
                    this.enabledToolTipStart = this.disabledToolTip;
                    this.enabledToolTipEnd = "";
                } else {
                    this.enabledToolTipStart = this.disabledToolTip.substring(0, n);
                    this.enabledToolTipEnd = this.disabledToolTip.substring(n + 1);
                }
            }
        }
        if (this.disabledToolTip != null) {
            String string;
            if (this.inclusionURL != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.enabledToolTipStart);
                stringBuffer.append(" \"");
                stringBuffer.append(URLUtil.toShortLabel(this.inclusionURL, 40));
                stringBuffer.append("\" ");
                stringBuffer.append(this.enabledToolTipEnd);
                string = stringBuffer.toString();
            } else {
                string = this.disabledToolTip;
            }
            this.putValue("ShortDescription", string);
        }
    }

    public boolean isEditingContextSensitive() {
        return true;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.parameterURL = null;
        this.isInclusion = false;
        if (string != null && string.length() > 0) {
            File file;
            try {
                this.parameterURL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.parameterURL = null;
            }
            if (this.parameterURL == null && (file = new File(string)).isFile()) {
                this.parameterURL = FileUtil.fileToURL(file);
            }
        } else {
            DocumentView documentView = this.app.getActiveDocumentView();
            if (gadget == documentView) {
                this.parameterURL = this.inclusionURL;
                this.isInclusion = true;
            }
        }
        return this.parameterURL != null;
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        return RecordCommandSupport.executeCommand(this, gadget, string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        this.app.waitCursor(true);
        try {
            OpenedDocument openedDocument = this.isInclusion ? this.app.getActiveOpenedDocument() : null;
            object = this.doExec(this.parameterURL, openedDocument);
            Object var8_7 = null;
            this.parameterURL = null;
            this.isInclusion = false;
            this.app.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.parameterURL = null;
            this.isInclusion = false;
            this.app.waitCursor(false);
            throw throwable;
        }
        return object;
    }
}

