/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesChangeEvent;
import com.xmlmind.xmleditapp.dialog.PreferencesChangeListener;
import com.xmlmind.xmleditapp.dialog.PreferencesEditor;
import com.xmlmind.xmleditapp.dialog.PreferencesEditorDialog;
import com.xmlmind.xmleditapp.dialog.PreferencesSheet;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.part.Msg;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class EditOptionsAction
extends LengthyAction
implements PreferencesChangeListener {
    private PreferencesEditorDialog optionsDialog;
    private HashMap nameToSheet;

    protected boolean init() {
        return true;
    }

    protected void exec() {
        if (this.optionsDialog == null) {
            String string = this.getLabel();
            if ((string = DialogUtil.buttonLabel(string)).endsWith("...")) {
                string = string.substring(0, string.length() - 3);
            }
            this.optionsDialog = new PreferencesEditorDialog(this.app.getDialogParent(), string, true);
            PreferencesEditor preferencesEditor = this.optionsDialog.getPreferencesEditor();
            preferencesEditor.addPreferencesChangeListener(this);
            preferencesEditor.setPreferredSize(new Dimension(750, 500));
            this.nameToSheet = new HashMap();
            App.PreferencesSheetInfo[] preferencesSheetInfoArray = this.app.getPreferencesSheetInfo();
            int n = 0;
            while (n < preferencesSheetInfoArray.length) {
                App.PreferencesSheetInfo preferencesSheetInfo = preferencesSheetInfoArray[n];
                PreferencesSheet preferencesSheet = preferencesSheetInfo.getPreferencesSheet();
                preferencesEditor.addSheet(preferencesSheet, preferencesSheetInfo.getParentName());
                this.nameToSheet.put(preferencesSheet.getName(), preferencesSheet);
                ++n;
            }
        }
        this.app.flushPreferences();
        this.optionsDialog.edit(this.app.getPreferences());
    }

    public void updateEnabled() {
    }

    public void preferencesChange(PreferencesChangeEvent preferencesChangeEvent) {
        preferencesChangeEvent.mergeChanges();
        final Preferences preferences = preferencesChangeEvent.getEditedPreferences();
        final PreferencesChangeEvent.Change[] changeArray = preferencesChangeEvent.getChanges();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditOptionsAction.this.app.showStatus(Msg.msg("applyingChanges"), false);
                EditOptionsAction.this.app.waitCursor(true);
                int n = 0;
                while (n < changeArray.length) {
                    PreferencesChangeEvent.Change change = changeArray[n];
                    PreferencesSheet preferencesSheet = (PreferencesSheet)EditOptionsAction.this.nameToSheet.get(change.sheetName);
                    preferencesSheet.applyPreferences(preferences);
                    ++n;
                }
                EditOptionsAction.this.app.waitCursor(false);
                EditOptionsAction.this.app.showStatus("", true);
            }
        });
    }
}

