/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.command.ChooseFieldCommand;
import com.xmlmind.xmledit.dialog.FieldChoice;
import com.xmlmind.xmledit.dialog.FieldChooser;
import com.xmlmind.xmledit.dialog.FieldChooserEvent;
import com.xmlmind.xmledit.dialog.FieldChooserListener;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppPane;
import com.xmlmind.xmleditapp.kit.EditAction;
import com.xmlmind.xmleditapp.kit.part.ConvertCmd;
import com.xmlmind.xmleditapp.kit.part.InsertCmd;
import com.xmlmind.xmleditapp.kit.part.Msg;
import com.xmlmind.xmleditapp.kit.part.ReplaceCmd;
import com.xmlmind.xmleditapp.kit.part.WrapCmd;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class EditPane
extends JPanel
implements AppPane,
FieldChooserListener,
ActionListener,
Runnable {
    private String label;
    private Icon icon;
    private String helpId;
    private App app;
    private String id;
    private JToolBar toolBar;
    private JToggleButton replaceButton;
    private JToggleButton insertBeforeButton;
    private JToggleButton insertButton;
    private JToggleButton insertAfterButton;
    private JToggleButton convertButton;
    private JToggleButton wrapButton;
    private FieldChooser fieldChooser;
    private EditAction replaceAction;
    private EditAction insertBeforeAction;
    private EditAction insertAction;
    private EditAction insertAfterAction;
    private EditAction convertAction;
    private EditAction wrapAction;
    private ReplaceCmd replaceCommand;
    private InsertCmd insertCommand;
    private ConvertCmd convertCommand;
    private WrapCmd wrapCommand;
    private static String replaceParameter;
    private static String insertBeforeParameter;
    private static String insertParameter;
    private static String insertAfterParameter;
    private static String convertParameter;
    private static String wrapParameter;
    private Command pendingCommand = null;
    private String pendingCommandParameter = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$kit$part$EditPane;

    public EditPane() {
        super(new GridBagLayout());
        this.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.toolBar = new JToolBar();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.toolBar, gridBagConstraints);
        boolean bl = DialogUtil.isAddingMnemonics();
        DialogUtil.setAddingMnemonics(false);
        this.fieldChooser = new FieldChooser(8, 20);
        DialogUtil.setAddingMnemonics(bl);
        this.fieldChooser.addFieldChooserListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fieldChooser, gridBagConstraints);
        this.fieldChooser.clearForm();
        this.replaceButton = new JToggleButton();
        EditPane.configureButton(this.replaceButton, "replace");
        this.replaceButton.setActionCommand("replace");
        this.replaceButton.addActionListener(this);
        this.toolBar.add(this.replaceButton);
        this.toolBar.addSeparator();
        this.insertBeforeButton = new JToggleButton();
        EditPane.configureButton(this.insertBeforeButton, "insertBefore");
        this.insertBeforeButton.setActionCommand("insertBefore");
        this.insertBeforeButton.addActionListener(this);
        this.toolBar.add(this.insertBeforeButton);
        this.insertButton = new JToggleButton();
        EditPane.configureButton(this.insertButton, "insert");
        this.insertButton.setActionCommand("insert");
        this.insertButton.addActionListener(this);
        this.toolBar.add(this.insertButton);
        this.insertAfterButton = new JToggleButton();
        EditPane.configureButton(this.insertAfterButton, "insertAfter");
        this.insertAfterButton.setActionCommand("insertAfter");
        this.insertAfterButton.addActionListener(this);
        this.toolBar.add(this.insertAfterButton);
        this.toolBar.addSeparator();
        this.convertButton = new JToggleButton();
        EditPane.configureButton(this.convertButton, "convert");
        this.convertButton.setActionCommand("convert");
        this.convertButton.addActionListener(this);
        this.toolBar.add(this.convertButton);
        this.wrapButton = new JToggleButton();
        EditPane.configureButton(this.wrapButton, "wrap");
        this.wrapButton.setActionCommand("wrap");
        this.wrapButton.addActionListener(this);
        this.toolBar.add(this.wrapButton);
        DialogUtil.configureToolBar(this.toolBar);
    }

    private static final void configureButton(AbstractButton abstractButton, String string) {
        Image image = ImageResource.get(class$com$xmlmind$xmleditapp$kit$part$EditPane == null ? (class$com$xmlmind$xmleditapp$kit$part$EditPane = EditPane.class$("com.xmlmind.xmleditapp.kit.part.EditPane")) : class$com$xmlmind$xmleditapp$kit$part$EditPane, string + ".gif");
        abstractButton.setIcon(new ImageIcon(image));
        abstractButton.setToolTipText(Msg.msg(string));
    }

    public void fieldSelected(FieldChooserEvent fieldChooserEvent) {
        FieldChoice fieldChoice = fieldChooserEvent.getChoice();
        if (fieldChoice == null) {
            this.cancel();
            return;
        }
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView == null) {
            return;
        }
        if (this.pendingCommand == this.insertCommand) {
            if (this.insertCommand.prepareCommand(documentView, this.pendingCommandParameter, -1, -1)) {
                this.insertCommand.executeCommand(documentView, this.pendingCommandParameter, fieldChoice);
            }
        } else if (this.pendingCommand == this.convertCommand) {
            if (this.convertCommand.prepareCommand(documentView, this.pendingCommandParameter, -1, -1)) {
                this.convertCommand.executeCommand(documentView, this.pendingCommandParameter, fieldChoice);
            }
        } else if (this.pendingCommand == this.wrapCommand) {
            if (this.wrapCommand.prepareCommand(documentView, this.pendingCommandParameter, -1, -1)) {
                this.wrapCommand.executeCommand(documentView, this.pendingCommandParameter, fieldChoice);
            }
        } else if (this.pendingCommand == this.replaceCommand && this.replaceCommand.prepareCommand(documentView, this.pendingCommandParameter, -1, -1)) {
            this.replaceCommand.executeCommand(documentView, this.pendingCommandParameter, fieldChoice);
        }
        documentView.requestFocus();
    }

    private void cancel() {
        DocumentView documentView;
        if (this.pendingCommand != null) {
            this.unsetPendingCommand();
        }
        if ((documentView = this.app.getActiveDocumentView()) != null) {
            documentView.requestFocus();
        }
    }

    private void unsetPendingCommand() {
        this.fieldChooser.clearForm();
        this.pendingCommand = null;
        this.pendingCommandParameter = null;
        this.replaceButton.setSelected(false);
        this.insertBeforeButton.setSelected(false);
        this.insertButton.setSelected(false);
        this.insertAfterButton.setSelected(false);
        this.convertButton.setSelected(false);
        this.wrapButton.setSelected(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("replace")) {
            this.replace();
        } else if (string.equals("insertBefore")) {
            this.insertBefore();
        } else if (string.equals("insert")) {
            this.insert();
        } else if (string.equals("insertAfter")) {
            this.insertAfter();
        } else if (string.equals("convert")) {
            this.convert();
        } else if (string.equals("wrap")) {
            this.wrap();
        } else if (string.equals("cancel")) {
            this.cancel();
        }
    }

    private void replace() {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null && this.replaceCommand.prepareCommand(documentView, replaceParameter, -1, -1)) {
            this.replaceCommand.prepareEditPane(documentView, replaceParameter, -1, -1);
        }
    }

    private void insertBefore() {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null && this.insertCommand.prepareCommand(documentView, insertBeforeParameter, -1, -1)) {
            this.insertCommand.prepareEditPane(documentView, insertBeforeParameter, -1, -1);
        }
    }

    private void insert() {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null && this.insertCommand.prepareCommand(documentView, insertParameter, -1, -1)) {
            this.insertCommand.prepareEditPane(documentView, insertParameter, -1, -1);
        }
    }

    private void insertAfter() {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null && this.insertCommand.prepareCommand(documentView, insertAfterParameter, -1, -1)) {
            this.insertCommand.prepareEditPane(documentView, insertAfterParameter, -1, -1);
        }
    }

    private void convert() {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null && this.convertCommand.prepareCommand(documentView, convertParameter, -1, -1)) {
            this.convertCommand.prepareEditPane(documentView, convertParameter, -1, -1);
        }
    }

    private void wrap() {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null && this.wrapCommand.prepareCommand(documentView, wrapParameter, -1, -1)) {
            this.wrapCommand.prepareEditPane(documentView, wrapParameter, -1, -1);
        }
    }

    public void prepare(ChooseFieldCommand.FieldChoices fieldChoices, Command command, String string) {
        this.fieldChooser.fillForm(fieldChoices.choices, fieldChoices.context);
        this.pendingCommand = command;
        this.pendingCommandParameter = string;
        boolean bl = this.pendingCommand == this.replaceCommand;
        this.replaceButton.setSelected(bl);
        bl = this.pendingCommand == this.insertCommand && this.pendingCommandParameter.startsWith("before");
        this.insertBeforeButton.setSelected(bl);
        bl = this.pendingCommand == this.insertCommand && this.pendingCommandParameter.startsWith("into");
        this.insertButton.setSelected(bl);
        bl = this.pendingCommand == this.insertCommand && this.pendingCommandParameter.startsWith("after");
        this.insertAfterButton.setSelected(bl);
        bl = this.pendingCommand == this.convertCommand;
        this.convertButton.setSelected(bl);
        bl = this.pendingCommand == this.wrapCommand;
        this.wrapButton.setSelected(bl);
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.fieldChooser.getTextField().requestFocus();
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setHelpId(String string) {
        this.helpId = string;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
        Command command = Commands.getCommand("replace");
        if (command == null || !(command instanceof ReplaceCmd)) {
            throw new IllegalStateException("an instance of 'com.xmlmind.xmleditapp.kit.part.ReplaceCmd' should have been registered as command 'replace'");
        }
        this.replaceCommand = (ReplaceCmd)command;
        this.replaceCommand.initApp(app);
        command = Commands.getCommand("insert");
        if (command == null || !(command instanceof InsertCmd)) {
            throw new IllegalStateException("an instance of 'com.xmlmind.xmleditapp.kit.part.InsertCmd' should have been registered as command 'insert'");
        }
        this.insertCommand = (InsertCmd)command;
        this.insertCommand.initApp(app);
        command = Commands.getCommand("convert");
        if (command == null || !(command instanceof ConvertCmd)) {
            throw new IllegalStateException("an instance of 'com.xmlmind.xmleditapp.kit.part.ConvertCmd' should have been registered as command 'convert'");
        }
        this.convertCommand = (ConvertCmd)command;
        this.convertCommand.initApp(app);
        command = Commands.getCommand("wrap");
        if (command == null || !(command instanceof WrapCmd)) {
            throw new IllegalStateException("an instance of 'com.xmlmind.xmleditapp.kit.part.WrapCmd' should have been registered as command 'wrap'");
        }
        this.wrapCommand = (WrapCmd)command;
        this.wrapCommand.initApp(app);
        this.replaceAction = (EditAction)app.getPart("replaceAction");
        if (this.replaceAction == null) {
            throw new IllegalStateException("AppPart 'replaceAction' must be added before 'editPane'");
        }
        this.insertBeforeAction = (EditAction)app.getPart("insertBeforeAction");
        if (this.insertBeforeAction == null) {
            throw new IllegalStateException("AppPart 'insertBeforeAction' must be added before 'editPane'");
        }
        this.insertAction = (EditAction)app.getPart("insertAction");
        if (this.insertAction == null) {
            throw new IllegalStateException("AppPart 'insertAction' must be added before 'editPane'");
        }
        this.insertAfterAction = (EditAction)app.getPart("insertAfterAction");
        if (this.insertAfterAction == null) {
            throw new IllegalStateException("AppPart 'insertAfterAction' must be added before 'editPane'");
        }
        this.convertAction = (EditAction)app.getPart("convertAction");
        if (this.convertAction == null) {
            throw new IllegalStateException("AppPart 'convertAction' must be added before 'editPane'");
        }
        this.wrapAction = (EditAction)app.getPart("wrapAction");
        if (this.wrapAction == null) {
            throw new IllegalStateException("AppPart 'wrapAction' must be added before 'editPane'");
        }
        replaceParameter = this.replaceAction.getParameter();
        insertBeforeParameter = this.insertBeforeAction.getParameter();
        insertParameter = this.insertAction.getParameter();
        insertAfterParameter = this.insertAfterAction.getParameter();
        convertParameter = this.convertAction.getParameter();
        wrapParameter = this.wrapAction.getParameter();
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
    }

    public void flushPreferences() {
    }

    public void activeEditorChanged() {
        this.editingContextChanged();
    }

    public void editingContextChanged() {
        this.replaceButton.setEnabled(this.replaceAction.isEnabled());
        this.insertBeforeButton.setEnabled(this.insertBeforeAction.isEnabled());
        this.insertButton.setEnabled(this.insertAction.isEnabled());
        this.insertAfterButton.setEnabled(this.insertAfterAction.isEnabled());
        this.convertButton.setEnabled(this.convertAction.isEnabled());
        this.wrapButton.setEnabled(this.wrapAction.isEnabled());
        if (this.pendingCommand != null) {
            this.unsetPendingCommand();
        }
    }

    public boolean isEditingContextSensitive() {
        return true;
    }

    public void namespacePrefixesChanged() {
        this.editingContextChanged();
    }

    public void validityStateChanged() {
    }

    public void saveStateChanged() {
    }

    public void undoStateChanged() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

