/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.dialog.CharacterPane;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class InsertCharacterPane
extends CharacterPane
implements AppPane {
    private String label;
    private Icon icon;
    private String helpId;
    private App app;
    private String id;

    public InsertCharacterPane() {
        this.setShowingFavorites(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentView documentView = InsertCharacterPane.this.app.getActiveDocumentView();
                if (documentView != null) {
                    documentView.requestFocus();
                }
            }
        };
        this.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
    }

    protected void copyToClipboard() {
        super.copyToClipboard();
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null) {
            documentView.getMarkManager().notifyContextChangeListeners();
        }
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setHelpId(String string) {
        this.helpId = string;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
        int n;
        char[] cArray;
        Preferences preferences = this.app.getPreferences();
        String string = preferences.getString("favoriteCharsInTable", null);
        char[] cArray2 = cArray = string == null ? null : string.toCharArray();
        if (!InsertCharacterPane.sameCharArray(cArray, this.getFavorites())) {
            this.setFavorites(cArray);
        }
        if ((n = preferences.getInt("firstCharDisplayedByTable", 0, 65535, 0)) != this.getFirstDisplayedChar()) {
            this.setFirstDisplayedChar((char)n);
        }
    }

    private static final boolean sameCharArray(char[] cArray, char[] cArray2) {
        if (cArray == null) {
            return cArray2 == null;
        }
        if (cArray2 == null) {
            return cArray == null;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] != cArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void flushPreferences() {
        Preferences preferences = this.app.getPreferences();
        preferences.putInt("firstCharDisplayedByTable", this.getFirstDisplayedChar());
        char[] cArray = this.getFavorites();
        if (cArray == null) {
            preferences.remove("favoriteCharsInTable");
        } else {
            preferences.putString("favoriteCharsInTable", new String(cArray));
        }
    }

    public void activeEditorChanged() {
        this.setDocumentView(this.app.getActiveDocumentView());
    }

    public void validityStateChanged() {
    }

    public void namespacePrefixesChanged() {
    }

    public void saveStateChanged() {
    }

    public void undoStateChanged() {
    }

    public void editingContextChanged() {
    }

    public boolean isEditingContextSensitive() {
        return false;
    }
}

