/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.dialog.NodePath;
import com.xmlmind.xmledit.dialog.NodePathEvent;
import com.xmlmind.xmledit.dialog.NodePathListener;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doctype.UncheckedElementType;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.doctype.UnconstrainedElementType;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.edit.Editor;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppTool;
import com.xmlmind.xmleditapp.kit.part.Msg;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class NodePathTool
extends NodePath
implements AppTool,
NodePathListener,
ActionListener {
    private String helpId;
    private App app;
    private String id;
    private JPopupMenu popupMenu;
    private int annotate = 0;
    private static final int ANNOTATE_NONE = 0;
    private static final int ANNOTATE_UNCHECKED = 1;
    private static final int ANNOTATE_UNCONSTRAINED = 2;
    private static final float[] PATTERN = new float[]{2.0f, 2.0f};
    private static final BasicStroke STROKE1 = new BasicStroke(0.01f, 2, 0, 10.0f, PATTERN, 0.0f);
    private static final BasicStroke STROKE2 = new BasicStroke(0.01f, 2, 0, 10.0f, PATTERN, 2.0f);

    public NodePathTool() {
        JLabel jLabel = new JLabel();
        Color color = jLabel.getBackground();
        Color color2 = jLabel.getForeground();
        Font font = jLabel.getFont();
        this.setDragEnabled(false);
        this.setFont(font);
        this.setForeground(color2);
        this.setBackground(color);
        Color color3 = color.darker().darker();
        this.setSeparatorColor(color3);
        this.setSeparatorRelief(2);
        color3 = new Color(color3.getRed(), color3.getGreen(), Math.min(255, color3.getBlue() + 32));
        this.setReadOnlyColor(color3);
        this.setBorderRelief(1);
        this.addNodePathListener(this);
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = this.popupMenu.add(Msg.msg("insertSameElementAfter"));
        jMenuItem.setActionCommand("insertSameElementAfter");
        jMenuItem.addActionListener(this);
        jMenuItem = this.popupMenu.add(Msg.msg("insertSameElementBefore"));
        jMenuItem.setActionCommand("insertSameElementBefore");
        jMenuItem.addActionListener(this);
        jMenuItem = this.popupMenu.add(Msg.msg("deleteNode"));
        jMenuItem.setActionCommand("deleteNode");
        jMenuItem.addActionListener(this);
        this.popupMenu.addSeparator();
        jMenuItem = this.popupMenu.add(Msg.msg("copyXPath"));
        jMenuItem.setActionCommand("copyXPath");
        jMenuItem.addActionListener(this);
        this.popupMenu.pack();
    }

    protected void paintItems(Graphics graphics, Dimension dimension) {
        if (this.annotate != 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getDescent();
            int n2 = this.marginHeight + fontMetrics.getAscent() + n - 1;
            int n3 = Math.min(this.intrinsicSize.width, dimension.width) - this.marginWidth - 1;
            int n4 = this.items.length - 1;
            int n5 = n3 - this.items[n4].width;
            if (!(this.items[n4].node instanceof Element)) {
                n5 -= this.separatorSize + this.items[n4 - 1].width;
            }
            if (this.annotate == 1) {
                graphics.setColor(Color.orange);
            } else {
                graphics.setColor(Color.red);
            }
            if (n > 2) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(STROKE1);
                graphics2D.drawLine(n5, n2, n3, n2);
                graphics2D.setStroke(STROKE2);
                graphics2D.drawLine(n5, --n2, n3, n2);
            } else {
                graphics.drawLine(n5, n2, n3, n2);
            }
        }
        super.paintItems(graphics, dimension);
    }

    public void nodeSelected(NodePathEvent nodePathEvent) {
        int n = PlatformUtil.IS_MAC_OS ? 4 : 2;
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null) {
            Node node = nodePathEvent.getNode();
            int n2 = nodePathEvent.getModifiers();
            if (n2 == 16) {
                documentView.selectNode(node);
            } else if (n2 == 17) {
                documentView.selectNode(node);
                documentView.executeCommand("insertNode", "sameElementBefore", -1, -1);
            } else if (n2 == (0x10 | n)) {
                documentView.selectNode(node);
                documentView.executeCommand("insertNode", "sameElementAfter", -1, -1);
            } else if (n2 == 4 || PlatformUtil.IS_MAC_OS && n2 == 18) {
                documentView.selectNode(node);
                JMenuItem jMenuItem = (JMenuItem)this.popupMenu.getComponent(0);
                if (node instanceof Element) {
                    NodePathTool.setEnabled(jMenuItem, documentView, "insertNode", "sameElementAfter");
                } else {
                    jMenuItem.setEnabled(false);
                }
                jMenuItem = (JMenuItem)this.popupMenu.getComponent(1);
                if (node instanceof Element) {
                    NodePathTool.setEnabled(jMenuItem, documentView, "insertNode", "sameElementBefore");
                } else {
                    jMenuItem.setEnabled(false);
                }
                jMenuItem = (JMenuItem)this.popupMenu.getComponent(2);
                NodePathTool.setEnabled(jMenuItem, documentView, "delete", null);
                Point point = nodePathEvent.getPoint();
                this.popupMenu.show(this, point.x, point.y);
            }
        }
    }

    private static final void setEnabled(JMenuItem jMenuItem, DocumentView documentView, String string, String string2) {
        boolean bl = false;
        Command command = Commands.getCommand(string);
        if (command != null) {
            bl = command.prepareCommand(documentView, string2, -1, -1);
        }
        jMenuItem.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null) {
            Node node;
            String string = actionEvent.getActionCommand();
            if ("insertSameElementAfter".equals(string)) {
                documentView.executeCommand("insertNode", "sameElementAfter", -1, -1);
            } else if ("insertSameElementBefore".equals(string)) {
                documentView.executeCommand("insertNode", "sameElementBefore", -1, -1);
            } else if ("deleteNode".equals(string)) {
                documentView.executeCommand("delete", null, -1, -1);
            } else if ("copyXPath".equals(string) && (node = documentView.getSelectedNode(false)) != null) {
                Clipboard.put(this, node.toXPath());
                documentView.getMarkManager().notifyContextChangeListeners();
            }
        }
    }

    public void setHelpId(String string) {
        this.helpId = string;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
    }

    public void flushPreferences() {
    }

    public void activeEditorChanged() {
        this.editingContextChanged();
    }

    public void editingContextChanged() {
        Object object;
        Object object2;
        Object object3;
        Node node = null;
        this.annotate = 0;
        DocumentView documentView = this.app.getActiveDocumentView();
        if (documentView != null) {
            object3 = documentView.getMarkManager();
            object2 = ((MarkManager)object3).getSelected();
            if (object2 == null) {
                object = ((MarkManager)object3).getDot();
                if (object != null) {
                    node = ((TextLocation)object).getNode();
                    TextLocation textLocation = ((MarkManager)object3).getMark();
                    if (textLocation == null || textLocation.getTextNode() == ((TextLocation)object).getTextNode() && textLocation.getOffset() == ((TextLocation)object).getOffset()) {
                        this.annotate = 2;
                    }
                }
            } else {
                node = ((NodeMark)object2).getNode();
                this.annotate = 2;
            }
        }
        if (this.annotate != 0) {
            this.annotate = 0;
            object3 = documentView.getElementEditor();
            if (!(((Editor)object3).getDocumentType() instanceof UnconstrainedDocumentType) && (object2 = node instanceof Element ? (Element)node : node.getParentElement()) != null) {
                ((ElementEditor)object3).editElement((Element)object2);
                object = ((ElementEditor)object3).getEditedElementType();
                if (object instanceof UncheckedElementType) {
                    this.annotate = 1;
                } else if (object instanceof UnconstrainedElementType) {
                    this.annotate = 2;
                }
            }
        }
        this.setNode(node);
    }

    public boolean isEditingContextSensitive() {
        return true;
    }

    public void namespacePrefixesChanged() {
        this.setNode(this.getNode());
    }

    public void validityStateChanged() {
    }

    public void saveStateChanged() {
    }

    public void undoStateChanged() {
    }
}

