/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.OpenDocumentAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.URLHistory;
import com.xmlmind.xmleditapp.kit.part.ChooseURLSupport;
import com.xmlmind.xmleditapp.kit.part.Msg;
import com.xmlmind.xmleditapp.kit.part.RecordCommandSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;

public class OpenAction
extends LengthyAction
implements OpenDocumentAction,
Command,
RecordCommandSupport.ExecutableStep {
    protected URL inURL;

    protected boolean init() {
        this.inURL = ChooseURLSupport.getInstance(this.app).selectOpenURL();
        return this.inURL != null;
    }

    protected void exec() {
        this.doExec();
    }

    protected Object doExec() {
        if (!this.canDiscardChangesBeforeOpening(this.inURL)) {
            return Command.EXECUTION_FAILED;
        }
        OpenedDocument openedDocument = this.app.createOpenedDocument();
        if (!openedDocument.opening(this.inURL)) {
            return Command.EXECUTION_FAILED;
        }
        if (!openedDocument.open(this.inURL)) {
            this.app.getDialogParent().getToolkit().beep();
            ChooseURLSupport.getInstance(this.app).removeFromHistory(this.inURL);
            return Command.EXECUTION_FAILED;
        }
        this.app.addOpenedDocument(openedDocument);
        ChooseURLSupport.getInstance(this.app).addToHistory(this.inURL);
        if (openedDocument.canCheckValidity()) {
            openedDocument.checkValidity();
        }
        return openedDocument.getDocument();
    }

    protected boolean canDiscardChangesBeforeOpening(URL uRL) {
        return this.checkOpenedDocument(uRL);
    }

    protected boolean checkOpenedDocument(URL uRL) {
        OpenedDocument openedDocument = this.app.getOpenedDocument(uRL);
        if (openedDocument != null) {
            if (openedDocument.isSaveNeeded() && !this.canRevertToSaved(openedDocument)) {
                return false;
            }
            if (!openedDocument.closing()) {
                return false;
            }
            this.app.removeOpenedDocument(openedDocument);
        }
        return true;
    }

    protected boolean canRevertToSaved(OpenedDocument openedDocument) {
        int n = JOptionPane.showConfirmDialog(this.app.getDialogParent(), Msg.msg("revertToSaved", openedDocument.getLabel()), Msg.msg("confirm"), 2);
        return n == 0;
    }

    public void updateEnabled() {
    }

    public void applyPreferences() {
        URLHistory uRLHistory = URLHistory.fromStrings(this.app.getPreferences().getStrings("lastOpenedFiles", null));
        this.app.putProperty("lastOpenedFiles", uRLHistory);
    }

    public void flushPreferences() {
        URLHistory uRLHistory = (URLHistory)this.app.getProperty("lastOpenedFiles");
        if (uRLHistory != null) {
            this.app.getPreferences().putStrings("lastOpenedFiles", uRLHistory.toStrings());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openDocument(URL uRL) {
        Object object;
        this.inURL = uRL;
        this.app.waitCursor(true);
        try {
            object = this.doExec();
            Object var4_3 = null;
            this.app.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.app.waitCursor(false);
            throw throwable;
        }
        return object != Command.EXECUTION_FAILED;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        Comparable comparable;
        Document document = ((DocumentView)gadget).getDocument();
        if (document == null) {
            return false;
        }
        this.inURL = null;
        if (string == null || string.length() == 0) {
            return true;
        }
        if ("[reopen]".equals(string) || "[reopenIfNewer]".equals(string)) {
            comparable = this.app.getActiveDocument();
            if (comparable != document) {
                return false;
            }
            this.inURL = ((Tree)comparable).getLocation();
        }
        if (this.inURL == null) {
            try {
                this.inURL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.inURL == null && ((File)(comparable = new File(string))).isFile()) {
            this.inURL = FileUtil.fileToURL((File)comparable);
        }
        return this.inURL != null;
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        return RecordCommandSupport.executeCommand(this, gadget, string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        if (this.inURL == null) {
            if (!this.init()) {
                return Command.EXECUTION_FAILED;
            }
        } else if ("[reopenIfNewer]".equals(string)) {
            OpenedDocument openedDocument;
            long l;
            long l2 = Long.MAX_VALUE;
            File file = FileUtil.urlToFile(this.inURL);
            if (file != null) {
                l2 = file.lastModified();
            }
            if (l2 <= (l = (openedDocument = this.app.getActiveOpenedDocument()).lastSaved())) {
                return openedDocument.getDocument();
            }
        }
        this.app.waitCursor(true);
        try {
            object = this.doExec();
            Object var12_10 = null;
            this.app.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.app.waitCursor(false);
            throw throwable;
        }
        return object;
    }
}

