/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.StyleSheetInfo;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetPrinter;
import com.xmlmind.xmledit.gadget.PrintCanceledException;
import com.xmlmind.xmledit.gadget.PrintInvoker;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleSheet;
import com.xmlmind.xmledit.stylesheet.StyleSheetLoader;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmleditapp.kit.CancelableAction;
import com.xmlmind.xmleditapp.kit.Editor;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.part.Msg;
import com.xmlmind.xmleditapp.kit.part.PageSetupAction;
import java.awt.Color;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.SwingUtilities;

public class PrintAction
extends CancelableAction
implements PrintInvoker {
    private Editor editor;
    private PrinterJob printJob;
    private GadgetPrinter printer;
    private PageFormat pageFormat;
    private StyleSheet savedStyleSheet;
    private boolean printCanceled;
    private String printError;
    private static final char[] VAR_NAMES = new char[]{'F', 'f', 'B', 'D', 'T', 'P'};

    protected boolean init() {
        Gadget gadget;
        NodeView nodeView;
        Font font;
        Object object;
        Object object2;
        Preferences preferences = this.app.getPreferences();
        this.editor = this.app.getActiveEditor();
        this.printJob = PrinterJob.getPrinterJob();
        this.printer = new GadgetPrinter();
        PageSetupAction pageSetupAction = (PageSetupAction)this.app.getPart("pageSetupAction");
        this.pageFormat = pageSetupAction != null ? pageSetupAction.getPageFormat() : new PageFormat();
        this.pageFormat = this.printJob.validatePage(this.pageFormat);
        this.savedStyleSheet = null;
        this.printError = null;
        this.printCanceled = false;
        this.printJob.setPrintable(this.printer, this.pageFormat);
        if (!this.printJob.printDialog()) {
            return false;
        }
        DocumentView documentView = this.editor.getDocumentView();
        OpenedDocument openedDocument = this.editor.getOpenedDocument();
        Node node = documentView.getSelectedNode();
        if (node != null && (object2 = documentView.getSelectedNode2()) != null && object2 != node) {
            node = node.getParentElement();
        }
        object2 = node != null ? Msg.msg("printingSelection", node) : Msg.msg("printingDocument", openedDocument.getLabel());
        this.app.showStatus((String)object2, false);
        this.app.waitCursor(true);
        StyleSheetInfo styleSheetInfo = this.editor.getStyleSheetInfo();
        if (styleSheetInfo != null) {
            object = (StyledViewFactory)documentView.getViewFactory();
            font = ((StyledViewFactory)object).getDefaultStyle().font;
            this.savedStyleSheet = PrintAction.setPrintStyleSheet((StyledViewFactory)object, styleSheetInfo);
        } else {
            font = this.editor.getFont();
        }
        font = new Font(font.getFamily(), 0, Math.max(10, font.getSize() - 2));
        this.printer.setInvoker(this);
        this.printer.setScreenResolution(preferences.getDouble("screenResolutionWhenPrinting", 50.0, 150.0, 100.0));
        object = new Date();
        Object[] objectArray = new Object[]{openedDocument.getLabel(), openedDocument.getShortLabel(), openedDocument.getName(), DateFormat.getDateInstance(3).format((Date)object), DateFormat.getTimeInstance(3).format((Date)object), Msg.msg("pageIndex")};
        boolean bl = false;
        String string = preferences.getString("headerBegin", "");
        if (string.length() > 0) {
            string = PrintAction.substituteHeaderVariables(string, objectArray);
            this.printer.setHeaderBegin(string);
            bl = true;
        }
        if ((string = preferences.getString("headerMiddle", "")).length() > 0) {
            string = PrintAction.substituteHeaderVariables(string, objectArray);
            this.printer.setHeaderMiddle(string);
            bl = true;
        }
        if ((string = preferences.getString("headerEnd", "")).length() > 0) {
            string = PrintAction.substituteHeaderVariables(string, objectArray);
            this.printer.setHeaderEnd(string);
            bl = true;
        }
        if (bl) {
            this.printer.setHeaderFont(font);
            this.printer.setHeaderColor(preferences.getColor("headerColor", Color.gray));
            this.printer.setHeaderUnderlined(preferences.getBoolean("underlineHeader", true));
        }
        bl = false;
        string = preferences.getString("footerBegin", "%f");
        if (string.length() > 0) {
            string = PrintAction.substituteHeaderVariables(string, objectArray);
            this.printer.setFooterBegin(string);
            bl = true;
        }
        if ((string = preferences.getString("footerMiddle", "")).length() > 0) {
            string = PrintAction.substituteHeaderVariables(string, objectArray);
            this.printer.setFooterMiddle(string);
            bl = true;
        }
        if ((string = preferences.getString("footerEnd", "%P")).length() > 0) {
            string = PrintAction.substituteHeaderVariables(string, objectArray);
            this.printer.setFooterEnd(string);
            bl = true;
        }
        if (bl) {
            this.printer.setFooterFont(font);
            this.printer.setFooterColor(preferences.getColor("footerColor", Color.gray));
            this.printer.setFooterOverlined(preferences.getBoolean("overlineFooter", true));
        }
        Gadget gadget2 = documentView;
        if (node != null && (nodeView = documentView.getNodeView(node)) != null && (gadget = documentView.getGadgetContainingView(nodeView)) != null) {
            gadget2 = gadget;
        }
        this.editor.setViewportWidthTracked(false);
        this.printer.begin(gadget2, this.pageFormat);
        return true;
    }

    protected void exec() {
        block3: {
            try {
                this.printJob.print();
            }
            catch (PrintCanceledException printCanceledException) {
                this.printCanceled = true;
            }
            catch (PrinterException printerException) {
                this.printError = printerException.getMessage();
                if (this.printError != null) break block3;
                this.printError = printerException.getClass().getName();
            }
        }
    }

    protected void finish() {
        this.editor.setViewportWidthTracked(true);
        this.printer.end();
        if (this.savedStyleSheet != null) {
            DocumentView documentView = this.editor.getDocumentView();
            StyledViewFactory styledViewFactory = (StyledViewFactory)documentView.getViewFactory();
            styledViewFactory.setStyleSheet(this.savedStyleSheet);
        }
        this.app.waitCursor(false);
        if (this.printError != null) {
            this.app.showStatus("");
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotPrint", this.printError));
        } else if (this.printCanceled) {
            this.app.showStatus(Msg.msg("printingCanceled"));
        } else {
            this.app.showStatus(Msg.msg("printingCompleted"));
        }
        this.editor = null;
        this.printJob = null;
        this.printer = null;
        this.pageFormat = null;
        this.savedStyleSheet = null;
        this.printError = null;
        this.printCanceled = false;
    }

    public boolean printingPage(GadgetPrinter gadgetPrinter, int n, int n2) {
        final String string = Msg.msg("printingPage", new Integer(1 + n), new Integer(n2));
        if (n < n2) {
            if (PlatformUtil.IS_MAC_OS) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PrintAction.this.app.showStatus(string, false);
                    }
                });
            } else {
                String string2 = this.getLabel();
                if ((string2 = DialogUtil.buttonLabel(string2)).endsWith("...")) {
                    string2 = string2.substring(0, string2.length() - 3);
                }
                this.progress(string2, string, 1 + n, n2);
            }
        }
        return !this.isCanceled();
    }

    public void updateEnabled() {
        this.setEnabled(this.app.getActiveEditor() != null);
    }

    private static final StyleSheet setPrintStyleSheet(StyledViewFactory styledViewFactory, StyleSheetInfo styleSheetInfo) {
        StyleSheet styleSheet = styledViewFactory.getStyleSheet();
        if (styleSheet == null) {
            return null;
        }
        String[] stringArray = styleSheet.getOtherMedia();
        if (stringArray != null && StringUtil.contains(stringArray, "print")) {
            StyleSheet styleSheet2 = PrintAction.loadPrintStyleSheet(styleSheetInfo);
            if (styleSheet2 == null) {
                styleSheet = null;
            } else {
                styledViewFactory.setStyleSheet(styleSheet2);
            }
        } else {
            styleSheet = null;
        }
        return styleSheet;
    }

    private static final StyleSheet loadPrintStyleSheet(StyleSheetInfo styleSheetInfo) {
        StyleSheet styleSheet;
        block3: {
            StyleSheetLoader styleSheetLoader = new StyleSheetLoader();
            styleSheetLoader.setHandledMedia(StyleSheetLoader.PRINT);
            try {
                if (styleSheetInfo.content == null) {
                    styleSheet = styleSheetLoader.load(styleSheetInfo.url, null);
                    break block3;
                }
                styleSheet = styleSheetLoader.load(styleSheetInfo.content, styleSheetInfo.url, null);
            }
            catch (Exception exception) {
                styleSheet = null;
            }
        }
        return styleSheet;
    }

    private static final String substituteHeaderVariables(String string, Object[] objectArray) {
        if (string.indexOf(37) < 0) {
            return string;
        }
        return StringUtil.substituteVars(string, VAR_NAMES, objectArray);
    }
}

