/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.kit.AppMenuItems;
import com.xmlmind.xmleditapp.kit.OpenDocumentAction;
import com.xmlmind.xmleditapp.kit.URLHistory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class RecentFilesMenuItems
extends AppMenuItems
implements MenuListener {
    private int firstRecentFileItem;

    public void initMenu(JMenu jMenu) {
        super.initMenu(jMenu);
        this.firstRecentFileItem = jMenu.getItemCount();
        jMenu.addMenuListener(this);
    }

    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        int n = jMenu.getItemCount() - 1;
        while (n >= this.firstRecentFileItem) {
            jMenu.remove(n);
            --n;
        }
        final OpenDocumentAction openDocumentAction = this.app.getOpenDocumentAction();
        if (openDocumentAction == null) {
            return;
        }
        URL[] uRLArray = this.getLastOpenedFiles();
        if (uRLArray == null) {
            return;
        }
        if (this.firstRecentFileItem > 0) {
            jMenu.addSeparator();
        }
        int n2 = Math.min(9, uRLArray.length);
        int n3 = 0;
        while (n3 < n2) {
            final URL uRL = uRLArray[n3];
            StringBuffer stringBuffer = new StringBuffer();
            String string = Integer.toString(1 + n3);
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(URLUtil.toShortLabel(uRL, 40));
            JMenuItem jMenuItem = jMenu.add(stringBuffer.toString());
            AppMenuItems.setNonIconic(jMenuItem);
            if (n3 < 9) {
                jMenuItem.setMnemonic(string.charAt(0));
                jMenuItem.setDisplayedMnemonicIndex(0);
            }
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    openDocumentAction.openDocument(uRL);
                }
            });
            ++n3;
        }
    }

    private URL[] getLastOpenedFiles() {
        URL[] uRLArray = null;
        URLHistory uRLHistory = (URLHistory)this.app.getProperty("lastOpenedFiles");
        if (uRLHistory != null && uRLHistory.size() > 0) {
            uRLArray = uRLHistory.getAll();
        }
        return uRLArray;
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void activeEditorChanged() {
        if (this.firstRecentFileItem == 0) {
            this.menu.setEnabled(this.getLastOpenedFiles() != null);
        }
    }
}

