/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.part.ChooseURLSupport;
import com.xmlmind.xmleditapp.kit.part.Msg;
import com.xmlmind.xmleditapp.kit.part.RecordCommandSupport;
import java.net.URL;

public class SaveAction
extends LengthyAction
implements Command,
RecordCommandSupport.ExecutableStep {
    protected URL outURL;

    protected boolean init() {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument == null) {
            return false;
        }
        if (openedDocument.isSaveNeeded()) {
            if (openedDocument.isSaveAsNeeded()) {
                this.outURL = ChooseURLSupport.getInstance(this.app).selectSaveURL(openedDocument.getLocation());
                return this.outURL != null;
            }
            this.outURL = null;
            return true;
        }
        return false;
    }

    protected void exec() {
        this.doExec();
    }

    protected Object doExec() {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        Preferences preferences = this.app.getPreferences();
        if (openedDocument.canCheckValidity() && openedDocument.checkValidity() != null && preferences.getBoolean("showValidityPaneOnSave", false)) {
            this.app.ensurePartIsVisible("checkValidityPane");
        }
        String string = this.outURL == null ? openedDocument.getLabel() : URLUtil.toLabel(this.outURL);
        this.app.showStatus(Msg.msg("savingDocument", string), false);
        if (!((this.outURL != null || openedDocument.saving() && openedDocument.save()) && (this.outURL == null || openedDocument.savingAs(this.outURL) && openedDocument.saveAs(this.outURL)))) {
            this.app.showStatus("", true);
            return Command.EXECUTION_FAILED;
        }
        this.app.showStatus(Msg.msg("documentSaved", string), true);
        if (this.outURL != null) {
            ChooseURLSupport.getInstance(this.app).addToHistory(this.outURL);
        }
        return null;
    }

    public void updateEnabled() {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        this.setEnabled(openedDocument != null && openedDocument.isSaveNeeded());
    }

    public void saveStateChanged() {
        this.updateEnabled();
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        return this.app.getActiveDocument() == ((DocumentView)gadget).getDocument() && (this.isEnabled() || "[ifNeeded]".equals(string));
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        return RecordCommandSupport.executeCommand(this, gadget, string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        if (!this.isEnabled()) {
            return null;
        }
        if (!this.init()) {
            return Command.EXECUTION_FAILED;
        }
        this.app.waitCursor(true);
        try {
            object = this.doExec();
            Object var7_6 = null;
            this.app.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.app.waitCursor(false);
            throw throwable;
        }
        return object;
    }
}

