/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.part.ChooseURLSupport;
import com.xmlmind.xmleditapp.kit.part.Msg;
import com.xmlmind.xmleditapp.kit.part.RecordCommandSupport;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;

public class SaveAsAction
extends LengthyAction
implements Command,
RecordCommandSupport.ExecutableStep {
    protected boolean saveCopy;
    protected URL outURL;

    public SaveAsAction() {
        this(false);
    }

    protected SaveAsAction(boolean bl) {
        this.saveCopy = bl;
    }

    protected boolean init() {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument == null) {
            return false;
        }
        this.outURL = ChooseURLSupport.getInstance(this.app).selectSaveURL(openedDocument.getLocation());
        return this.outURL != null;
    }

    protected void exec() {
        this.doExec();
    }

    protected Object doExec() {
        Document document;
        if (!this.checkOpenedDocument(this.outURL)) {
            return Command.EXECUTION_FAILED;
        }
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        Preferences preferences = this.app.getPreferences();
        if (openedDocument.canCheckValidity() && openedDocument.checkValidity() != null && preferences.getBoolean("showValidityPaneOnSave", false)) {
            this.app.ensurePartIsVisible("checkValidityPane");
        }
        String string = URLUtil.toLabel(this.outURL);
        this.app.showStatus(Msg.msg("savingDocument", string), false);
        if (!((!this.saveCopy || (document = openedDocument.savingCopy(this.outURL)) != null && openedDocument.saveCopy(document, this.outURL)) && (this.saveCopy || openedDocument.savingAs(this.outURL) && openedDocument.saveAs(this.outURL)))) {
            this.app.showStatus("", true);
            return Command.EXECUTION_FAILED;
        }
        this.app.showStatus(Msg.msg("documentSaved", string), true);
        if (!this.saveCopy) {
            ChooseURLSupport.getInstance(this.app).addToHistory(this.outURL);
        }
        return null;
    }

    protected boolean checkOpenedDocument(URL uRL) {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        URL uRL2 = openedDocument.getLocation();
        if (uRL.equals(uRL2)) {
            return true;
        }
        OpenedDocument openedDocument2 = this.app.getOpenedDocument(uRL);
        if (openedDocument2 != null) {
            if (openedDocument2.isSaveNeeded() && !this.canDiscardOpenedDocument(uRL, openedDocument.getLabel())) {
                return false;
            }
            if (!openedDocument2.closing()) {
                return false;
            }
            this.app.removeOpenedDocument(openedDocument2);
        }
        return true;
    }

    protected boolean canDiscardOpenedDocument(URL uRL, String string) {
        int n = JOptionPane.showConfirmDialog(this.app.getDialogParent(), Msg.msg("saveAsOpenedDocument", URLUtil.toLabel(uRL), string), Msg.msg("confirm"), 2);
        return n == 0;
    }

    public void updateEnabled() {
        this.setEnabled(this.app.getActiveOpenedDocument() != null);
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        if (!this.isEnabled() || this.app.getActiveDocument() != ((DocumentView)gadget).getDocument()) {
            return false;
        }
        this.outURL = null;
        if (string == null || string.length() == 0) {
            return true;
        }
        try {
            this.outURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.outURL == null) {
            this.outURL = FileUtil.fileToURL(string);
        }
        return this.outURL != null;
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        return RecordCommandSupport.executeCommand(this, gadget, string, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        if (this.outURL == null && !this.init()) {
            return Command.EXECUTION_FAILED;
        }
        this.app.waitCursor(true);
        try {
            object = this.doExec();
            Object var7_6 = null;
            this.app.waitCursor(false);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.app.waitCursor(false);
            throw throwable;
        }
        return object;
    }
}

