/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.edit.StyleSheetInfo;
import com.xmlmind.xmledit.guiutil.ItemChooserDialog;
import com.xmlmind.xmledit.guiutil.LabeledValue;
import com.xmlmind.xmleditapp.kit.Editor;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.part.Msg;

public class SetStyleSheetAction
extends LengthyAction {
    private static final StyleSheetInfo NO_STYLE_SHEET = new StyleSheetInfo();
    private StyleSheetInfo styleSheetInfo;
    private boolean prompt = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStyleSheet(StyleSheetInfo styleSheetInfo) {
        if (styleSheetInfo == null) {
            styleSheetInfo = NO_STYLE_SHEET;
        }
        this.styleSheetInfo = styleSheetInfo;
        this.prompt = false;
        try {
            this.doIt();
            Object var3_2 = null;
            this.prompt = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.prompt = true;
            throw throwable;
        }
    }

    protected boolean init() {
        if (this.prompt) {
            this.styleSheetInfo = this.chooseStyleSheet();
            if (this.styleSheetInfo == null) {
                return false;
            }
        }
        return true;
    }

    private StyleSheetInfo chooseStyleSheet() {
        Object object;
        Editor editor = this.app.getActiveEditor();
        if (editor == null) {
            return null;
        }
        StyleSheetInfo[] styleSheetInfoArray = editor.getOpenedDocument().getStyleSheetInfo();
        Object[] objectArray = new LabeledValue[1 + (styleSheetInfoArray == null ? 0 : styleSheetInfoArray.length)];
        int n = 0;
        objectArray[0] = new LabeledValue(Msg.msg("noStyleSheet"), NO_STYLE_SHEET);
        if (styleSheetInfoArray != null) {
            object = editor.getStyleSheetInfo();
            int n2 = 0;
            while (n2 < styleSheetInfoArray.length) {
                StyleSheetInfo styleSheetInfo = styleSheetInfoArray[n2];
                objectArray[1 + n2] = new LabeledValue(styleSheetInfo.getLabel(), styleSheetInfo);
                if (styleSheetInfo == object) {
                    n = 1 + n2;
                }
                ++n2;
            }
        }
        object = new ItemChooserDialog(this.app.getDialogParent(), Msg.msg("chooseStyleSheet"), 10, 40);
        ((ItemChooserDialog)object).setSingleClick(true);
        LabeledValue labeledValue = (LabeledValue)((ItemChooserDialog)object).chooseItem(objectArray, n);
        if (labeledValue == null) {
            return null;
        }
        return (StyleSheetInfo)labeledValue.value;
    }

    protected void exec() {
        boolean bl;
        Editor editor = this.app.getActiveEditor();
        if (editor == null) {
            return;
        }
        if (this.styleSheetInfo == NO_STYLE_SHEET) {
            this.styleSheetInfo = null;
        }
        boolean bl2 = bl = this.styleSheetInfo != null && editor.getStyleSheetInfo() == this.styleSheetInfo;
        if (bl) {
            this.app.showStatus(Msg.msg("reloadingStyleSheet", this.styleSheetInfo.getLabel()), false);
        }
        boolean bl3 = editor.setStyleSheet(this.styleSheetInfo);
        if (bl) {
            if (bl3) {
                this.app.showStatus(Msg.msg("styleSheetReloaded", this.styleSheetInfo.getLabel()), true);
            } else {
                this.app.showStatus("", true);
            }
        }
        this.styleSheetInfo = null;
    }

    public void updateEnabled() {
        this.setEnabled(this.app.getActiveEditor() != null);
    }
}

