/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.part;

import com.xmlmind.xmledit.spell.SpellCheckerFactory;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppPart;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SpellOptionsPart
implements AppPart {
    private App app;
    private String id;

    public void initApp(App app, String string) {
        this.app = app;
        this.id = string;
        URL[] uRLArray = app.getDictionaryURLs();
        if (uRLArray.length > 0) {
            try {
                this.defineDictionaries(uRLArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.setPersonalDictionaryPath();
        }
        catch (IOException iOException) {}
    }

    private void defineDictionaries(URL[] uRLArray) throws IOException {
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            File file = FileUtil.urlToFile(uRL);
            if (file == null) {
                this.defineDictionary(uRL);
            } else {
                this.defineDictionaries(file, uRL);
            }
            ++n;
        }
    }

    private void defineDictionary(URL uRL) throws IOException {
        String string = URIUtil.unescape(URLUtil.getRawBaseName(uRL));
        int n = string.length();
        if (n < 6 || !string.endsWith(".dar")) {
            return;
        }
        String string2 = string.substring(0, n - 4);
        String string3 = string2 + "/default";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jar:");
        stringBuffer.append(uRL.toExternalForm());
        stringBuffer.append("!/");
        stringBuffer.append(string3);
        URL uRL2 = null;
        try {
            uRL2 = new URL(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 != null) {
            SpellCheckerFactory.defineDictionary(string3, uRL2);
        }
    }

    private void defineDictionaries(File file, URL uRL) throws IOException {
        String string = file.getName();
        if (string.length() < 6 || !string.endsWith(".dar")) {
            return;
        }
        String string2 = uRL.toExternalForm();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string3 = zipEntry.getName();
            if (string3.length() <= 8 || !string3.endsWith("/default")) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("jar:");
            stringBuffer.append(string2);
            stringBuffer.append("!/");
            stringBuffer.append(string3);
            URL uRL2 = null;
            try {
                uRL2 = new URL(stringBuffer.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL2 == null) continue;
            SpellCheckerFactory.defineDictionary(string3, uRL2);
        }
        zipFile.close();
    }

    private void setPersonalDictionaryPath() throws IOException {
        File file = null;
        File file2 = this.app.getUserPreferencesDirectory();
        if (file2 != null && !(file = new File(file2, "spell")).isDirectory()) {
            file = null;
        }
        if (file == null) {
            String string = PlatformUtil.tmpDir();
            file = new File(string == null ? "." : string);
        }
        SpellCheckerFactory.setPersonalDictionaryPath(file.getCanonicalPath() + File.separatorChar + "dict_%L%.txt");
    }

    public App getApp() {
        return this.app;
    }

    public String getId() {
        return this.id;
    }

    public void applyPreferences() {
        Preferences preferences = this.app.getPreferences();
        boolean bl = preferences.getBoolean("ignoreCase", false);
        boolean bl2 = preferences.getBoolean("ignoreMixedCase", false);
        boolean bl3 = preferences.getBoolean("ignoreDigits", true);
        boolean bl4 = preferences.getBoolean("ignoreURL", true);
        boolean bl5 = preferences.getBoolean("ignoreDuplicates", false);
        boolean bl6 = preferences.getBoolean("checkPunctuation", false);
        boolean bl7 = preferences.getBoolean("allowCompound", true);
        boolean bl8 = preferences.getBoolean("allowPrefixes", true);
        boolean bl9 = preferences.getBoolean("allowFileExtensions", true);
        boolean bl10 = preferences.getBoolean("maxSuggestionForce", false);
        SpellCheckerFactory.setIgnoreCase(bl);
        SpellCheckerFactory.setIgnoreMixedCase(bl2);
        SpellCheckerFactory.setIgnoreDigits(bl3);
        SpellCheckerFactory.setIgnoreURL(bl4);
        SpellCheckerFactory.setIgnoreDuplicates(bl5);
        SpellCheckerFactory.setCheckPunctuation(bl6);
        SpellCheckerFactory.setAllowCompound(bl7);
        SpellCheckerFactory.setAllowPrefixes(bl8);
        SpellCheckerFactory.setAllowFileExtensions(bl9);
        SpellCheckerFactory.setMaxSuggestionForce(bl10);
        if (SpellCheckerFactory.getSpellChecker() != null) {
            String string;
            String[] stringArray = SpellCheckerFactory.getAvailableLanguages(false);
            int n = StringUtil.indexOf(stringArray, string = preferences.getString("selectedLanguage", "en"));
            if (n < 0 && (n = StringUtil.indexOf(stringArray, string = "en")) < 0) {
                n = 0;
                string = stringArray[0];
            }
            SpellCheckerFactory.setSelectedLanguage(string);
        }
    }

    public void flushPreferences() {
        String string = SpellCheckerFactory.getSelectedLanguage();
        if (string != null) {
            this.app.getPreferences().putString("selectedLanguage", string);
        }
    }

    public void namespacePrefixesChanged() {
    }

    public void saveStateChanged() {
    }

    public void validityStateChanged() {
    }

    public void undoStateChanged() {
    }

    public void editingContextChanged() {
    }

    public boolean isEditingContextSensitive() {
        return false;
    }

    public void activeEditorChanged() {
    }
}

