/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.guiutil.HintLabel;
import com.xmlmind.xmledit.guiutil.MultiLineJLabel;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class EditOptions
extends AppPreferencesSheet {
    private JCheckBox button2PastesSystemSelection;
    private JCheckBox addInteractiveMargins;
    private JCheckBox selectFieldUsingChooser;
    private JRadioButton appendSuggestionModeNone;
    private JRadioButton appendSuggestionModeAuto;
    private JRadioButton appendSuggestionModeManual;
    private ButtonGroup appendSuggestionModeGroup;
    private JCheckBox onlyShowSuggestions;
    private JTextField maxUndo;
    private JRadioButton inclusionTypeEntity;
    private JRadioButton inclusionTypeXInclude;
    private JRadioButton inclusionTypeAuto;
    private ButtonGroup inclusionTypeGroup;
    private JCheckBox warnAboutHierarchicalXPointer;

    public EditOptions() {
        super("edit", Msg.msg("ed.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        this.button2PastesSystemSelection = new JCheckBox(Msg.msg("ed.button2PastesSystemSelection"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        preferencesSheetPane.add((Component)this.button2PastesSystemSelection, gridBagConstraints);
        MultiLineJLabel multiLineJLabel = new HintLabel(Msg.msg("needAppRestart"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        preferencesSheetPane.add((Component)multiLineJLabel, gridBagConstraints);
        this.addInteractiveMargins = new JCheckBox(Msg.msg("ed.addInteractiveMargins"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 20;
        preferencesSheetPane.add((Component)this.addInteractiveMargins, gridBagConstraints);
        this.selectFieldUsingChooser = new JCheckBox(Msg.msg("ed.selectFieldUsingChooser"));
        ++gridBagConstraints.gridy;
        preferencesSheetPane.add((Component)this.selectFieldUsingChooser, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("ed.autoCompletion")));
        ++gridBagConstraints.gridy;
        preferencesSheetPane.add((Component)jPanel, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("ed.maxUndo"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        preferencesSheetPane.add((Component)multiLineJLabel, gridBagConstraints);
        this.maxUndo = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        preferencesSheetPane.add((Component)this.maxUndo, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("ed.pasteReference")));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 18;
        multiLineJLabel = new MultiLineJLabel(Msg.msg("ed.appendSuggestionMode"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.appendSuggestionModeNone = new JRadioButton(Msg.msg("ed.appendSuggestionModeNone"));
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.appendSuggestionModeNone, gridBagConstraints);
        this.appendSuggestionModeAuto = new JRadioButton(Msg.msg("ed.appendSuggestionModeAuto"));
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.appendSuggestionModeAuto, gridBagConstraints);
        this.appendSuggestionModeManual = new JRadioButton(Msg.msg("ed.appendSuggestionModeManual"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.appendSuggestionModeManual, gridBagConstraints);
        this.appendSuggestionModeGroup = new ButtonGroup();
        this.appendSuggestionModeGroup.add(this.appendSuggestionModeNone);
        this.appendSuggestionModeGroup.add(this.appendSuggestionModeAuto);
        this.appendSuggestionModeGroup.add(this.appendSuggestionModeManual);
        this.onlyShowSuggestions = new JCheckBox(Msg.msg("ed.onlyShowSuggestions"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.onlyShowSuggestions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        multiLineJLabel = new MultiLineJLabel(Msg.msg("ed.inclusionType"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        jPanel2.add((Component)multiLineJLabel, gridBagConstraints);
        this.inclusionTypeEntity = new JRadioButton(Msg.msg("ed.inclusionTypeEntity"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.inclusionTypeEntity, gridBagConstraints);
        this.inclusionTypeXInclude = new JRadioButton(Msg.msg("ed.inclusionTypeXInclude"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 2;
        jPanel2.add((Component)this.inclusionTypeXInclude, gridBagConstraints);
        this.inclusionTypeAuto = new JRadioButton(Msg.msg("ed.inclusionTypeAuto"));
        ++gridBagConstraints.gridy;
        jPanel2.add((Component)this.inclusionTypeAuto, gridBagConstraints);
        this.inclusionTypeGroup = new ButtonGroup();
        this.inclusionTypeGroup.add(this.inclusionTypeEntity);
        this.inclusionTypeGroup.add(this.inclusionTypeXInclude);
        this.inclusionTypeGroup.add(this.inclusionTypeAuto);
        this.warnAboutHierarchicalXPointer = new JCheckBox(Msg.msg("ed.warnAboutHierarchicalXPointer"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        jPanel2.add((Component)this.warnAboutHierarchicalXPointer, gridBagConstraints);
        return preferencesSheetPane;
    }

    public void focusPane() {
        this.button2PastesSystemSelection.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.button2PastesSystemSelection.setSelected(preferences.getBoolean("button2PastesSystemSelection", false));
        this.addInteractiveMargins.setSelected(preferences.getBoolean("addInteractiveMargins", false));
        this.selectFieldUsingChooser.setSelected(preferences.getBoolean("selectFieldUsingChooser", false));
        String string = preferences.getString("appendSuggestionMode", "manual");
        if ("none".equals(string)) {
            this.appendSuggestionModeNone.setSelected(true);
        } else if ("auto".equals(string)) {
            this.appendSuggestionModeAuto.setSelected(true);
        } else {
            this.appendSuggestionModeManual.setSelected(true);
        }
        this.onlyShowSuggestions.setSelected(preferences.getBoolean("onlyShowSuggestions", false));
        this.maxUndo.setText(Integer.toString(preferences.getInt("maxUndo", 1, 100, 20)));
        string = preferences.getString("inclusionType", "auto");
        if ("entity".equals(string)) {
            this.inclusionTypeEntity.setSelected(true);
        } else if ("xinclude".equals(string)) {
            this.inclusionTypeXInclude.setSelected(true);
        } else {
            this.inclusionTypeAuto.setSelected(true);
        }
        this.warnAboutHierarchicalXPointer.setSelected(preferences.getBoolean("warnAboutHierarchicalXPointer", true));
    }

    public boolean validatePane(Preferences preferences) {
        preferences.putBoolean("button2PastesSystemSelection", this.button2PastesSystemSelection.isSelected());
        preferences.putBoolean("addInteractiveMargins", this.addInteractiveMargins.isSelected());
        preferences.putBoolean("selectFieldUsingChooser", this.selectFieldUsingChooser.isSelected());
        String string = this.appendSuggestionModeNone.isSelected() ? "none" : (this.appendSuggestionModeAuto.isSelected() ? "auto" : "manual");
        preferences.putString("appendSuggestionMode", string);
        preferences.putBoolean("onlyShowSuggestions", this.onlyShowSuggestions.isSelected());
        int n = this.checkIntField(this.maxUndo, 1, 100, -1);
        if (n < 0) {
            return false;
        }
        preferences.putInt("maxUndo", n);
        String string2 = this.inclusionTypeEntity.isSelected() ? "entity" : (this.inclusionTypeXInclude.isSelected() ? "xinclude" : "auto");
        preferences.putString("inclusionType", string2);
        preferences.putBoolean("warnAboutHierarchicalXPointer", this.warnAboutHierarchicalXPointer.isSelected());
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        AppPart appPart = this.app.getPart("editOptionsPart");
        if (appPart != null) {
            appPart.applyPreferences();
        }
    }
}

