/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class OpenOptions
extends AppPreferencesSheet {
    private JCheckBox useURLChooser;
    private JCheckBox useURLChooserToSaveCopy;
    private JCheckBox guessIgnorableWhitespace;
    private JCheckBox useHelperDocumentType;
    private JCheckBox ignoreStyleSheetPI;
    private JCheckBox warnAboutLossOfPhysicalStructure;
    private JCheckBox infoAboutReadOnlyInclusions;

    public OpenOptions() {
        super("open", Msg.msg("open.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        this.useURLChooser = new JCheckBox(Msg.msg("open.toggleUseURLChooser"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        preferencesSheetPane.add((Component)this.useURLChooser, gridBagConstraints);
        this.useURLChooserToSaveCopy = new JCheckBox(Msg.msg("open.useURLChooserToSaveCopy"));
        ++gridBagConstraints.gridy;
        preferencesSheetPane.add((Component)this.useURLChooserToSaveCopy, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("open.noGrammar")));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 20;
        preferencesSheetPane.add((Component)jPanel, gridBagConstraints);
        this.ignoreStyleSheetPI = new JCheckBox(Msg.msg("open.ignoreStyleSheetPI"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        preferencesSheetPane.add((Component)this.ignoreStyleSheetPI, gridBagConstraints);
        this.warnAboutLossOfPhysicalStructure = new JCheckBox(Msg.msg("open.warnAboutLossOfPhysicalStructure"));
        ++gridBagConstraints.gridy;
        preferencesSheetPane.add((Component)this.warnAboutLossOfPhysicalStructure, gridBagConstraints);
        this.infoAboutReadOnlyInclusions = new JCheckBox(Msg.msg("open.infoAboutReadOnlyInclusions"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)this.infoAboutReadOnlyInclusions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.guessIgnorableWhitespace = new JCheckBox(Msg.msg("open.guessIgnorableWhitespace"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.guessIgnorableWhitespace, gridBagConstraints);
        this.useHelperDocumentType = new JCheckBox(Msg.msg("open.useHelperDocumentType"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.useHelperDocumentType, gridBagConstraints);
        return preferencesSheetPane;
    }

    public void focusPane() {
        this.useURLChooser.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.useURLChooser.setSelected(preferences.getBoolean("useURLChooser", false));
        this.useURLChooserToSaveCopy.setSelected(preferences.getBoolean("useURLChooserToSaveCopy", true));
        this.guessIgnorableWhitespace.setSelected(preferences.getBoolean("guessIgnorableWhitespace", true));
        this.useHelperDocumentType.setSelected(preferences.getBoolean("useHelperDocumentType", true));
        this.ignoreStyleSheetPI.setSelected(preferences.getBoolean("ignoreStyleSheetPI", false));
        this.warnAboutLossOfPhysicalStructure.setSelected(preferences.getBoolean("warnAboutLossOfPhysicalStructure", true));
        this.infoAboutReadOnlyInclusions.setSelected(preferences.getBoolean("infoAboutReadOnlyInclusions", true));
    }

    public boolean validatePane(Preferences preferences) {
        preferences.putBoolean("useURLChooser", this.useURLChooser.isSelected());
        preferences.putBoolean("useURLChooserToSaveCopy", this.useURLChooserToSaveCopy.isSelected());
        preferences.putBoolean("guessIgnorableWhitespace", this.guessIgnorableWhitespace.isSelected());
        preferences.putBoolean("useHelperDocumentType", this.useHelperDocumentType.isSelected());
        preferences.putBoolean("ignoreStyleSheetPI", this.ignoreStyleSheetPI.isSelected());
        preferences.putBoolean("warnAboutLossOfPhysicalStructure", this.warnAboutLossOfPhysicalStructure.isSelected());
        preferences.putBoolean("infoAboutReadOnlyInclusions", this.infoAboutReadOnlyInclusions.isSelected());
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        AppPart appPart = this.app.getPart("toggleUseURLChooserAction");
        if (appPart != null) {
            appPart.applyPreferences();
        }
        this.app.getXMLLoader().applyOpenPreferences();
    }
}

