/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.ColorIcon;
import com.xmlmind.xmledit.guiutil.HintLabel;
import com.xmlmind.xmledit.guiutil.MultiLineJLabel;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesSheet;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PrintOptions
extends PreferencesSheet {
    private JTextField screenResolutionWhenPrinting;
    private JTextField headerBegin;
    private JTextField headerMiddle;
    private JTextField headerEnd;
    private JButton headerColor;
    private JCheckBox underlineHeader;
    private JTextField footerBegin;
    private JTextField footerMiddle;
    private JTextField footerEnd;
    private JButton footerColor;
    private JCheckBox overlineFooter;

    public PrintOptions() {
        super("print", Msg.msg("print.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("selectColor".equals(string)) {
                    PrintOptions.this.selectColor((Component)actionEvent.getSource());
                }
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        MultiLineJLabel multiLineJLabel = new MultiLineJLabel(Msg.msg("print.screenResolutionWhenPrinting"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        preferencesSheetPane.add((Component)multiLineJLabel, gridBagConstraints);
        this.screenResolutionWhenPrinting = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        preferencesSheetPane.add((Component)this.screenResolutionWhenPrinting, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("print.header")));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 20;
        preferencesSheetPane.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("print.footer")));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        preferencesSheetPane.add((Component)jPanel2, gridBagConstraints);
        multiLineJLabel = new HintLabel(Msg.msg("print.helpAboutPrintVariables"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)multiLineJLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        multiLineJLabel = new MultiLineJLabel(Msg.msg("print.begin"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.headerBegin = new JTextField(25);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.headerBegin, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("print.middle"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.headerMiddle = new JTextField(25);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.headerMiddle, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("print.end"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.headerEnd = new JTextField(25);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.headerEnd, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("print.color"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.headerColor = new JButton(new ColorIcon(40, 20));
        this.headerColor.setActionCommand("selectColor");
        this.headerColor.addActionListener(actionListener);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.headerColor, gridBagConstraints);
        this.underlineHeader = new JCheckBox(Msg.msg("print.underline"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.underlineHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        multiLineJLabel = new MultiLineJLabel(Msg.msg("print.begin"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)multiLineJLabel, gridBagConstraints);
        this.footerBegin = new JTextField(25);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.footerBegin, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("print.middle"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)multiLineJLabel, gridBagConstraints);
        this.footerMiddle = new JTextField(25);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.footerMiddle, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("print.end"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)multiLineJLabel, gridBagConstraints);
        this.footerEnd = new JTextField(25);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.footerEnd, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("print.color"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)multiLineJLabel, gridBagConstraints);
        this.footerColor = new JButton(new ColorIcon(40, 20));
        this.footerColor.setActionCommand("selectColor");
        this.footerColor.addActionListener(actionListener);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.footerColor, gridBagConstraints);
        this.overlineFooter = new JCheckBox(Msg.msg("print.overline"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.bottom = 5;
        jPanel2.add((Component)this.overlineFooter, gridBagConstraints);
        return preferencesSheetPane;
    }

    private void selectColor(Component component) {
        Color color;
        String string = Msg.msg("print.color");
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((color = JColorChooser.showDialog(AWTUtil.getDialogAnchor(component), string, component.getForeground())) != null) {
            component.setForeground(color);
        }
    }

    public void focusPane() {
        this.screenResolutionWhenPrinting.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.screenResolutionWhenPrinting.setText(Double.toString(preferences.getDouble("screenResolutionWhenPrinting", 50.0, 150.0, 100.0)));
        this.headerBegin.setText(preferences.getString("headerBegin", ""));
        this.headerMiddle.setText(preferences.getString("headerMiddle", ""));
        this.headerEnd.setText(preferences.getString("headerEnd", ""));
        this.headerColor.setForeground(preferences.getColor("headerColor", Color.gray));
        this.underlineHeader.setSelected(preferences.getBoolean("underlineHeader", true));
        this.footerBegin.setText(preferences.getString("footerBegin", "%F"));
        this.footerMiddle.setText(preferences.getString("footerMiddle", ""));
        this.footerEnd.setText(preferences.getString("footerEnd", "%P"));
        this.footerColor.setForeground(preferences.getColor("footerColor", Color.gray));
        this.overlineFooter.setSelected(preferences.getBoolean("overlineFooter", true));
    }

    public boolean validatePane(Preferences preferences) {
        double d = this.checkDoubleField(this.screenResolutionWhenPrinting, 50.0, 150.0, -1.0);
        if (d == -1.0) {
            return false;
        }
        preferences.putDouble("screenResolutionWhenPrinting", d);
        preferences.putString("headerBegin", this.headerBegin.getText().trim());
        preferences.putString("headerMiddle", this.headerMiddle.getText().trim());
        preferences.putString("headerEnd", this.headerEnd.getText().trim());
        preferences.putColor("headerColor", this.headerColor.getForeground());
        preferences.putBoolean("underlineHeader", this.underlineHeader.isSelected());
        preferences.putString("footerBegin", this.footerBegin.getText().trim());
        preferences.putString("footerMiddle", this.footerMiddle.getText().trim());
        preferences.putString("footerEnd", this.footerEnd.getText().trim());
        preferences.putColor("footerColor", this.footerColor.getForeground());
        preferences.putBoolean("overlineFooter", this.overlineFooter.isSelected());
        return true;
    }
}

