/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.doc.CharRange;
import com.xmlmind.xmledit.doc.DocumentWriter;
import com.xmlmind.xmledit.guiutil.HintLabel;
import com.xmlmind.xmledit.guiutil.MultiLineJLabel;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;

public class SaveOptions
extends AppPreferencesSheet {
    private JComboBox encoding;
    private JCheckBox saveCharsAsEntityRefs;
    private JTextArea charsSavedAsEntityRefs;
    private JCheckBox indent;
    private JTextField indentation;
    private JTextField maxLineLength;
    private JCheckBox addOpenLines;
    private JCheckBox favorInteroperability;
    private JCheckBox dontIndentUnconstrainedDocs;
    private JCheckBox overrideConfiguration;
    private JCheckBox showValidityPaneOnSave;
    private JCheckBox autoSave;
    private SpinnerNumberModel autoSaveIntervalModel;
    private JSpinner autoSaveInterval;
    private SpinnerNumberModel autoSaveTimeoutModel;
    private JSpinner autoSaveTimeout;
    private JCheckBox makeBackupFiles;

    public SaveOptions() {
        super("save", Msg.msg("save.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("toggleSaveCharsAsEntityRefs".equals(string)) {
                    SaveOptions.this.toggleSaveCharsAsEntityRefs();
                } else if ("toggleIndent".equals(string)) {
                    SaveOptions.this.toggleIndent();
                } else if ("toggleAutoSave".equals(string)) {
                    SaveOptions.this.toggleAutoSave();
                }
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EtchedBorder());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        preferencesSheetPane.add((Component)jPanel, gridBagConstraints);
        this.showValidityPaneOnSave = new JCheckBox(Msg.msg("save.showValidityPaneOnSave"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 20;
        preferencesSheetPane.add((Component)this.showValidityPaneOnSave, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EtchedBorder());
        ++gridBagConstraints.gridy;
        preferencesSheetPane.add((Component)jPanel2, gridBagConstraints);
        this.makeBackupFiles = new JCheckBox(Msg.msg("save.makeBackupFiles"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)this.makeBackupFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        MultiLineJLabel multiLineJLabel = new MultiLineJLabel(Msg.msg("save.encoding"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.encoding = new JComboBox<String>(DocumentWriter.KNOWN_ENCODINGS);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.encoding, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new EtchedBorder());
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new EtchedBorder());
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        this.overrideConfiguration = new JCheckBox(Msg.msg("save.overrideConfiguration"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.overrideConfiguration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.saveCharsAsEntityRefs = new JCheckBox(Msg.msg("save.saveCharsAsEntityRefs"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)this.saveCharsAsEntityRefs, gridBagConstraints);
        this.saveCharsAsEntityRefs.setActionCommand("toggleSaveCharsAsEntityRefs");
        this.saveCharsAsEntityRefs.addActionListener(actionListener);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("save.charsSavedAsEntityRefs"));
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)multiLineJLabel, gridBagConstraints);
        this.charsSavedAsEntityRefs = new JTextArea(3, 40);
        Font font = this.charsSavedAsEntityRefs.getFont();
        this.charsSavedAsEntityRefs.setFont(new Font(font.getFamily(), 0, Math.max(12, font.getSize() - 2)));
        this.charsSavedAsEntityRefs.setLineWrap(true);
        this.charsSavedAsEntityRefs.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.charsSavedAsEntityRefs);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 1;
        jPanel3.add((Component)jScrollPane, gridBagConstraints);
        multiLineJLabel = new HintLabel(Msg.msg("save.helpAboutCharRanges", "reg 174 0x00ae 0256 pound:yen 163:165 0xA3:0xA5 0243:0245"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        jPanel3.add((Component)multiLineJLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.indent = new JCheckBox(Msg.msg("save.indent"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel4.add((Component)this.indent, gridBagConstraints);
        this.indent.setActionCommand("toggleIndent");
        this.indent.addActionListener(actionListener);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("save.indentation", new Integer(16)));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)multiLineJLabel, gridBagConstraints);
        this.indentation = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel4.add((Component)this.indentation, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("save.maxLineLength", new Integer(40)));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.right = 0;
        jPanel4.add((Component)multiLineJLabel, gridBagConstraints);
        this.maxLineLength = new JTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel4.add((Component)this.maxLineLength, gridBagConstraints);
        this.addOpenLines = new JCheckBox(Msg.msg("save.addOpenLines"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        jPanel4.add((Component)this.addOpenLines, gridBagConstraints);
        this.favorInteroperability = new JCheckBox(Msg.msg("save.favorInteroperability"));
        ++gridBagConstraints.gridy;
        jPanel4.add((Component)this.favorInteroperability, gridBagConstraints);
        this.dontIndentUnconstrainedDocs = new JCheckBox(Msg.msg("save.dontIndentUnconstrainedDocs"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        jPanel4.add((Component)this.dontIndentUnconstrainedDocs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        this.autoSave = new JCheckBox(Msg.msg("save.autoSave"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.autoSave, gridBagConstraints);
        this.autoSave.setActionCommand("toggleAutoSave");
        this.autoSave.addActionListener(actionListener);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("save.autoSaveInterval"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)multiLineJLabel, gridBagConstraints);
        this.autoSaveIntervalModel = new SpinnerNumberModel(300, 20, 1000000, 20);
        this.autoSaveInterval = new JSpinner(this.autoSaveIntervalModel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.autoSaveInterval, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("save.autoSaveTimeout"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        jPanel2.add((Component)multiLineJLabel, gridBagConstraints);
        this.autoSaveTimeoutModel = new SpinnerNumberModel(30, 10, 86400, 10);
        this.autoSaveTimeout = new JSpinner(this.autoSaveTimeoutModel);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.autoSaveTimeout, gridBagConstraints);
        return preferencesSheetPane;
    }

    private void toggleSaveCharsAsEntityRefs() {
        boolean bl = this.saveCharsAsEntityRefs.isSelected();
        this.charsSavedAsEntityRefs.setEditable(bl);
        this.charsSavedAsEntityRefs.setEnabled(bl);
    }

    private void toggleIndent() {
        boolean bl = this.indent.isSelected();
        this.indentation.setEditable(bl);
        this.indentation.setEnabled(bl);
        this.maxLineLength.setEditable(bl);
        this.maxLineLength.setEnabled(bl);
        this.addOpenLines.setEnabled(bl);
        this.favorInteroperability.setEnabled(bl);
        this.dontIndentUnconstrainedDocs.setEnabled(bl);
    }

    private void toggleAutoSave() {
        boolean bl = this.autoSave.isSelected();
        this.autoSaveInterval.setEnabled(bl);
        this.autoSaveTimeout.setEnabled(bl);
    }

    public void focusPane() {
        this.encoding.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.encoding.setSelectedItem(preferences.getString("encoding", "UTF-8"));
        this.saveCharsAsEntityRefs.setSelected(preferences.getBoolean("saveCharsAsEntityRefs", true));
        this.charsSavedAsEntityRefs.setText(preferences.getString("charsSavedAsEntityRefs", ""));
        this.toggleSaveCharsAsEntityRefs();
        int n = preferences.getInt("indent", -1, 16, 2);
        if (n < 0) {
            this.indent.setSelected(false);
            this.indentation.setText("2");
        } else {
            this.indent.setSelected(true);
            this.indentation.setText(Integer.toString(n));
        }
        int n2 = preferences.getInt("maxLineLength", 40, Integer.MAX_VALUE, 78);
        this.maxLineLength.setText(Integer.toString(n2));
        this.addOpenLines.setSelected(preferences.getBoolean("addOpenLines", true));
        this.favorInteroperability.setSelected(preferences.getBoolean("favorInteroperability", true));
        this.dontIndentUnconstrainedDocs.setSelected(preferences.getBoolean("dontIndentUnconstrainedDocs", false));
        this.toggleIndent();
        this.overrideConfiguration.setSelected(preferences.getBoolean("overrideConfiguration", false));
        this.showValidityPaneOnSave.setSelected(preferences.getBoolean("showValidityPaneOnSave", false));
        int n3 = preferences.getInt("autoSaveInterval", -1000000, 1000000, -300);
        if (n3 <= 0) {
            this.autoSave.setSelected(false);
            n3 = -n3;
        } else {
            this.autoSave.setSelected(true);
        }
        if (n3 < 10) {
            n3 = 10;
        }
        this.autoSaveIntervalModel.setValue(new Integer(n3));
        int n4 = preferences.getInt("autoSaveTimeout", 10, 86400, 30);
        this.autoSaveTimeoutModel.setValue(new Integer(n4));
        this.toggleAutoSave();
        this.makeBackupFiles.setSelected(preferences.getBoolean("makeBackupFiles", true));
    }

    public boolean validatePane(Preferences preferences) {
        int n;
        preferences.putString("encoding", (String)this.encoding.getSelectedItem());
        preferences.putBoolean("saveCharsAsEntityRefs", this.saveCharsAsEntityRefs.isSelected());
        String string = XMLUtil.collapseWhiteSpace(this.charsSavedAsEntityRefs.getText());
        CharRange[] charRangeArray = CharRange.parseRanges(string);
        if (charRangeArray == null) {
            this.badText(this.charsSavedAsEntityRefs);
            return false;
        }
        preferences.putString("charsSavedAsEntityRefs", string);
        if (this.indent.isSelected()) {
            n = this.checkIntField(this.indentation, 0, 16, -1);
            if (n < 0) {
                return false;
            }
            preferences.putInt("indent", n);
        } else {
            preferences.putInt("indent", -1);
        }
        n = this.checkIntField(this.maxLineLength, 40, Integer.MAX_VALUE, -1);
        if (n < 0) {
            return false;
        }
        preferences.putInt("maxLineLength", n);
        preferences.putBoolean("addOpenLines", this.addOpenLines.isSelected());
        preferences.putBoolean("favorInteroperability", this.favorInteroperability.isSelected());
        preferences.putBoolean("dontIndentUnconstrainedDocs", this.dontIndentUnconstrainedDocs.isSelected());
        preferences.putBoolean("overrideConfiguration", this.overrideConfiguration.isSelected());
        preferences.putBoolean("showValidityPaneOnSave", this.showValidityPaneOnSave.isSelected());
        int n2 = this.autoSaveIntervalModel.getNumber().intValue();
        if (!this.autoSave.isSelected()) {
            n2 = -n2;
        }
        preferences.putInt("autoSaveInterval", n2);
        int n3 = this.autoSaveTimeoutModel.getNumber().intValue();
        preferences.putInt("autoSaveTimeout", n3);
        preferences.putBoolean("makeBackupFiles", this.makeBackupFiles.isSelected());
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        AppPart appPart = this.app.getPart("autoSavePart");
        if (appPart != null) {
            appPart.applyPreferences();
        }
    }
}

