/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class SchemaCacheOptions
extends AppPreferencesSheet {
    private JCheckBox useDocTypeCache;
    private JButton clearDocTypeCache;

    public SchemaCacheOptions() {
        super("schemaCache", Msg.msg("schema.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("toggleUseDocTypeCache".equals(string)) {
                    SchemaCacheOptions.this.toggleUseDocTypeCache();
                } else if ("clearDocTypeCache".equals(string)) {
                    SchemaCacheOptions.this.clearDocTypeCache();
                }
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        this.useDocTypeCache = new JCheckBox(Msg.msg("schema.useDocTypeCache"));
        this.useDocTypeCache.setActionCommand("toggleUseDocTypeCache");
        this.useDocTypeCache.addActionListener(actionListener);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        preferencesSheetPane.add((Component)this.useDocTypeCache, gridBagConstraints);
        this.clearDocTypeCache = new JButton(Msg.msg("schema.clearDocTypeCache"));
        this.clearDocTypeCache.setActionCommand("clearDocTypeCache");
        this.clearDocTypeCache.addActionListener(actionListener);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)this.clearDocTypeCache, gridBagConstraints);
        return preferencesSheetPane;
    }

    private void toggleUseDocTypeCache() {
        this.clearDocTypeCache.setEnabled(this.useDocTypeCache.isSelected());
    }

    private void clearDocTypeCache() {
        if (this.app.getXMLLoader().clearDocumentTypeCache()) {
            this.app.showStatus(Msg.msg("schema.docTypeCacheCleared"));
        }
    }

    public void focusPane() {
        this.useDocTypeCache.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.useDocTypeCache.setSelected(preferences.getBoolean("useDocTypeCache", true));
        this.toggleUseDocTypeCache();
    }

    public boolean validatePane(Preferences preferences) {
        preferences.putBoolean("useDocTypeCache", this.useDocTypeCache.isSelected());
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        this.app.getXMLLoader().applySchemaPreferences();
    }
}

