/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;

public class SpellOptions
extends AppPreferencesSheet {
    private JCheckBox[] options = new JCheckBox[OPTION_NAMES.length];
    private static final String[] OPTION_NAMES = new String[]{"ignoreCase", "ignoreMixedCase", "ignoreDigits", "ignoreURL", "ignoreDuplicates", "checkPunctuation", "allowCompound", "allowPrefixes", "allowFileExtensions", "maxSuggestionForce"};
    private static final boolean[] OPTION_DEFAULT_VALUES = new boolean[]{false, false, true, true, false, false, true, true, true, false};

    public SpellOptions() {
        super("spell", Msg.msg("spell.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        int n = 0;
        while (n < OPTION_NAMES.length) {
            this.options[n] = new JCheckBox(Msg.msg("spell." + OPTION_NAMES[n]));
            gridBagConstraints.insets.top = n == 0 ? 5 : 0;
            preferencesSheetPane.add((Component)this.options[n], gridBagConstraints);
            ++gridBagConstraints.gridy;
            ++n;
        }
        return preferencesSheetPane;
    }

    public void focusPane() {
        this.options[0].requestFocus();
    }

    public void fillPane(Preferences preferences) {
        int n = 0;
        while (n < OPTION_NAMES.length) {
            this.options[n].setSelected(preferences.getBoolean(OPTION_NAMES[n], OPTION_DEFAULT_VALUES[n]));
            ++n;
        }
    }

    public boolean validatePane(Preferences preferences) {
        int n = 0;
        while (n < OPTION_NAMES.length) {
            preferences.putBoolean(OPTION_NAMES[n], this.options[n].isSelected());
            ++n;
        }
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        AppPart appPart = this.app.getPart("spellOptionsPart");
        if (appPart != null) {
            appPart.applyPreferences();
        }
    }
}

