/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.guiutil.MultiLineJLabel;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import com.xmlmind.xmleditapp.spreadsheet.SpreadsheetHelper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class SpreadsheetOptions
extends AppPreferencesSheet {
    private JCheckBox spreadsheetAutoRecalc;
    private JTextField spreadsheetMaxIterations;
    private JCheckBox spreadsheetCacheDocuments;

    public SpreadsheetOptions() {
        super("spreadsheet", Msg.msg("spread.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        this.spreadsheetAutoRecalc = new JCheckBox(Msg.msg("spread.spreadsheetAutoRecalc"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        preferencesSheetPane.add((Component)this.spreadsheetAutoRecalc, gridBagConstraints);
        MultiLineJLabel multiLineJLabel = new MultiLineJLabel(Msg.msg("spread.spreadsheetMaxIterations", new Integer(2), new Integer(1000)));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.right = 0;
        preferencesSheetPane.add((Component)multiLineJLabel, gridBagConstraints);
        this.spreadsheetMaxIterations = new JTextField(10);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        preferencesSheetPane.add((Component)this.spreadsheetMaxIterations, gridBagConstraints);
        this.spreadsheetCacheDocuments = new JCheckBox(Msg.msg("spread.spreadsheetCacheDocuments"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)this.spreadsheetCacheDocuments, gridBagConstraints);
        return preferencesSheetPane;
    }

    public void focusPane() {
        this.spreadsheetAutoRecalc.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.spreadsheetAutoRecalc.setSelected(preferences.getBoolean("spreadsheetAutoRecalc", SpreadsheetHelper.isAutoRecalc()));
        this.spreadsheetMaxIterations.setText(Integer.toString(preferences.getInt("spreadsheetMaxIterations", SpreadsheetHelper.getMaxIterations())));
        this.spreadsheetCacheDocuments.setSelected(preferences.getBoolean("spreadsheetCacheDocuments", SpreadsheetHelper.isCachingDocuments()));
    }

    public boolean validatePane(Preferences preferences) {
        int n = this.checkIntField(this.spreadsheetMaxIterations, 2, 1000, -1);
        if (n < 0) {
            return false;
        }
        preferences.putInt("spreadsheetMaxIterations", n);
        preferences.putBoolean("spreadsheetAutoRecalc", this.spreadsheetAutoRecalc.isSelected());
        preferences.putBoolean("spreadsheetCacheDocuments", this.spreadsheetCacheDocuments.isSelected());
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        AppPart appPart = this.app.getPart("spreadsheetOptionsPart");
        if (appPart != null) {
            appPart.applyPreferences();
        }
    }
}

