/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.ColorIcon;
import com.xmlmind.xmledit.guiutil.MultiLineJLabel;
import com.xmlmind.xmledit.styledview.StyledViewFactoryUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.Editor;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ViewOptions
extends AppPreferencesSheet {
    private JComboBox serifFontFamily;
    private JComboBox sansSerifFontFamily;
    private JComboBox monospaceFontFamily;
    private ButtonGroup defaultFontGroup;
    private JRadioButton defaultFontIsSerif;
    private JRadioButton defaultFontIsSans;
    private JComboBox defaultFontSize;
    private JButton defaultBackground;
    private JButton defaultForeground;

    public ViewOptions() {
        super("view", Msg.msg("view.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if ("defaultBackground".equals(string) || "defaultForeground".equals(string)) {
                    ViewOptions.this.selectColor((Component)actionEvent.getSource(), string);
                }
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("view.defaults")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        MultiLineJLabel multiLineJLabel = new MultiLineJLabel(Msg.msg("view.serifFontFamily"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        String[] stringArray = StyledViewFactoryUtil.getFontFamilies();
        this.serifFontFamily = new JComboBox<String>(stringArray);
        this.serifFontFamily.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.serifFontFamily, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("view.sansSerifFontFamily"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.sansSerifFontFamily = new JComboBox<String>(stringArray);
        this.sansSerifFontFamily.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.sansSerifFontFamily, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("view.monospaceFontFamily"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.monospaceFontFamily = new JComboBox<String>(stringArray);
        this.monospaceFontFamily.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.monospaceFontFamily, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("view.defaultFontFamily"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.defaultFontIsSerif = new JRadioButton(Msg.msg("view.serif"));
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.defaultFontIsSerif, gridBagConstraints);
        this.defaultFontIsSans = new JRadioButton(Msg.msg("view.sansSerif"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.defaultFontIsSans, gridBagConstraints);
        this.defaultFontGroup = new ButtonGroup();
        this.defaultFontGroup.add(this.defaultFontIsSerif);
        this.defaultFontGroup.add(this.defaultFontIsSans);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("view.defaultFontSize"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.defaultFontSize = new JComboBox();
        int n = 10;
        while (n <= 20) {
            this.defaultFontSize.addItem(new Integer(n));
            ++n;
        }
        this.defaultFontSize.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.defaultFontSize, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("view.defaultBackground"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.defaultBackground = new JButton(new ColorIcon(40, 20));
        this.defaultBackground.setActionCommand("defaultBackground");
        this.defaultBackground.addActionListener(actionListener);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.defaultBackground, gridBagConstraints);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("view.defaultForeground"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.defaultForeground = new JButton(new ColorIcon(40, 20));
        this.defaultForeground.setActionCommand("defaultForeground");
        this.defaultForeground.addActionListener(actionListener);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.defaultForeground, gridBagConstraints);
        return preferencesSheetPane;
    }

    private void selectColor(Component component, String string) {
        Color color;
        String string2 = Msg.msg("view." + string);
        if (string2.endsWith(":")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((color = JColorChooser.showDialog(AWTUtil.getDialogAnchor(component), string2, component.getForeground())) != null) {
            component.setForeground(color);
        }
    }

    public void focusPane() {
        this.serifFontFamily.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.serifFontFamily.setSelectedItem(preferences.getString("serifFontFamily", "Serif"));
        this.sansSerifFontFamily.setSelectedItem(preferences.getString("sansSerifFontFamily", "SansSerif"));
        this.monospaceFontFamily.setSelectedItem(preferences.getString("monospaceFontFamily", "Monospaced"));
        boolean bl = preferences.getBoolean("defaultFontIsSerif", false);
        this.defaultFontIsSerif.setSelected(bl);
        this.defaultFontIsSans.setSelected(!bl);
        this.defaultFontSize.setSelectedItem(new Integer(preferences.getInt("defaultFontSize", 10, 20, 12)));
        this.defaultBackground.setForeground(preferences.getColor("defaultBackground", Color.white));
        this.defaultForeground.setForeground(preferences.getColor("defaultForeground", Color.black));
    }

    public boolean validatePane(Preferences preferences) {
        preferences.putString("serifFontFamily", (String)this.serifFontFamily.getSelectedItem());
        preferences.putString("sansSerifFontFamily", (String)this.sansSerifFontFamily.getSelectedItem());
        preferences.putString("monospaceFontFamily", (String)this.monospaceFontFamily.getSelectedItem());
        preferences.putBoolean("defaultFontIsSerif", this.defaultFontIsSerif.isSelected());
        preferences.putInt("defaultFontSize", (Integer)this.defaultFontSize.getSelectedItem());
        preferences.putColor("defaultBackground", this.defaultBackground.getForeground());
        preferences.putColor("defaultForeground", this.defaultForeground.getForeground());
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        Editor[] editorArray = this.app.getEditors();
        int n = 0;
        while (n < editorArray.length) {
            editorArray[n].applyStyleDefaults();
            ++n;
        }
    }
}

