/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.kit.prefsheet;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.MultiLineJLabel;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import com.xmlmind.xmleditapp.kit.prefsheet.Msg;
import com.xmlmind.xmleditapp.upload.DAVClient;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class WebDAVOptions
extends AppPreferencesSheet {
    private JRadioButton scopeNone;
    private JRadioButton scopeShared;
    private JRadioButton scopeExclusive;
    private ButtonGroup scopeGroup;
    private JTextField davLockOwner;

    public WebDAVOptions() {
        super("webDAV", Msg.msg("dav.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        MultiLineJLabel multiLineJLabel = new MultiLineJLabel(Msg.msg("dav.davLockScope"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        preferencesSheetPane.add((Component)multiLineJLabel, gridBagConstraints);
        this.scopeNone = new JRadioButton(Msg.msg("dav.davLockScopeNone"));
        ++gridBagConstraints.gridx;
        preferencesSheetPane.add((Component)this.scopeNone, gridBagConstraints);
        this.scopeShared = new JRadioButton(Msg.msg("dav.davLockScopeShared"));
        ++gridBagConstraints.gridx;
        preferencesSheetPane.add((Component)this.scopeShared, gridBagConstraints);
        this.scopeExclusive = new JRadioButton(Msg.msg("dav.davLockScopeExclusive"));
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        preferencesSheetPane.add((Component)this.scopeExclusive, gridBagConstraints);
        this.scopeGroup = new ButtonGroup();
        this.scopeGroup.add(this.scopeNone);
        this.scopeGroup.add(this.scopeShared);
        this.scopeGroup.add(this.scopeExclusive);
        multiLineJLabel = new MultiLineJLabel(Msg.msg("dav.davLockOwner"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets.top = 20;
        preferencesSheetPane.add((Component)multiLineJLabel, gridBagConstraints);
        this.davLockOwner = new JTextField(40);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)this.davLockOwner, gridBagConstraints);
        return preferencesSheetPane;
    }

    public void focusPane() {
        this.scopeNone.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        String string = preferences.getString("davLockScope", "exclusive");
        if ("shared".equals(string)) {
            this.scopeShared.setSelected(true);
        } else if ("exclusive".equals(string)) {
            this.scopeExclusive.setSelected(true);
        } else {
            this.scopeNone.setSelected(true);
        }
        this.setRawLockOwner(preferences.getString("davLockOwner", DAVClient.getDefaultLockOwner()));
    }

    private void setRawLockOwner(String string) {
        if (string == null) {
            string = "";
        }
        this.davLockOwner.setText(URIUtil.unescape(string));
    }

    private String getRawLockOwner() {
        return URIUtil.quoteUserInfo(this.davLockOwner.getText().trim());
    }

    public boolean validatePane(Preferences preferences) {
        String string = this.scopeShared.isSelected() ? "shared" : (this.scopeExclusive.isSelected() ? "exclusive" : "none");
        preferences.putString("davLockScope", string);
        String string2 = this.getRawLockOwner();
        if (string2.length() == 0) {
            DialogUtil.badField(this.davLockOwner);
            return false;
        }
        preferences.putString("davLockOwner", string2);
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        AppPart appPart = this.app.getPart("webDAVOptionsPart");
        if (appPart != null) {
            appPart.applyPreferences();
        }
    }
}

