/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.macro;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.SimpleDocumentCache;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.guiutil.SystemSelection;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentPane;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xpath.ArrayNodeIterator;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.NodeIterator;
import com.xmlmind.xmledit.xpath.NullNodeIterator;
import com.xmlmind.xmledit.xpath.NumberVariant;
import com.xmlmind.xmledit.xpath.PermanentNodeSetVariant;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import com.xmlmind.xmledit.xpath.SingleNodeIterator;
import com.xmlmind.xmledit.xpath.StringVariant;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmleditapp.macro.MacroCommandUtil;
import java.net.URL;
import java.util.ArrayList;

final class ExecContext
extends SimpleExprContext {
    public static final int MACRO_VAR_COUNT = MacroCommandUtil.VAR_NAMES.length + 1;
    public static char[] MACRO_VAR_NAMES = new char[MACRO_VAR_COUNT];
    public static final int LAST_RESULT_INDEX;
    public static final String IMPLICIT_ELEMENT_LP = "implicitElement";
    public static final String SELECTED_ELEMENT_LP = "selectedElement";
    public static final String IMPLICIT_NODE_LP = "implicitNode";
    public static final String SELECTED_NODE_LP = "selectedNode";
    public static final String SELECTED_CHARS_LP = "selectedChars";
    public static final String SELECTED_NODES_LP = "selectedNodes";
    public static final String SELECTED_LP = "selected";
    public static final String SELECTED2_LP = "selected2";
    public static final String CLICKED_ELEMENT_LP = "clickedElement";
    public static final String CLICKED_NODE_LP = "clickedNode";
    public static final String DOT_LP = "dot";
    public static final String MARK_LP = "mark";
    public static final String DOT_OFFSET_LP = "dotOffset";
    public static final String MARK_OFFSET_LP = "markOffset";
    public static final String CLIPBOARD_LP = "clipboard";
    public static final String SYSTEM_SELECTION_LP = "systemSelection";
    private static final Name IMPLICIT_ELEMENT_NAME;
    private static final Name SELECTED_ELEMENT_NAME;
    private static final Name IMPLICIT_NODE_NAME;
    private static final Name SELECTED_NODE_NAME;
    private static final Name SELECTED_CHARS_NAME;
    private static final Name SELECTED_NODES_NAME;
    private static final Name SELECTED_NAME;
    private static final Name SELECTED2_NAME;
    private static final Name CLICKED_ELEMENT_NAME;
    private static final Name CLICKED_NODE_NAME;
    private static final Name DOT_NAME;
    private static final Name MARK_NAME;
    private static final Name DOT_OFFSET_NAME;
    private static final Name MARK_OFFSET_NAME;
    private static final Name CLIPBOARD_NAME;
    private static final Name SYSTEM_SELECTION_NAME;
    private static final Namespace VIEW_SCOPE_NAMESPACE;
    private static PermanentNodeSetVariant EMPTY_NODE_SET_VARIANT;
    private static final StringVariant EMPTY_STRING_VARIANT;
    private static final NumberVariant NO_OFFSET_VARIANT;
    public boolean trace;
    public String macroName;
    public DocumentView docView;
    public int mouseX;
    public int mouseY;
    public String[] macroArgs;
    public URL docURL;
    public String[] macroVars = new String[MACRO_VAR_COUNT];
    public Object lastResult;
    private LinearHashtable varMap = new LinearHashtable();
    private static final String[] NO_ARGUMENTS;

    public ExecContext() {
        SimpleDocumentCache.installDefaultDocumentManager();
    }

    public boolean resetForPrepare(DocumentView documentView, String string, int n, int n2) {
        this.docView = null;
        this.mouseY = -1;
        this.mouseX = -1;
        Document document = documentView.getDocument();
        if (document == null) {
            return false;
        }
        this.docView = documentView;
        this.mouseX = n;
        this.mouseY = n2;
        this.macroArgs = string == null ? NO_ARGUMENTS : StringUtil.splitArguments(string);
        URL uRL = document.getLocation();
        if (!uRL.equals(this.docURL)) {
            MacroCommandUtil.setVariables(uRL, null, this.macroVars);
            this.docURL = uRL;
        }
        this.macroVars[ExecContext.LAST_RESULT_INDEX] = null;
        this.idMaps = null;
        return true;
    }

    public ExecContext copyForExecute() {
        ExecContext execContext = null;
        try {
            execContext = (ExecContext)this.clone();
            execContext.macroVars = (String[])this.macroVars.clone();
            execContext.varMap = new LinearHashtable();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return execContext;
    }

    public Variant getVariableValue(Name name, XNode xNode) throws EvalException {
        Variant variant;
        MarkManager markManager = this.docView.getMarkManager();
        if (name == IMPLICIT_ELEMENT_NAME || name == SELECTED_ELEMENT_NAME) {
            Element element = this.docView.getSelectedElement(name == IMPLICIT_ELEMENT_NAME);
            if (element == null) {
                return EMPTY_NODE_SET_VARIANT;
            }
            return ExecContext.nodeSetVariant(element);
        }
        if (name == IMPLICIT_NODE_NAME || name == SELECTED_NODE_NAME) {
            Node node = this.docView.getSelectedNode(name == IMPLICIT_NODE_NAME);
            if (node == null) {
                return EMPTY_NODE_SET_VARIANT;
            }
            return ExecContext.nodeSetVariant(node);
        }
        if (name == SELECTED_CHARS_NAME) {
            String string = this.docView.getSelectedChars();
            if (string == null || string.length() == 0) {
                return EMPTY_STRING_VARIANT;
            }
            return new StringVariant(string);
        }
        if (name == SELECTED_NODES_NAME) {
            Node node;
            NodeMark nodeMark = markManager.getSelected();
            NodeMark nodeMark2 = markManager.getSelected2();
            if (nodeMark == null) {
                return EMPTY_NODE_SET_VARIANT;
            }
            Node node2 = nodeMark.getNode();
            if (nodeMark2 == null || (node = nodeMark2.getNode()) == node2) {
                return ExecContext.nodeSetVariant(node2);
            }
            return ExecContext.nodeSetVariant(node2, node);
        }
        if (name == SELECTED_NAME) {
            Node node = this.docView.getSelectedNode();
            if (node == null) {
                return EMPTY_NODE_SET_VARIANT;
            }
            return ExecContext.nodeSetVariant(node);
        }
        if (name == SELECTED2_NAME) {
            Node node = this.docView.getSelectedNode2();
            if (node == null) {
                return EMPTY_NODE_SET_VARIANT;
            }
            return ExecContext.nodeSetVariant(node);
        }
        if (name == CLICKED_ELEMENT_NAME || name == CLICKED_NODE_NAME) {
            Node node = this.docView.viewToModel(this.mouseX, this.mouseY);
            if (node != null && name == CLICKED_ELEMENT_NAME && !(node instanceof Element)) {
                node = node.getParentElement();
            }
            if (node == null) {
                return EMPTY_NODE_SET_VARIANT;
            }
            return ExecContext.nodeSetVariant(node);
        }
        if (name == DOT_NAME || name == DOT_OFFSET_NAME) {
            TextLocation textLocation = markManager.getDot();
            if (textLocation == null) {
                if (name == DOT_NAME) {
                    return EMPTY_NODE_SET_VARIANT;
                }
                return NO_OFFSET_VARIANT;
            }
            if (name == DOT_NAME) {
                return ExecContext.nodeSetVariant(textLocation.getTextNode());
            }
            return new NumberVariant(textLocation.getOffset());
        }
        if (name == MARK_NAME || name == MARK_OFFSET_NAME) {
            TextLocation textLocation = markManager.getMark();
            if (textLocation == null) {
                if (name == MARK_NAME) {
                    return EMPTY_NODE_SET_VARIANT;
                }
                return NO_OFFSET_VARIANT;
            }
            if (name == MARK_NAME) {
                return ExecContext.nodeSetVariant(textLocation.getTextNode());
            }
            return new NumberVariant(textLocation.getOffset());
        }
        if (name == CLIPBOARD_NAME) {
            String string = Clipboard.get(this.docView.getPanel());
            variant = string == null ? EMPTY_STRING_VARIANT : new StringVariant(string);
        } else if (name == SYSTEM_SELECTION_NAME) {
            String string = SystemSelection.get(this.docView.getPanel());
            variant = string == null ? EMPTY_STRING_VARIANT : new StringVariant(string);
        } else {
            LinearHashtable linearHashtable = this.getVariableMap(name);
            variant = (Variant)linearHashtable.get(name);
            if (variant == null) {
                variant = EMPTY_STRING_VARIANT;
            }
        }
        return variant;
    }

    private static final PermanentNodeSetVariant nodeSetVariant(Node node) {
        PermanentNodeSetVariant permanentNodeSetVariant = null;
        try {
            permanentNodeSetVariant = new PermanentNodeSetVariant(new SingleNodeIterator(node));
        }
        catch (EvalException evalException) {}
        return permanentNodeSetVariant;
    }

    private static final PermanentNodeSetVariant nodeSetVariant(Node node, Node node2) {
        PermanentNodeSetVariant permanentNodeSetVariant = null;
        XNode[] xNodeArray = EditUtil.getRange(node.getParentElement(), node, node2);
        if (xNodeArray == null) {
            return EMPTY_NODE_SET_VARIANT;
        }
        try {
            permanentNodeSetVariant = new PermanentNodeSetVariant(new ArrayNodeIterator(xNodeArray));
        }
        catch (EvalException evalException) {}
        return permanentNodeSetVariant;
    }

    private LinearHashtable getVariableMap(Name name) {
        Namespace namespace = name.getNamespace();
        if (namespace == VIEW_SCOPE_NAMESPACE) {
            LinearHashtable linearHashtable = (LinearHashtable)((DocumentPane)this.docView.getPanel()).getClientProperty(VIEW_SCOPE_NAMESPACE);
            if (linearHashtable == null) {
                linearHashtable = new LinearHashtable();
                ((DocumentPane)this.docView.getPanel()).putClientProperty(VIEW_SCOPE_NAMESPACE, linearHashtable);
            }
            return linearHashtable;
        }
        return this.varMap;
    }

    public void setVariable(Name name, Variant variant) throws IllegalArgumentException {
        MarkManager markManager = this.docView.getMarkManager();
        if (name == IMPLICIT_ELEMENT_NAME || name == SELECTED_ELEMENT_NAME || name == IMPLICIT_NODE_NAME || name == SELECTED_NODE_NAME) {
            Node[] nodeArray = this.toNodes(variant);
            if (nodeArray == null || nodeArray.length == 0) {
                if (markManager.getSelected() != null) {
                    ExecContext.clearNodeSelection(markManager);
                }
            } else {
                Node node = nodeArray[0];
                if (!(name != IMPLICIT_ELEMENT_NAME && name != SELECTED_ELEMENT_NAME || node instanceof Element)) {
                    throw new IllegalArgumentException("node '" + node + "' should be an element");
                }
                this.docView.selectNode(node);
            }
        } else if (name == SELECTED_NODES_NAME) {
            Node[] nodeArray = this.toNodes(variant);
            if (nodeArray == null || nodeArray.length == 0) {
                if (markManager.getSelected() != null) {
                    ExecContext.clearNodeSelection(markManager);
                }
            } else {
                Node node = nodeArray[0];
                Node node2 = nodeArray[nodeArray.length - 1];
                if (node == node2) {
                    this.docView.selectNode(node);
                } else {
                    if (!node.isSiblingOf(node2)) {
                        throw new IllegalArgumentException("node '" + node + "' should be a sibling of " + "' node '" + node2 + "'");
                    }
                    this.docView.selectNodeRange(node, node2);
                }
            }
        } else if (name == SELECTED_CHARS_NAME) {
            Node[] nodeArray = this.toNodes(variant);
            if (nodeArray == null || nodeArray.length == 0) {
                if (markManager.getMark() != null) {
                    markManager.remove("MARK");
                }
            } else {
                TextNode textNode = null;
                int n = 0;
                while (n < nodeArray.length) {
                    textNode = (TextNode)Traversal.traverse(nodeArray[n], Traversal.textNodeFinder);
                    if (textNode != null) break;
                    ++n;
                }
                TextNode textNode2 = null;
                int n2 = nodeArray.length - 1;
                while (n2 >= 0) {
                    textNode2 = (TextNode)Traversal.traverseBackwards(nodeArray[n2], Traversal.textNodeFinder);
                    if (textNode2 != null) break;
                    --n2;
                }
                if (textNode == null || textNode2 == null) {
                    throw new IllegalArgumentException("no text nodes found in node-set value '" + variant + "'");
                }
                this.docView.selectText(textNode, 0, textNode2, textNode2.getTextLength());
            }
        } else if (name == SELECTED_NAME) {
            Node[] nodeArray = this.toNodes(variant);
            NodeMark nodeMark = markManager.getSelected();
            if (nodeArray == null || nodeArray.length == 0) {
                if (nodeMark != null) {
                    ExecContext.clearNodeSelection(markManager);
                }
            } else {
                Node node = nodeArray[0];
                if (nodeMark == null || nodeMark.getNode() != node) {
                    markManager.beginBatchMarking();
                    markManager.remove("MARK");
                    markManager.remove("SELECTED2");
                    markManager.set("SELECTED", node);
                    markManager.endBatchMarking();
                }
            }
        } else if (name == SELECTED2_NAME) {
            Node[] nodeArray = this.toNodes(variant);
            NodeMark nodeMark = markManager.getSelected2();
            if (nodeArray == null || nodeArray.length == 0) {
                if (nodeMark != null) {
                    markManager.remove("SELECTED2");
                }
            } else {
                Node node = nodeArray[0];
                if (nodeMark == null || nodeMark.getNode() != node) {
                    NodeMark nodeMark2 = markManager.getSelected();
                    if (nodeMark2 == null) {
                        throw new IllegalArgumentException("node mark 'SELECTED' should exist before adding node mark 'SELECTED2'");
                    }
                    Node node3 = nodeMark2.getNode();
                    if (!node.isSiblingOf(node3)) {
                        throw new IllegalArgumentException("node '" + node + "' should be a sibling of '" + "SELECTED" + "' node '" + node3 + "'");
                    }
                    markManager.set("SELECTED2", node);
                }
            }
        } else if (name == DOT_NAME) {
            Node[] nodeArray = this.toNodes(variant);
            TextLocation textLocation = markManager.getDot();
            if (nodeArray == null || nodeArray.length == 0) {
                if (textLocation != null) {
                    throw new IllegalArgumentException("text location 'DOT' cannot be removed");
                }
            } else {
                Node node = nodeArray[0];
                if (!(node instanceof TextNode)) {
                    throw new IllegalArgumentException("'" + node + "' is not a text node:" + " cannot mark it as being a text location");
                }
                if (textLocation == null || textLocation.getNode() != node) {
                    markManager.set("DOT", (TextNode)node, 0, true);
                }
            }
        } else if (name == MARK_NAME) {
            Node[] nodeArray = this.toNodes(variant);
            TextLocation textLocation = markManager.getMark();
            if (nodeArray == null || nodeArray.length == 0) {
                if (textLocation != null) {
                    markManager.remove("MARK");
                }
            } else {
                Node node = nodeArray[0];
                if (!(node instanceof TextNode)) {
                    throw new IllegalArgumentException("'" + node + "' is not a text node:" + " cannot mark it as being a text location");
                }
                if (textLocation == null || textLocation.getNode() != node) {
                    markManager.beginBatchMarking();
                    markManager.remove("SELECTED2");
                    markManager.remove("SELECTED");
                    markManager.set("MARK", (TextNode)node, 0);
                    markManager.endBatchMarking();
                }
            }
        } else if (name == DOT_OFFSET_NAME || name == MARK_OFFSET_NAME) {
            int n = ExecContext.toOffset(variant);
            String string = name == DOT_OFFSET_NAME ? "DOT" : "MARK";
            TextLocation textLocation = (TextLocation)markManager.get(string);
            if (textLocation == null) {
                throw new IllegalArgumentException("text location '" + string + "' does not exist: cannot move it");
            }
            TextNode textNode = textLocation.getTextNode();
            if (n < 0) {
                n = 0;
            } else if (n > textNode.getTextLength()) {
                n = textNode.getTextLength();
            }
            if (textLocation.getOffset() != n) {
                textLocation.moveTo(textNode, n);
            }
        } else {
            if (name == CLICKED_ELEMENT_NAME || name == CLICKED_NODE_NAME) {
                throw new IllegalArgumentException("variable '" + name.getLocalPart() + "' is read-only");
            }
            if (name == CLIPBOARD_NAME) {
                Clipboard.put(this.docView.getPanel(), ExecContext.toString(variant));
            } else if (name == SYSTEM_SELECTION_NAME) {
                SystemSelection.put(this.docView.getPanel(), ExecContext.toString(variant));
            } else {
                LinearHashtable linearHashtable = this.getVariableMap(name);
                linearHashtable.put(name, variant);
            }
        }
    }

    private static final void clearNodeSelection(MarkManager markManager) {
        markManager.beginBatchMarking();
        markManager.remove("SELECTED2");
        markManager.remove("SELECTED");
        markManager.endBatchMarking();
    }

    private Node[] toNodes(Variant variant) throws IllegalArgumentException {
        Object object;
        NodeIterator nodeIterator;
        try {
            nodeIterator = variant.convertToNodeSet();
        }
        catch (EvalException evalException) {
            return null;
        }
        Document document = this.docView.getDocument();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        block8: while (true) {
            try {
                object = nodeIterator.next();
            }
            catch (EvalException evalException) {
                object = null;
            }
            if (object == null) break;
            Document document2 = (Document)object.document();
            if (document2 != document) {
                throw new IllegalArgumentException("node-set value '" + variant + "' contains nodes" + " which are not attached to a document or" + " which are attached to a document which is" + " different from '" + document.getLocation() + "'");
            }
            switch (object.type()) {
                case 6: {
                    object = object.parent();
                    break;
                }
                case 5: {
                    object = document.getRootElement();
                    break;
                }
                default: {
                    if (object.parent() == document && !(object instanceof Element)) continue block8;
                }
            }
            boolean bl = false;
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                Node node = (Node)arrayList.get(n2);
                if (object == node) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            arrayList.add((Node)object);
        }
        object = new Node[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private static int toOffset(Variant variant) throws IllegalArgumentException {
        double d;
        String string = "not a number";
        try {
            d = variant.convertToNumber();
        }
        catch (EvalException evalException) {
            d = Double.NaN;
            string = MiscUtil.reason(evalException);
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("'" + variant + "' is not a character offset: " + string);
        }
        return (int)Math.rint(d);
    }

    private static String toString(Variant variant) {
        String string = "";
        try {
            string = variant.convertToString();
        }
        catch (EvalException evalException) {}
        return string;
    }

    static {
        System.arraycopy(MacroCommandUtil.VAR_NAMES, 0, MACRO_VAR_NAMES, 0, MacroCommandUtil.VAR_NAMES.length);
        ExecContext.MACRO_VAR_NAMES[MacroCommandUtil.VAR_NAMES.length] = 95;
        LAST_RESULT_INDEX = MacroCommandUtil.VAR_NAMES.length;
        IMPLICIT_ELEMENT_NAME = Name.get(IMPLICIT_ELEMENT_LP);
        SELECTED_ELEMENT_NAME = Name.get(SELECTED_ELEMENT_LP);
        IMPLICIT_NODE_NAME = Name.get(IMPLICIT_NODE_LP);
        SELECTED_NODE_NAME = Name.get(SELECTED_NODE_LP);
        SELECTED_CHARS_NAME = Name.get(SELECTED_CHARS_LP);
        SELECTED_NODES_NAME = Name.get(SELECTED_NODES_LP);
        SELECTED_NAME = Name.get(SELECTED_LP);
        SELECTED2_NAME = Name.get(SELECTED2_LP);
        CLICKED_ELEMENT_NAME = Name.get(CLICKED_ELEMENT_LP);
        CLICKED_NODE_NAME = Name.get(CLICKED_NODE_LP);
        DOT_NAME = Name.get(DOT_LP);
        MARK_NAME = Name.get(MARK_LP);
        DOT_OFFSET_NAME = Name.get(DOT_OFFSET_LP);
        MARK_OFFSET_NAME = Name.get(MARK_OFFSET_LP);
        CLIPBOARD_NAME = Name.get(CLIPBOARD_LP);
        SYSTEM_SELECTION_NAME = Name.get(SYSTEM_SELECTION_LP);
        VIEW_SCOPE_NAMESPACE = Namespace.get("http://www.xmlmind.com/xmleditor/namespace/scope/view");
        try {
            EMPTY_NODE_SET_VARIANT = new PermanentNodeSetVariant(new NullNodeIterator());
        }
        catch (EvalException evalException) {
            // empty catch block
        }
        EMPTY_STRING_VARIANT = new StringVariant("");
        NO_OFFSET_VARIANT = new NumberVariant(-1.0);
        NO_ARGUMENTS = new String[0];
    }
}

