/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.macro;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.edit.CommandHistory;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.BooleanExpr;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprParser;
import com.xmlmind.xmledit.xpath.NodeSetExpr;
import com.xmlmind.xmledit.xpath.NodeSetVariant;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.PathPattern;
import com.xmlmind.xmledit.xpath.StringExpr;
import com.xmlmind.xmledit.xpath.StringVariant;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmledit.xpath.VariantExpr;
import com.xmlmind.xmleditapp.macro.ExecContext;

public final class MacroCommand
extends RecordableCommand {
    public static final int INVOCATION = 0;
    public static final int CHOICE = 1;
    public static final int SEQUENCE = 2;
    public static final int PASS = 3;
    public static final int FAIL = 4;
    public static final int MATCH = 5;
    public static final int TEST = 6;
    public static final int GET = 7;
    public static final int SET = 8;
    private static final String SELECTED_XPATH = "$selected";
    private static final String SELECTED_ELEMENT_XPATH = "$selectedElement";
    private static final String IMPLICIT_ELEMENT_XPATH = "$implicitElement";
    private static final String SELECTED_NODE_XPATH = "$selectedNode";
    private static final String IMPLICIT_NODE_XPATH = "$implicitNode";
    private static final String DOT_XPATH = "$dot";
    private static final String MARK_XPATH = "$mark";
    private static final String SELECTED2_XPATH = "$selected2";
    private static final String CLICKED_NODE_XPATH = "$clickedNode";
    private static final String CLICKED_ELEMENT_XPATH = "$clickedElement";
    private GroupItem group;
    private ExecContext execContext;
    private boolean trace;
    private boolean repeatable;
    private boolean undoable;
    private String label;

    public MacroCommand(GroupItem groupItem) {
        this.group = groupItem;
        this.execContext = new ExecContext();
    }

    public GroupItem getGroup() {
        return this.group;
    }

    public void setTraced(boolean bl) {
        this.trace = bl;
    }

    public boolean isTraced() {
        return this.trace;
    }

    public void setRepeatable(boolean bl) {
        this.repeatable = bl;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public void setUndoable(boolean bl) {
        this.undoable = bl;
    }

    public boolean isUndoable() {
        return this.undoable;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        if (!this.execContext.resetForPrepare((DocumentView)gadget, string, n, n2)) {
            return false;
        }
        if (this.trace) {
            System.err.println("----------");
            this.execContext.trace = true;
            if (this.execContext.macroName == null) {
                this.execContext.macroName = Commands.getName(this);
            }
        } else {
            this.execContext.trace = false;
        }
        boolean bl = this.group.prepare(this.execContext);
        if (this.trace) {
            System.err.println("----------");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        if (this.trace) {
            System.err.println("==========");
        }
        ExecContext execContext = this.execContext.copyForExecute();
        this.trace = false;
        try {
            this.doExecute(execContext, string);
            Object var7_6 = null;
            this.trace = execContext.trace;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.trace = execContext.trace;
            throw throwable;
        }
        if (this.trace) {
            System.err.println("==========");
        }
        Object object = execContext.lastResult;
        execContext = null;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(ExecContext execContext, String string) {
        CommandHistory commandHistory = null;
        if (this.repeatable && (commandHistory = execContext.docView.getCommandHistory()) != null) {
            if (commandHistory.isReadOnly()) {
                commandHistory = null;
            } else {
                commandHistory.setReadOnly(true);
            }
        }
        UndoManager undoManager = null;
        if (this.undoable && (undoManager = execContext.docView.getUndoManager()) != null) {
            undoManager.beginMerge();
        }
        String string2 = null;
        try {
            this.group.execute(execContext);
        }
        finally {
            if (undoManager != null) {
                string2 = this.guiLabel();
                undoManager.endMerge(string2);
            }
            if (commandHistory != null) {
                commandHistory.setReadOnly(false);
            }
        }
        if (commandHistory != null) {
            if (string2 == null) {
                string2 = this.guiLabel();
            }
            commandHistory.addCommand(this, string, string2);
            execContext.docView.notifyContextChangeListeners();
        }
    }

    private String guiLabel() {
        if (this.label != null) {
            return this.label;
        }
        String string = this.execContext.macroName != null ? this.execContext.macroName : Commands.getName(this);
        if (string == null) {
            return "macro";
        }
        return MacroCommand.macroNameToLabel(string);
    }

    private static final String macroNameToLabel(String string) {
        int n = string.indexOf(46);
        if (n > 0 && n < string.length() - 1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            int n2 = string2.length();
            int n3 = string3.length();
            if (n2 <= 6 && n3 >= n2 && MacroCommand.countLetters(string2, n2) > 0 && MacroCommand.countLetters(string3, n3) > 0 && string3.indexOf(46) < 0) {
                string = string3;
            }
        }
        return XMLUtil.nameToLabel(string);
    }

    private static final int countLetters(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (Character.isLetter(string.charAt(n3))) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public static class Set
    extends XPathItem {
        private Name varName;
        private String expressionXPath;
        private VariantExpr expression;
        private boolean plainString;
        private Variant value;

        public Set(Name name, String string, String string2, boolean bl, PrefixToNamespace prefixToNamespace) throws ParseException {
            super(8, string, prefixToNamespace);
            this.varName = name;
            this.expressionXPath = string2;
            this.plainString = bl;
            if (!bl && string2.indexOf(37) < 0) {
                this.expression = ExprParser.parseVariantExpr(string2, prefixToNamespace, true);
            }
        }

        public Name getVariableName() {
            return this.varName;
        }

        public String getExpression() {
            return this.expressionXPath;
        }

        public boolean isPlainString() {
            return this.plainString;
        }

        protected boolean doPrepare(ExecContext execContext) {
            if (!super.doPrepare(execContext)) {
                return false;
            }
            XNode xNode = this.contextNode;
            this.contextNode = null;
            if (this.plainString) {
                String string;
                if (this.expressionXPath.indexOf(37) < 0) {
                    string = this.expressionXPath;
                } else {
                    execContext.macroVars[ExecContext.LAST_RESULT_INDEX] = execContext.lastResult == null ? "" : execContext.lastResult.toString();
                    string = StringUtil.substituteVars(this.expressionXPath, execContext.macroArgs, ExecContext.MACRO_VAR_NAMES, execContext.macroVars);
                }
                this.value = new StringVariant(string);
                return true;
            }
            String string = this.expressionXPath;
            VariantExpr variantExpr = this.expression;
            if (variantExpr == null) {
                execContext.macroVars[ExecContext.LAST_RESULT_INDEX] = execContext.lastResult == null ? "" : execContext.lastResult.toString();
                string = StringUtil.substituteVars(string, execContext.macroArgs, ExecContext.MACRO_VAR_NAMES, execContext.macroVars);
                try {
                    variantExpr = ExprParser.parseVariantExpr(string, this.prefixToNS, true);
                }
                catch (ParseException parseException) {
                    if (execContext.trace) {
                        System.err.println("   cannot parse expression='" + string + "': " + MiscUtil.reason(parseException));
                    }
                    return false;
                }
            }
            this.value = null;
            try {
                this.value = variantExpr.eval(xNode, execContext);
            }
            catch (EvalException evalException) {
                if (execContext.trace) {
                    System.err.println("   cannot evaluate expression='" + string + "': " + MiscUtil.reason(evalException));
                }
                return false;
            }
            return true;
        }

        protected void doExecute(ExecContext execContext) {
            try {
                if (this.value instanceof NodeSetVariant) {
                    this.value = ((NodeSetVariant)this.value).makePermanent();
                }
            }
            catch (EvalException evalException) {
                if (execContext.trace) {
                    System.err.println("   internal error: cannot make node set which results from the evaluation of expression='" + this.expressionXPath + "' permanent: " + MiscUtil.detailedReason(evalException));
                }
                execContext.lastResult = Command.EXECUTION_FAILED;
                this.value = null;
                return;
            }
            try {
                execContext.setVariable(this.varName, this.value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (execContext.trace) {
                    System.err.println("   cannot set variable '" + this.varName + "' to value '" + this.value + "': " + MiscUtil.reason(illegalArgumentException));
                }
                execContext.lastResult = Command.EXECUTION_FAILED;
                this.value = null;
                return;
            }
            execContext.lastResult = null;
            this.value = null;
        }
    }

    public static class Get
    extends XPathItem {
        private String expressionXPath;
        private StringExpr expression;
        private String value;

        public Get(String string, String string2, PrefixToNamespace prefixToNamespace) throws ParseException {
            super(7, string, prefixToNamespace);
            this.expressionXPath = string2;
            if (string2.indexOf(37) < 0) {
                this.expression = ExprParser.parseStringExpr(string2, prefixToNamespace, true);
            }
        }

        public String getExpression() {
            return this.expressionXPath;
        }

        protected boolean doPrepare(ExecContext execContext) {
            if (!super.doPrepare(execContext)) {
                return false;
            }
            XNode xNode = this.contextNode;
            this.contextNode = null;
            String string = this.expressionXPath;
            StringExpr stringExpr = this.expression;
            if (stringExpr == null) {
                execContext.macroVars[ExecContext.LAST_RESULT_INDEX] = execContext.lastResult == null ? "" : execContext.lastResult.toString();
                string = StringUtil.substituteVars(string, execContext.macroArgs, ExecContext.MACRO_VAR_NAMES, execContext.macroVars);
                try {
                    stringExpr = ExprParser.parseStringExpr(string, this.prefixToNS, true);
                }
                catch (ParseException parseException) {
                    if (execContext.trace) {
                        System.err.println("   cannot parse expression='" + string + "': " + MiscUtil.reason(parseException));
                    }
                    return false;
                }
            }
            this.value = null;
            try {
                this.value = stringExpr.eval(xNode, execContext);
            }
            catch (EvalException evalException) {
                if (execContext.trace) {
                    System.err.println("   cannot evaluate expression='" + string + "': " + MiscUtil.reason(evalException));
                }
                return false;
            }
            return true;
        }

        protected void doExecute(ExecContext execContext) {
            execContext.lastResult = this.value;
            this.value = null;
        }
    }

    public static class Test
    extends XPathItem {
        private String expressionXPath;
        private BooleanExpr expression;

        public Test(String string, String string2, PrefixToNamespace prefixToNamespace) throws ParseException {
            super(6, string, prefixToNamespace);
            this.expressionXPath = string2;
            if (string2.indexOf(37) < 0) {
                this.expression = ExprParser.parseBooleanExpr(string2, prefixToNamespace, true);
            }
        }

        public String getExpression() {
            return this.expressionXPath;
        }

        protected boolean doPrepare(ExecContext execContext) {
            boolean bl;
            if (!super.doPrepare(execContext)) {
                return false;
            }
            XNode xNode = this.contextNode;
            this.contextNode = null;
            String string = this.expressionXPath;
            BooleanExpr booleanExpr = this.expression;
            if (booleanExpr == null) {
                execContext.macroVars[ExecContext.LAST_RESULT_INDEX] = execContext.lastResult == null ? "" : execContext.lastResult.toString();
                string = StringUtil.substituteVars(string, execContext.macroArgs, ExecContext.MACRO_VAR_NAMES, execContext.macroVars);
                try {
                    booleanExpr = ExprParser.parseBooleanExpr(string, this.prefixToNS, true);
                }
                catch (ParseException parseException) {
                    if (execContext.trace) {
                        System.err.println("   cannot parse expression='" + string + "': " + MiscUtil.reason(parseException));
                    }
                    return false;
                }
            }
            try {
                bl = booleanExpr.eval(xNode, execContext);
            }
            catch (EvalException evalException) {
                if (execContext.trace) {
                    System.err.println("   cannot evaluate expression='" + string + "': " + MiscUtil.reason(evalException));
                }
                return false;
            }
            return bl;
        }

        public void execute(ExecContext execContext) {
        }
    }

    public static class Match
    extends XPathItem {
        private String patternXPath;
        private PathPattern pattern;
        private boolean antiPattern;

        public Match(String string, String string2, boolean bl, PrefixToNamespace prefixToNamespace) throws ParseException {
            super(5, string, prefixToNamespace);
            this.patternXPath = string2;
            this.antiPattern = bl;
            if (string2.indexOf(37) < 0) {
                this.pattern = ExprParser.parsePattern(string2, prefixToNamespace, true);
            }
        }

        public String getPattern() {
            return this.patternXPath;
        }

        public boolean isAntiPattern() {
            return this.antiPattern;
        }

        protected boolean doPrepare(ExecContext execContext) {
            boolean bl;
            if (!super.doPrepare(execContext)) {
                return false;
            }
            XNode xNode = this.contextNode;
            this.contextNode = null;
            String string = this.patternXPath;
            PathPattern pathPattern = this.pattern;
            if (pathPattern == null) {
                execContext.macroVars[ExecContext.LAST_RESULT_INDEX] = execContext.lastResult == null ? "" : execContext.lastResult.toString();
                string = StringUtil.substituteVars(string, execContext.macroArgs, ExecContext.MACRO_VAR_NAMES, execContext.macroVars);
                try {
                    pathPattern = ExprParser.parsePattern(string, this.prefixToNS, true);
                }
                catch (ParseException parseException) {
                    if (execContext.trace) {
                        System.err.println("   cannot parse pattern='" + string + "': " + MiscUtil.reason(parseException));
                    }
                    return false;
                }
            }
            try {
                bl = pathPattern.matches(xNode, execContext);
            }
            catch (EvalException evalException) {
                if (execContext.trace) {
                    System.err.println("   cannot match pattern='" + string + "': " + MiscUtil.reason(evalException));
                }
                return false;
            }
            return this.antiPattern ? !bl : bl;
        }

        public void execute(ExecContext execContext) {
        }
    }

    public static abstract class XPathItem
    extends Item {
        protected String contextXPath;
        protected PrefixToNamespace prefixToNS;
        protected NodeSetExpr contextExpr;
        protected XNode contextNode;

        protected XPathItem(int n, String string, PrefixToNamespace prefixToNamespace) throws ParseException {
            super(n);
            if ("/".equals(string)) {
                string = null;
            }
            this.contextXPath = string;
            this.prefixToNS = prefixToNamespace;
            if (string != null) {
                if (MacroCommand.SELECTED_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.SELECTED_XPATH;
                } else if (MacroCommand.SELECTED_ELEMENT_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.SELECTED_ELEMENT_XPATH;
                } else if (MacroCommand.IMPLICIT_ELEMENT_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.IMPLICIT_ELEMENT_XPATH;
                } else if (MacroCommand.SELECTED_NODE_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.SELECTED_NODE_XPATH;
                } else if (MacroCommand.IMPLICIT_NODE_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.IMPLICIT_NODE_XPATH;
                } else if (MacroCommand.DOT_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.DOT_XPATH;
                } else if (MacroCommand.MARK_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.MARK_XPATH;
                } else if (MacroCommand.SELECTED2_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.SELECTED2_XPATH;
                } else if (MacroCommand.CLICKED_ELEMENT_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.CLICKED_ELEMENT_XPATH;
                } else if (MacroCommand.CLICKED_NODE_XPATH.equals(string)) {
                    this.contextXPath = MacroCommand.CLICKED_NODE_XPATH;
                } else if (string.indexOf(37) < 0) {
                    this.contextExpr = ExprParser.parseNodeSetExpr(string, prefixToNamespace, true);
                }
            }
        }

        public String getContext() {
            return this.contextXPath;
        }

        public PrefixToNamespace getPrefixToNamespace() {
            return this.prefixToNS;
        }

        protected boolean doPrepare(ExecContext execContext) {
            Object object;
            this.contextNode = null;
            Document document = execContext.docView.getDocument();
            if (this.contextXPath == null) {
                this.contextNode = document;
                return true;
            }
            if (this.contextXPath == MacroCommand.SELECTED_XPATH) {
                this.contextNode = execContext.docView.getSelectedNode();
                return this.contextNode != null;
            }
            if (this.contextXPath == MacroCommand.SELECTED_ELEMENT_XPATH) {
                this.contextNode = execContext.docView.getSelectedElement(false);
                return this.contextNode != null;
            }
            if (this.contextXPath == MacroCommand.IMPLICIT_ELEMENT_XPATH) {
                this.contextNode = execContext.docView.getSelectedElement(true);
                return this.contextNode != null;
            }
            if (this.contextXPath == MacroCommand.SELECTED_NODE_XPATH) {
                this.contextNode = execContext.docView.getSelectedNode(false);
                return this.contextNode != null;
            }
            if (this.contextXPath == MacroCommand.IMPLICIT_NODE_XPATH) {
                this.contextNode = execContext.docView.getSelectedNode(true);
                return this.contextNode != null;
            }
            if (this.contextXPath == MacroCommand.DOT_XPATH) {
                MarkManager markManager = execContext.docView.getMarkManager();
                TextLocation textLocation = markManager.getDot();
                if (textLocation != null) {
                    this.contextNode = textLocation.getTextNode();
                }
                return this.contextNode != null;
            }
            if (this.contextXPath == MacroCommand.MARK_XPATH) {
                MarkManager markManager = execContext.docView.getMarkManager();
                TextLocation textLocation = markManager.getMark();
                if (textLocation != null) {
                    this.contextNode = textLocation.getTextNode();
                }
                return this.contextNode != null;
            }
            if (this.contextXPath == MacroCommand.SELECTED2_XPATH) {
                this.contextNode = execContext.docView.getSelectedNode2();
                return this.contextNode != null;
            }
            if (this.contextXPath == MacroCommand.CLICKED_ELEMENT_XPATH || this.contextXPath == MacroCommand.CLICKED_NODE_XPATH) {
                this.contextNode = execContext.docView.viewToModel(execContext.mouseX, execContext.mouseY);
                if (this.contextNode != null && this.contextXPath == MacroCommand.CLICKED_ELEMENT_XPATH && !(this.contextNode instanceof Element)) {
                    this.contextNode = ((Node)this.contextNode).getParentElement();
                }
                return this.contextNode != null;
            }
            String string = this.contextXPath;
            NodeSetExpr nodeSetExpr = this.contextExpr;
            if (nodeSetExpr == null) {
                execContext.macroVars[ExecContext.LAST_RESULT_INDEX] = execContext.lastResult == null ? "" : execContext.lastResult.toString();
                string = StringUtil.substituteVars(string, execContext.macroArgs, ExecContext.MACRO_VAR_NAMES, execContext.macroVars);
                try {
                    nodeSetExpr = ExprParser.parseNodeSetExpr(string, this.prefixToNS, true);
                }
                catch (ParseException parseException) {
                    if (execContext.trace) {
                        System.err.println("   cannot parse context='" + string + "': " + MiscUtil.reason(parseException));
                    }
                    return false;
                }
            }
            try {
                object = nodeSetExpr.eval(document, execContext);
                this.contextNode = object.next();
            }
            catch (EvalException evalException) {
                if (execContext.trace) {
                    System.err.println("   cannot evaluate context='" + string + "': " + MiscUtil.reason(evalException));
                }
                return false;
            }
            if (this.contextNode != null && (object = this.contextNode.document()) != document) {
                this.contextNode = null;
                if (execContext.trace) {
                    System.err.println("   context='" + string + "' is not inside document '" + document.getLocation() + "'");
                }
                return false;
            }
            return this.contextNode != null;
        }
    }

    public static final class Sequence
    extends GroupItem {
        public Sequence(Item[] itemArray) {
            super(2, itemArray);
        }

        protected boolean doPrepare(ExecContext execContext) {
            if (this.items.length == 0) {
                return false;
            }
            return this.items[0].prepare(execContext);
        }

        protected void doExecute(ExecContext execContext) {
            int n = 0;
            while (n < this.items.length) {
                Item item = this.items[n];
                if (n > 0 && !item.prepare(execContext)) break;
                item.execute(execContext);
                if (execContext.lastResult == Command.EXECUTION_FAILED) break;
                ++n;
            }
        }
    }

    public static final class Choice
    extends GroupItem {
        private Item chosenItem = null;

        public Choice(Item[] itemArray) {
            super(1, itemArray);
        }

        protected boolean doPrepare(ExecContext execContext) {
            int n = 0;
            while (n < this.items.length) {
                Item item = this.items[n];
                if (item.prepare(execContext)) {
                    this.chosenItem = item;
                    return true;
                }
                ++n;
            }
            return false;
        }

        protected void doExecute(ExecContext execContext) {
            this.chosenItem.execute(execContext);
            this.chosenItem = null;
        }
    }

    public static abstract class GroupItem
    extends Item {
        protected Item[] items;

        protected GroupItem(int n, Item[] itemArray) {
            super(n);
            this.items = itemArray;
        }

        public Item[] getItems() {
            return this.items;
        }
    }

    public static final class Fail
    extends TestItem {
        public Fail(Item[] itemArray) {
            super(4, itemArray);
        }

        protected boolean doPrepare(ExecContext execContext) {
            int n = 0;
            while (n < this.items.length) {
                if (!this.items[n].prepare(execContext)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    public static final class Pass
    extends TestItem {
        public Pass(Item[] itemArray) {
            super(3, itemArray);
        }

        protected boolean doPrepare(ExecContext execContext) {
            int n = 0;
            while (n < this.items.length) {
                if (!this.items[n].prepare(execContext)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }

    public static abstract class TestItem
    extends Item {
        protected Item[] items;

        protected TestItem(int n, Item[] itemArray) {
            super(n);
            this.items = itemArray;
        }

        public Item[] getItems() {
            return this.items;
        }

        public void execute(ExecContext execContext) {
        }
    }

    public static final class Invocation
    extends Item {
        private String commandName;
        private String parameter;
        private Command command;
        private Command preparedCmd = null;
        private String substitutedParam = null;

        public Invocation(String string, String string2) {
            super(0);
            this.commandName = string;
            this.parameter = string2;
            this.command = null;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getParameter() {
            return this.parameter;
        }

        public Command getCommand() {
            if (this.command == null) {
                this.command = Commands.getCommand(this.commandName);
            }
            return this.command;
        }

        protected boolean doPrepare(ExecContext execContext) {
            this.preparedCmd = this.getCommand();
            if (this.preparedCmd == null) {
                if (execContext.trace) {
                    System.err.println("   COMMAND '" + this.commandName + "' NOT FOUND");
                }
                return false;
            }
            if (this.parameter == null) {
                this.substitutedParam = null;
            } else if (this.parameter.indexOf(37) < 0) {
                this.substitutedParam = this.parameter;
            } else {
                execContext.macroVars[ExecContext.LAST_RESULT_INDEX] = execContext.lastResult == null ? "" : execContext.lastResult.toString();
                this.substitutedParam = StringUtil.substituteVars(this.parameter, execContext.macroArgs, ExecContext.MACRO_VAR_NAMES, execContext.macroVars);
            }
            if (execContext.trace) {
                System.err.println("   " + Invocation.cmd(this.commandName, this.substitutedParam));
            }
            boolean bl = this.preparedCmd.prepareCommand(execContext.docView, this.substitutedParam, execContext.mouseX, execContext.mouseY);
            return bl;
        }

        protected void doExecute(ExecContext execContext) {
            if (execContext.trace) {
                System.err.println("   " + Invocation.cmd(this.commandName, this.substitutedParam));
            }
            execContext.lastResult = this.preparedCmd.executeCommand(execContext.docView, this.substitutedParam, execContext.mouseX, execContext.mouseY);
            this.preparedCmd = null;
            this.substitutedParam = null;
        }

        private static final String cmd(String string, String string2) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            if (string2 != null) {
                stringBuffer.append(' ');
                char c = string2.indexOf(34) < 0 ? (char)'\"' : '\'';
                stringBuffer.append(c);
                stringBuffer.append(string2);
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
    }

    public static abstract class Item {
        protected byte type;

        protected Item(int n) {
            this.type = (byte)n;
        }

        public int getType() {
            return this.type;
        }

        public boolean prepare(ExecContext execContext) {
            if (execContext.trace) {
                System.err.print(Item.prefix(true, execContext.macroName, this.type));
                System.err.println("checking...");
            }
            boolean bl = this.doPrepare(execContext);
            if (execContext.trace) {
                System.err.print(Item.prefix(false, execContext.macroName, this.type));
                if (bl) {
                    System.err.println("can execute");
                } else {
                    System.err.println("CANNOT EXECUTE");
                }
            }
            return bl;
        }

        public void execute(ExecContext execContext) {
            if (execContext.trace) {
                System.err.print(Item.prefix(true, execContext.macroName, this.type));
                System.err.println("executing...");
            }
            this.doExecute(execContext);
            if (execContext.trace) {
                System.err.print(Item.prefix(false, execContext.macroName, this.type));
                if (execContext.lastResult == null) {
                    System.err.println("executed");
                } else if (execContext.lastResult == Command.EXECUTION_FAILED) {
                    System.err.println("EXECUTION CANCELED OR FAILED");
                } else {
                    System.err.println("execution result='" + execContext.lastResult + "'");
                }
            }
        }

        private static final String prefix(boolean bl, String string, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append("-->");
            } else {
                stringBuffer.append("<--");
            }
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            switch (n) {
                case 0: {
                    stringBuffer.append("command");
                    break;
                }
                case 1: {
                    stringBuffer.append("choice");
                    break;
                }
                case 2: {
                    stringBuffer.append("sequence");
                    break;
                }
                case 3: {
                    stringBuffer.append("pass");
                    break;
                }
                case 4: {
                    stringBuffer.append("fail");
                    break;
                }
                case 5: {
                    stringBuffer.append("match");
                    break;
                }
                case 6: {
                    stringBuffer.append("test");
                    break;
                }
                case 7: {
                    stringBuffer.append("get");
                    break;
                }
                case 8: {
                    stringBuffer.append("set");
                }
            }
            stringBuffer.append(": ");
            return stringBuffer.toString();
        }

        protected boolean doPrepare(ExecContext execContext) {
            return false;
        }

        protected void doExecute(ExecContext execContext) {
        }
    }
}

