/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.imagetoolkit.ImageConverter;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkits;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;
import java.util.ArrayList;

public final class ConvertImageItem
extends ProcessCommandItem {
    private String from;
    private String[] skip;
    private String to;
    private String[] format;
    private String[] parameters;
    private boolean lenient;

    public ConvertImageItem(String string, String[] stringArray, String string2, String[] stringArray2, String[] stringArray3, boolean bl) {
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        if (stringArray2 != null && stringArray2.length == 0) {
            stringArray2 = null;
        }
        this.from = string;
        this.skip = stringArray;
        this.to = string2;
        this.format = stringArray2;
        this.parameters = stringArray3;
        this.lenient = bl;
    }

    public String getFrom() {
        return this.from;
    }

    public String[] getSkip() {
        return this.skip;
    }

    public String getTo() {
        return this.to;
    }

    public String[] getFormat() {
        return this.format;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        File file2;
        File file3;
        File[] fileArray;
        String string = ProcessCommandItem.substitute(this.from, stringArray, stringArray2);
        String string2 = ProcessCommandItem.substitute(this.to, stringArray, stringArray2);
        String[] stringArray3 = null;
        if (this.skip != null) {
            stringArray3 = ProcessCommandItem.substitute(this.skip, stringArray, stringArray2);
        }
        String[] stringArray4 = null;
        if (this.format != null) {
            stringArray4 = ProcessCommandItem.substitute(this.format, stringArray, stringArray2);
        }
        if ((fileArray = ConvertImageItem.listFiles(file3 = ProcessCommandItem.resolve(string, file), stringArray3, file2 = ProcessCommandItem.resolve(string2, file), stringArray4 == null ? null : stringArray4[0])) == null || fileArray.length == 0) {
            return null;
        }
        if ("Professional".equals("Standard")) {
            throw new ProcessCommandItemException(Msg.msg("imageConversionDisabled") + "\n\n" + Msg.msg("notRestrictedInProEdition"));
        }
        String[] stringArray5 = this.parameters != null ? ProcessCommandItem.substituteParameters(this.parameters, stringArray, stringArray2) : new String[]{};
        String[] stringArray6 = null;
        if (file2.isDirectory() && stringArray4 != null && stringArray4.length >= 2) {
            stringArray6 = new String[stringArray4.length - 1];
            System.arraycopy(stringArray4, 1, stringArray6, 0, stringArray6.length);
        }
        int n = 0;
        while (n < fileArray.length) {
            File file4 = fileArray[n];
            File file5 = fileArray[n + 1];
            try {
                boolean bl = ConvertImageItem.convertImage(file4, file5, stringArray6, stringArray5, console);
                if (!bl) {
                    throw new RuntimeException(Msg.msg("imageConverterNotAvailable"));
                }
            }
            catch (Exception exception) {
                String string3 = Msg.msg("cannotConvertImage", file4, file5, MiscUtil.reason(exception));
                if (this.lenient) {
                    console.showMessage(string3, 2);
                }
                throw new ProcessCommandItemException(string3);
            }
            n += 2;
        }
        return null;
    }

    private static boolean convertImage(File file, File file2, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        Object object;
        Object object2;
        String string = FileUtil.fileExtension(file.getPath());
        File file3 = null;
        if (string.equalsIgnoreCase(FileUtil.fileExtension(file2.getPath()))) {
            file3 = file2;
        }
        if (file3 == null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n])) {
                    object2 = FileUtil.trimFileExtension(file2.getPath());
                    file3 = new File((String)object2 + '.' + stringArray[n]);
                    break;
                }
                ++n;
            }
        }
        if (file3 != null) {
            ProcessCommandItem.copyFile(FileUtil.fileToURL(file), file3, console);
            return true;
        }
        ImageToolkit[] imageToolkitArray = ImageToolkits.getAll();
        object2 = null;
        int n = 0;
        while (n < imageToolkitArray.length) {
            object = imageToolkitArray[n].getImageConverter(file, file2);
            if (object != null) {
                object2 = object;
                break;
            }
            ++n;
        }
        if (object2 == null && stringArray != null) {
            object = FileUtil.trimFileExtension(file2.getPath());
            int n2 = 0;
            block2: while (n2 < stringArray.length) {
                file2 = new File((String)object + '.' + stringArray[n2]);
                int n3 = 0;
                while (n3 < imageToolkitArray.length) {
                    ImageConverter imageConverter = imageToolkitArray[n3].getImageConverter(file, file2);
                    if (imageConverter != null) {
                        object2 = imageConverter;
                        break block2;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        if (object2 == null) {
            return false;
        }
        console.showMessage(Msg.msg("convertingImage", file, file2), 0);
        object2.convertImage(file, file2, stringArray2, console);
        return true;
    }

    private static File[] listFiles(File file, String[] stringArray, File file2, String string) throws ProcessCommandItemException {
        File[] fileArray;
        File[] fileArray2;
        if (file.isDirectory()) {
            fileArray2 = file.listFiles();
            if (fileArray2 == null) {
                throw new ProcessCommandItemException(Msg.msg("cannotListDir", file));
            }
        } else {
            fileArray2 = file.isFile() ? new File[]{file} : ProcessCommandItem.glob(file);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < fileArray2.length) {
            File file3 = fileArray2[n];
            if (file3.isFile() && (stringArray == null || (fileArray = FileUtil.fileExtension(file3.getPath())) == null || fileArray.length() == 0 || !StringUtil.containsIgnoreCase(stringArray, (String)fileArray))) {
                arrayList.add(file3);
            }
            ++n;
        }
        fileArray2 = new File[arrayList.size()];
        arrayList.toArray(fileArray2);
        int n2 = fileArray2.length;
        if (n2 == 0) {
            return null;
        }
        if (file2.isDirectory()) {
            if (string == null) {
                throw new ProcessCommandItemException(Msg.msg("imageFormatNotSpecified", file2));
            }
            fileArray = new File[2 * n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                File file4 = fileArray2[n4];
                String string2 = file4.getName();
                string2 = FileUtil.trimFileExtension(string2);
                string2 = string2 + "." + string;
                File file5 = new File(file2, string2);
                fileArray[n3++] = file4;
                fileArray[n3++] = file5;
                ++n4;
            }
            return fileArray;
        }
        if (n2 > 1) {
            throw new ProcessCommandItemException(Msg.msg("noDestinationDirForConvertedImages", new Integer(n2), file2));
        }
        return new File[]{fileArray2[0], file2};
    }
}

