/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentTypeDeclaration;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.edit.DocumentResource;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.edit.SaveOptions;
import com.xmlmind.xmledit.edit.SimpleDocumentCache;
import com.xmlmind.xmledit.form.ImageDataTypes;
import com.xmlmind.xmledit.imagetoolkit.XMLImageUtil;
import com.xmlmind.xmledit.search.SearchReplaceText;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.GroupCapture;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xpath.EvalException;
import com.xmlmind.xmledit.xpath.ExprContext;
import com.xmlmind.xmledit.xpath.ExprParser;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmledit.xpath.SimpleExprContext;
import com.xmlmind.xmledit.xpath.StringExpr;
import com.xmlmind.xmledit.xpath.StringVariant;
import com.xmlmind.xmledit.xpath.Variant;
import com.xmlmind.xmleditapp.command.ExtractImage;
import com.xmlmind.xmleditapp.dochook.DocumentHook;
import com.xmlmind.xmleditapp.macro.MacroCommandUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import com.xmlmind.xmleditapp.spreadsheet.SpreadsheetHelper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class CopyDocumentItem
extends ProcessCommandItem
implements ImageDataTypes {
    private boolean selection;
    private boolean preserveEntityRefs;
    private boolean preserveXIncludes;
    private boolean saveCharsAsEntityRefs;
    private boolean indent;
    private String encoding;
    private String dstPath;
    private ExtractSpec[] extractSpecs;
    private ResourcesAction[] resActions;
    private static final String EXTRACTION_NODE_PROPERTY = "com.xmlmind.xmleditapp.process.CopyDocumentItem.extractionNode";

    public CopyDocumentItem(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string, String string2, ExtractSpec[] extractSpecArray, ResourcesAction[] resourcesActionArray) {
        if (extractSpecArray != null && extractSpecArray.length == 0) {
            extractSpecArray = null;
        }
        if (resourcesActionArray != null && resourcesActionArray.length == 0) {
            resourcesActionArray = null;
        }
        this.selection = bl;
        this.preserveEntityRefs = bl2;
        this.preserveXIncludes = bl3;
        this.saveCharsAsEntityRefs = bl4;
        this.indent = bl5;
        this.encoding = string;
        this.dstPath = string2;
        this.extractSpecs = extractSpecArray;
        this.resActions = resourcesActionArray;
    }

    public boolean isSelection() {
        return this.selection;
    }

    public boolean getPreserveEntityRefs() {
        return this.preserveEntityRefs;
    }

    public boolean getPreserveXIncludes() {
        return this.preserveXIncludes;
    }

    public boolean getSaveCharsAsEntityRefs() {
        return this.saveCharsAsEntityRefs;
    }

    public boolean getIndent() {
        return this.indent;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getDestinationPath() {
        return this.dstPath;
    }

    public ExtractSpec[] getExtractSpecs() {
        return this.extractSpecs;
    }

    public ResourcesAction[] getResourceActions() {
        return this.resActions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        DocumentHook[] documentHookArray;
        String string = ProcessCommandItem.substitute(this.dstPath, stringArray, stringArray2);
        console.showMessage(Msg.msg("copyingDocumentTo", string), 0);
        File file2 = ProcessCommandItem.resolve(string, file);
        if (file2.isDirectory() && (documentHookArray = document.getLocation()) != null) {
            file2 = new File(file2, URIUtil.unescape(URLUtil.getRawBaseName((URL)documentHookArray)));
        }
        DocumentUtil.commitChanges(document);
        document = this.getSavedDocument(document);
        documentHookArray = (DocumentHook[])document.getProperty("DOCUMENT_HOOKS");
        if (documentHookArray != null) {
            CopyDocumentItem.copyingDocument(documentHookArray, document, this.selection, file2);
        }
        int n = 3;
        try {
            if (this.extractSpecs != null) {
                this.extractObjects(document, file, stringArray, stringArray2, console);
            }
            this.copyResources(document, file, stringArray, stringArray2, console);
            SaveOptions saveOptions = new SaveOptions();
            saveOptions.preserveEntityRefs = this.preserveEntityRefs;
            saveOptions.preserveXIncludes = this.preserveXIncludes;
            saveOptions.saveCharsAsEntityRefs = this.saveCharsAsEntityRefs;
            saveOptions.indent = this.indent ? 2 : -1;
            saveOptions.xmlEncoding = this.encoding;
            SpreadsheetHelper.configureSaveOptions(saveOptions, document);
            DocumentUtil.saveDocument(document, file2, saveOptions);
            n = 2;
            Object var12_11 = null;
            if (documentHookArray == null) return null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (documentHookArray == null) throw throwable;
            CopyDocumentItem.documentCopied(documentHookArray, document, n);
            throw throwable;
        }
        CopyDocumentItem.documentCopied(documentHookArray, document, n);
        return null;
    }

    private static final void copyingDocument(DocumentHook[] documentHookArray, Document document, boolean bl, File file) {
        int n = 0;
        while (n < documentHookArray.length) {
            try {
                documentHookArray[n].copyingDocument(document, bl, file);
            }
            catch (Throwable throwable) {
                CopyDocumentItem.reportHookError(documentHookArray[n], throwable);
            }
            ++n;
        }
    }

    private static final void documentCopied(DocumentHook[] documentHookArray, Document document, int n) {
        int n2 = 0;
        while (n2 < documentHookArray.length) {
            try {
                documentHookArray[n2].documentCopied(document, n);
            }
            catch (Throwable throwable) {
                CopyDocumentItem.reportHookError(documentHookArray[n2], throwable);
            }
            ++n2;
        }
    }

    private static final void reportHookError(DocumentHook documentHook, Throwable throwable) {
        System.err.println("Error in documentHook " + documentHook.getClass().getName() + ": " + MiscUtil.reason(throwable));
        System.err.println("----------------------------------------");
        throwable.printStackTrace();
        System.err.println("----------------------------------------");
    }

    private Document getSavedDocument(Document document) {
        Document document2;
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        Element element = null;
        int n = -1;
        int n2 = -1;
        if (this.selection && (object3 = (MarkManager)document.getProperty("MARK_MANAGER")) != null && (object2 = ((MarkManager)object3).getSelected()) != null) {
            objectArray = ((NodeMark)object2).getNode();
            NodeMark nodeMark = ((MarkManager)object3).getSelected2();
            if (nodeMark == null) {
                object = objectArray;
            } else {
                object = nodeMark.getNode();
                boolean bl = true;
                Object object4 = objectArray;
                while (object4 != null) {
                    if (object4 == object) {
                        bl = false;
                        break;
                    }
                    object4 = object4.getNextSibling();
                }
                if (bl) {
                    Object[] objectArray2 = objectArray;
                    objectArray = object;
                    object = objectArray2;
                }
            }
            if (objectArray == object) {
                if (objectArray instanceof Element) {
                    element = (Element)objectArray;
                } else {
                    element = objectArray.getParentElement();
                    n = n2 = element.indexOfChild((Node)objectArray);
                }
            } else {
                element = objectArray.getParentElement();
                n = element.indexOfChild((Node)objectArray);
                n2 = element.indexOfChild((Node)object);
            }
        }
        if (element != null) {
            document2 = new Document();
            object3 = document.getDocumentTypeDeclaration();
            if (object3 != null) {
                document2.appendChild(((DocumentTypeDeclaration)object3).copy());
            }
            object2 = (Element)element.copy();
            document2.appendChild((Node)object2);
            if (n >= 0) {
                objectArray = new ProcessingInstruction("select-child-nodes");
                objectArray.setText(Integer.toString(2 + n) + "-" + Integer.toString(2 + n2));
                ((Element)object2).insertChild(((Tree)object2).getFirstChild(), (Node)objectArray);
            }
            objectArray = document.getProperties();
            while (objectArray.hasMoreElements()) {
                object = (Object[])objectArray.nextElement();
                document2.putProperty(object[0], object[1]);
            }
            document2.removeProperties(4000);
            ((Tree)object2).removeProperty("LOCATION_INFO");
            object = element.getLocation();
            if (object != null) {
                document2.putLocationInfo(((URL)object).toExternalForm(), false);
            }
        } else if (this.extractSpecs != null || document.hasProperty("DOCUMENT_RESOURCES")) {
            document2 = (Document)document.copy();
            document2.removeProperties(4000);
        } else {
            document2 = document;
        }
        return document2;
    }

    private void extractObjects(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object[] objectArray;
        Object object5;
        Serializable serializable;
        ArrayList<ExtractAction> arrayList = new ArrayList<ExtractAction>();
        int n2 = 0;
        while (n2 < this.extractSpecs.length) {
            ExtractSpec extractSpec = this.extractSpecs[n2];
            serializable = ProcessCommandItem.resolve(ProcessCommandItem.substitute(extractSpec.toDir, stringArray, stringArray2), file);
            String string2 = null;
            if (extractSpec.baseName != null) {
                string2 = ProcessCommandItem.substitute(extractSpec.baseName, stringArray, stringArray2);
                if ((string2 = FileUtil.trimFileExtension(string2)).length() == 0) {
                    string2 = null;
                }
            }
            object5 = null;
            if (extractSpec.extension != null && ((String)(object5 = ProcessCommandItem.substitute(extractSpec.extension, stringArray, stringArray2))).length() == 0) {
                object5 = null;
            }
            objectArray = extractSpec.xpath.select(document);
            n = 0;
            while (n < objectArray.length) {
                Object object6 = objectArray[n];
                object4 = null;
                object3 = null;
                if (object6 instanceof Attribute) {
                    object2 = (Attribute)object6;
                    object4 = ((Attribute)object2).element;
                    object3 = ((Attribute)object2).name;
                } else if (object6 instanceof Element) {
                    object4 = (Element)object6;
                }
                if (object4 != null) {
                    int n3 = ExtractImage.getInstance().canExtractImage((Element)object4, (Name)object3, extractSpec.dataType);
                    if (n3 == 0) {
                        console.showMessage(Msg.msg("unusableExtractSpec", extractSpec.toString((NamespaceToPrefixes)object4), object4), 1);
                    } else {
                        string = string2 == null ? ExtractImage.getInstance().tempFileBaseName((Element)object4) : string2;
                        object = object5 == null ? "%X" : object5;
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string);
                        stringBuffer.append('_');
                        stringBuffer.append(Integer.toString(arrayList.size()));
                        stringBuffer.append('.');
                        stringBuffer.append((String)object);
                        File file2 = new File((File)serializable, stringBuffer.toString());
                        arrayList.add(new ExtractAction((Element)object4, (Name)object3, n3, file2, extractSpec.addedPI, extractSpec.replacementElement));
                    }
                }
                ++n;
            }
            ++n2;
        }
        int n4 = arrayList.size();
        if (n4 == 0) {
            return;
        }
        serializable = new IdentityHashMap();
        int n5 = 0;
        while (n5 < n4) {
            object5 = (ExtractAction[])arrayList.get(n5);
            if (!((IdentityHashMap)serializable).containsKey(((ExtractAction)object5).element)) {
                ((IdentityHashMap)serializable).put(((ExtractAction)object5).element, object5);
            }
            ++n5;
        }
        arrayList = null;
        object5 = new ExtractAction[((IdentityHashMap)serializable).size()];
        ((IdentityHashMap)serializable).values().toArray((T[])object5);
        objectArray = new ExtractAction[((ExtractAction[])object5).length];
        n = 0;
        int n6 = 0;
        while (n6 < ((Object)object5).length) {
            object4 = object5[n6];
            object3 = ((ExtractAction)object4).element.getParentElement();
            if (!(object3 == null && ((ExtractAction)object4).replacementElement != null || CopyDocumentItem.hasReplacedAncestor((Element)object3, (ExtractAction[])object5))) {
                objectArray[n++] = object4;
            }
            ++n6;
        }
        if (n == objectArray.length) {
            object5 = objectArray;
        } else {
            object5 = new ExtractAction[n];
            System.arraycopy(objectArray, 0, object5, 0, n);
        }
        int n7 = 0;
        while (n7 < ((Object)object5).length) {
            object3 = object5[n7];
            object2 = ((ExtractAction)object3).element.toString();
            if (((ExtractAction)object3).attributeName != null) {
                object2 = (String)object2 + "/@" + ((ExtractAction)object3).attributeName.format(true, ((ExtractAction)object3).element);
            }
            console.showMessage(Msg.msg("extractingObject", ((ExtractAction)object3).outFileName[0], object2), 0);
            string = ExtractImage.getInstance().extractImage(((ExtractAction)object3).element, ((ExtractAction)object3).attributeName, ((ExtractAction)object3).dataType, ((ExtractAction)object3).outFileName, console);
            if (string != null) {
                console.showMessage(Msg.msg("cannotExtractObject", ((ExtractAction)object3).outFileName[0], object2, string), 2);
            } else {
                console.showMessage(Msg.msg("extractedObject", ((ExtractAction)object3).outFileName[0], object2), 0);
                object = CopyDocumentItem.createExtractionNode((ExtractAction)object3, new File(((ExtractAction)object3).outFileName[0]), console);
                if (((ExtractAction)object3).addedPI != null) {
                    ((ExtractAction)object3).element.insertChild(((ExtractAction)object3).element.getFirstChild(), (Node)object);
                } else {
                    ((Element)object).putProperty(EXTRACTION_NODE_PROPERTY, Boolean.TRUE);
                    ((ExtractAction)object3).element.getParent().replaceChild(((ExtractAction)object3).element, (Node)object);
                }
            }
            ++n7;
        }
    }

    private static final boolean hasReplacedAncestor(Element element, ExtractAction[] extractActionArray) {
        int n = 0;
        while (n < extractActionArray.length) {
            ExtractAction extractAction = extractActionArray[n];
            if (element.isDescendantOf(extractAction.element) && extractAction.replacementElement != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static Node createExtractionNode(ExtractAction extractAction, File file, final Console console) {
        Node node;
        final Element element = extractAction.element;
        final ExprContext exprContext = CopyDocumentItem.createExprContext(file);
        if (extractAction.addedPI != null) {
            node = extractAction.addedPI.copy();
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            String string = processingInstruction.getText();
            if (CopyDocumentItem.needSubstitution(string)) {
                processingInstruction.setText(CopyDocumentItem.substitute(string, element, exprContext, console));
            }
        } else {
            node = extractAction.replacementElement.copy();
            Traversal.traverse(node, new Traversal.HandlerBase(){

                public Object processText(Text text) {
                    return this.processTextNode(text);
                }

                public Object processPI(ProcessingInstruction processingInstruction) {
                    return this.processTextNode(processingInstruction);
                }

                public Object processComment(Comment comment) {
                    return this.processTextNode(comment);
                }

                public Object processTextNode(TextNode textNode) {
                    String string = textNode.getText();
                    if (CopyDocumentItem.needSubstitution(string)) {
                        textNode.setText(CopyDocumentItem.substitute(string, element, exprContext, console));
                    }
                    return null;
                }

                public Object enterElement(Element element2) {
                    Attribute[] attributeArray = element2.getAllAttributes();
                    int n = 0;
                    while (n < attributeArray.length) {
                        Attribute attribute = attributeArray[n];
                        if (CopyDocumentItem.needSubstitution(attribute.value)) {
                            element2.putAttribute(attribute.name, CopyDocumentItem.substitute(attribute.value, element, exprContext, console));
                        }
                        ++n;
                    }
                    return null;
                }
            });
        }
        return node;
    }

    private static final ExprContext createExprContext(final File file) {
        SimpleDocumentCache.installDefaultDocumentManager();
        return new SimpleExprContext(){

            public Variant getVariableValue(Name name, XNode xNode) throws EvalException {
                String string = name.getLocalPart();
                String string2 = null;
                if ("url".equals(string)) {
                    string2 = FileUtil.fileToURL(file).toExternalForm();
                } else if ("url.parent".equals(string)) {
                    URL uRL = URLUtil.getDirectory(FileUtil.fileToURL(file));
                    if (uRL != null) {
                        string2 = MacroCommandUtil.dirToExternalForm(uRL);
                    }
                } else if ("url.name".equals(string)) {
                    string2 = URLUtil.getRawBaseName(FileUtil.fileToURL(file));
                } else if ("url.rootName".equals(string)) {
                    String string3 = URLUtil.getRawBaseName(FileUtil.fileToURL(file));
                    if (string3 != null) {
                        string2 = URLPathUtil.trimExtension(string3);
                    }
                } else if ("url.extension".equals(string)) {
                    String string4 = URLUtil.getRawBaseName(FileUtil.fileToURL(file));
                    if (string4 != null) {
                        string2 = URLPathUtil.extension(string4);
                    }
                } else if ("file.path".equals(string)) {
                    string2 = file.getPath();
                } else if ("file.parent".equals(string)) {
                    string2 = file.getParent();
                } else if ("file.name".equals(string)) {
                    string2 = file.getName();
                } else if ("file.rootName".equals(string)) {
                    string2 = FileUtil.trimFileExtension(file.getName());
                } else if ("file.extension".equals(string)) {
                    string2 = FileUtil.fileExtension(file.getName());
                } else if ("file.separator".equals(string)) {
                    string2 = File.separator;
                }
                return string2 == null ? null : new StringVariant(string2);
            }
        };
    }

    private static final boolean needSubstitution(String string) {
        int n = string.indexOf("{");
        if (n < 0) {
            return false;
        }
        int n2 = string.lastIndexOf(125);
        return n2 > n;
    }

    private static final String substitute(String string, Element element, ExprContext exprContext, Console console) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", true);
        block19: while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if ("{".equals(string3)) {
                switch (n) {
                    case 0: {
                        n = 1;
                        continue block19;
                    }
                    case 1: {
                        stringBuffer.append('{');
                        stringBuffer.append('{');
                        n = 0;
                        continue block19;
                    }
                    case 2: {
                        stringBuffer.append('{');
                        stringBuffer.append(string2);
                        stringBuffer.append('{');
                        n = 0;
                        string2 = null;
                        continue block19;
                    }
                    default: {
                        throw new RuntimeException("internal error");
                    }
                }
            }
            if ("}".equals(string3)) {
                switch (n) {
                    case 0: {
                        stringBuffer.append('}');
                        continue block19;
                    }
                    case 1: {
                        stringBuffer.append('{');
                        stringBuffer.append('}');
                        n = 0;
                        continue block19;
                    }
                    case 2: {
                        CopyDocumentItem.appendVal(string2, element, exprContext, console, stringBuffer);
                        n = 0;
                        string2 = null;
                        continue block19;
                    }
                    default: {
                        throw new RuntimeException("internal error");
                    }
                }
            }
            switch (n) {
                case 0: {
                    stringBuffer.append(string3);
                    break;
                }
                case 1: {
                    n = 2;
                    string2 = string3;
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append('{');
                break;
            }
            case 2: {
                stringBuffer.append('{');
                stringBuffer.append(string2);
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        return stringBuffer.toString();
    }

    private static final void appendVal(String string, Element element, ExprContext exprContext, Console console, StringBuffer stringBuffer) {
        String string2 = null;
        StringExpr stringExpr = null;
        try {
            stringExpr = ExprParser.parseStringExpr(string, element, true);
        }
        catch (ParseException parseException) {
            console.showMessage(Msg.msg("cannotParseXPath", string, MiscUtil.reason(parseException)), 2);
        }
        if (stringExpr != null) {
            try {
                string2 = stringExpr.eval(element, exprContext);
            }
            catch (EvalException evalException) {
                console.showMessage(Msg.msg("cannotEvalXPath", string, MiscUtil.reason(evalException)), 2);
            }
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
    }

    private void copyResources(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        Object object;
        Object object2;
        DocumentResource[] documentResourceArray = (DocumentResource[])document.getProperty("DOCUMENT_RESOURCES");
        if (documentResourceArray == null) {
            return;
        }
        ResourcesAction[] resourcesActionArray = this.resActions;
        if (resourcesActionArray == null) {
            resourcesActionArray = new ResourcesAction[]{new ResourcesAction("(https|http|ftp)://.*", null, null), new ResourcesAction(".+", ".", null)};
        }
        int n = resourcesActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = resourcesActionArray[n2];
            object = ProcessCommandItem.substitute(((ResourcesAction)object2).pattern, stringArray, stringArray2);
            try {
                Pattern pattern = Pattern.compile((String)object, 66);
                ((ResourcesAction)object2).matcher = pattern.matcher("dummy");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new ProcessCommandItemException(Msg.msg("invalidREPattern", object));
            }
            ++n2;
        }
        object2 = document.getRootElement();
        object = document.getLocation();
        int n3 = 0;
        while (n3 < documentResourceArray.length) {
            XNode[] xNodeArray = documentResourceArray[n3].getSelector().select((Element)object2);
            int n4 = 0;
            while (n4 < xNodeArray.length) {
                block32: {
                    String string;
                    Object object3;
                    Element element;
                    Attribute attribute;
                    XNode xNode;
                    block33: {
                        block31: {
                            xNode = xNodeArray[n4];
                            attribute = null;
                            element = null;
                            object3 = null;
                            string = null;
                            if (!(xNode instanceof Attribute)) break block31;
                            attribute = (Attribute)xNode;
                            if (CopyDocumentItem.isExtractionNode(attribute.element)) break block32;
                            string = attribute.value;
                            object3 = attribute.element.getLocation();
                            if (object3 == null) {
                                object3 = object;
                            }
                            break block33;
                        }
                        if (!(xNode instanceof Element)) break block33;
                        element = (Element)xNode;
                        if (CopyDocumentItem.isExtractionNode(element)) break block32;
                        string = element.getText();
                        object3 = element.getLocation();
                        if (object3 == null) {
                            object3 = object;
                        }
                    }
                    if (string != null && ((string = string.trim()).length() == 0 || string.equals("???"))) {
                        string = null;
                    }
                    if (string == null) {
                        console.showMessage(Msg.msg("missingResourceURL", xNode), 1);
                    } else {
                        URL uRL;
                        try {
                            uRL = new URL((URL)object3, string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL = null;
                        }
                        if (uRL == null) {
                            console.showMessage(Msg.msg("invalidResourceURL", string, xNode), 1);
                        } else {
                            Object object4;
                            Object object5 = null;
                            GroupCapture[] groupCaptureArray = null;
                            int n5 = 0;
                            while (n5 < n) {
                                object4 = resourcesActionArray[n5];
                                if (((ResourcesAction)object4).matcher != null) {
                                    ((ResourcesAction)object4).matcher.reset(string);
                                    if (((ResourcesAction)object4).matcher.matches()) {
                                        object5 = object4;
                                        groupCaptureArray = GroupCapture.getAll(((ResourcesAction)object4).matcher);
                                        break;
                                    }
                                }
                                ++n5;
                            }
                            if (object5 == null) {
                                console.showMessage(Msg.msg("unmanagedResource", string, xNode), 1);
                            } else if (((ResourcesAction)object5).copyTo != null || ((ResourcesAction)object5).referenceAs != null) {
                                object4 = null;
                                if (((ResourcesAction)object5).copyTo != null) {
                                    object4 = CopyDocumentItem.substitute(((ResourcesAction)object5).copyTo, stringArray, stringArray2, groupCaptureArray);
                                    File file2 = ProcessCommandItem.resolve((String)object4, file);
                                    if (file2.isDirectory()) {
                                        String string2 = URLUtil.getRawBaseName(uRL);
                                        object4 = (String)object4 + '/' + string2;
                                        file2 = new File(file2, URIUtil.unescape(string2));
                                    }
                                    CopyDocumentItem.copyResource(uRL, file2, console);
                                }
                                if (((ResourcesAction)object5).referenceAs != null) {
                                    object4 = CopyDocumentItem.substitute(((ResourcesAction)object5).referenceAs, stringArray, stringArray2, groupCaptureArray);
                                }
                                if (!((String)object4).equals(string)) {
                                    if (attribute != null) {
                                        attribute.element.putAttribute(attribute.name, (String)object4);
                                    } else {
                                        element.setText((String)object4);
                                    }
                                }
                            }
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
        int n6 = 0;
        while (n6 < n) {
            resourcesActionArray[n6].matcher = null;
            ++n6;
        }
    }

    private static final boolean isExtractionNode(Element element) {
        while (element != null) {
            if (element.hasProperty(EXTRACTION_NODE_PROPERTY)) {
                return true;
            }
            element = element.getParentElement();
        }
        return false;
    }

    private static final String substitute(String string, String[] stringArray, String[] stringArray2, GroupCapture[] groupCaptureArray) {
        string = ProcessCommandItem.substitute(string, stringArray, stringArray2);
        string = SearchReplaceText.substituteMatchVars(string, groupCaptureArray);
        return string;
    }

    private static final void copyResource(URL uRL, File file, Console console) throws IOException {
        if (XMLImageUtil.isXMLImage(uRL)) {
            console.showMessage(Msg.msg("scanningXMLImageForResources", URLUtil.toDisplayForm(uRL)), 0);
            try {
                Document document = XMLImageUtil.loadImageDocument(uRL);
                if (XMLImageUtil.processImageDocument(document, uRL)) {
                    console.showMessage(Msg.msg("copyingFile", URLUtil.toDisplayForm(uRL), file), 0);
                    XMLImageUtil.saveImageDocument(document, file, false);
                    return;
                }
            }
            catch (Exception exception) {
                console.showMessage(Msg.msg("cannotScanXMLImageForResources", URLUtil.toDisplayForm(uRL), MiscUtil.reason(exception)), 2);
            }
        }
        ProcessCommandItem.copyFile(uRL, file, console);
    }

    private static final class ExtractAction {
        public Element element;
        public Name attributeName;
        public int dataType;
        public String[] outFileName = new String[1];
        private ProcessingInstruction addedPI;
        private Element replacementElement;

        public ExtractAction(Element element, Name name, int n, File file, ProcessingInstruction processingInstruction, Element element2) {
            this.element = element;
            this.attributeName = name;
            this.dataType = n;
            this.outFileName[0] = file.getPath();
            this.addedPI = processingInstruction;
            this.replacementElement = element2;
        }
    }

    public static final class ResourcesAction {
        private String pattern;
        private String copyTo;
        private String referenceAs;
        Matcher matcher = null;

        public ResourcesAction(String string, String string2, String string3) {
            this.pattern = string;
            this.copyTo = string2;
            this.referenceAs = string3;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getCopyTo() {
            return this.copyTo;
        }

        public String getReferenceAs() {
            return this.referenceAs;
        }
    }

    public static final class ExtractSpec {
        private XPath xpath;
        private int dataType;
        private String toDir;
        private String baseName;
        private String extension;
        private ProcessingInstruction addedPI;
        private Element replacementElement;

        public ExtractSpec(XPath xPath, int n, String string, String string2, String string3, ProcessingInstruction processingInstruction, Element element) {
            if (string == null || string.length() == 0) {
                string = ".";
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if (string3 != null && string3.length() == 0) {
                string3 = null;
            }
            this.xpath = xPath;
            this.dataType = n;
            this.toDir = string;
            this.baseName = string2;
            this.extension = string3;
            this.addedPI = processingInstruction;
            this.replacementElement = element;
        }

        public XPath getXPath() {
            return this.xpath;
        }

        public int getDataType() {
            return this.dataType;
        }

        public String getToDir() {
            return this.toDir;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getExtension() {
            return this.extension;
        }

        public ProcessingInstruction getAddedPI() {
            return this.addedPI;
        }

        public Element getReplacementElement() {
            return this.replacementElement;
        }

        public String toString(NamespaceToPrefixes namespaceToPrefixes) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<extract xpath='");
            XMLUtil.escapeXML(this.xpath.toString(namespaceToPrefixes), stringBuffer);
            stringBuffer.append("' toDir='");
            XMLUtil.escapeXML(this.toDir, stringBuffer);
            stringBuffer.append('\'');
            if (this.dataType >= 1 && this.dataType <= 4) {
                stringBuffer.append(" dataType='");
                switch (this.dataType) {
                    case 1: {
                        stringBuffer.append("anyURI");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("hexBinary");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("base64Binary");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("XML");
                    }
                }
                stringBuffer.append('\'');
            }
            if (this.baseName != null) {
                stringBuffer.append(" baseName='");
                XMLUtil.escapeXML(this.baseName, stringBuffer);
                stringBuffer.append('\'');
            }
            if (this.extension != null) {
                stringBuffer.append(" extension='");
                XMLUtil.escapeXML(this.extension, stringBuffer);
                stringBuffer.append('\'');
            }
            stringBuffer.append("/>");
            return stringBuffer.toString();
        }
    }
}

