/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;
import java.io.IOException;

public final class CopyItem
extends ProcessCommandItem {
    private String srcPattern;
    private String dstPath;
    private boolean recurse;
    private boolean quiet;

    public CopyItem(String string, String string2, boolean bl, boolean bl2) {
        this.srcPattern = string;
        this.dstPath = string2;
        this.recurse = bl;
        this.quiet = bl2;
    }

    public String getSourcePattern() {
        return this.srcPattern;
    }

    public String getDestinationPath() {
        return this.dstPath;
    }

    public boolean isRecursive() {
        return this.recurse;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        String string = ProcessCommandItem.substitute(this.srcPattern, stringArray, stringArray2);
        String string2 = ProcessCommandItem.substitute(this.dstPath, stringArray, stringArray2);
        console.showMessage(Msg.msg("copyingFiles", string, string2), 0);
        File file2 = ProcessCommandItem.resolve(string, file);
        File[] fileArray = ProcessCommandItem.glob(file2);
        File file3 = ProcessCommandItem.resolve(string2, file);
        boolean bl = file3.isDirectory();
        if (fileArray.length > 1 && !bl) {
            throw new ProcessCommandItemException(Msg.msg("copyDestinationNotADir", file3));
        }
        int n = 0;
        while (n < fileArray.length) {
            block11: {
                String string3;
                File file4;
                File file5;
                block12: {
                    block13: {
                        block14: {
                            file5 = fileArray[n];
                            if (!file5.exists() && this.quiet) break block11;
                            file4 = bl ? new File(file3, file5.getName()) : file3;
                            string3 = null;
                            try {
                                file5 = file5.getCanonicalFile();
                                file4 = file4.getCanonicalFile();
                                if (file4.equals(file5)) {
                                    throw new IOException("cannot copy '" + file5 + "' to itself");
                                }
                            }
                            catch (IOException iOException) {
                                string3 = MiscUtil.reason(iOException);
                            }
                            if (string3 != null) break block12;
                            if (!file5.isDirectory()) break block13;
                            if (this.recurse) break block14;
                            if (!this.quiet) {
                                throw new ProcessCommandItemException(Msg.msg("willNotCopyDir", file5));
                            }
                            break block11;
                        }
                        try {
                            CopyItem.copyDirectory(file5, file4);
                        }
                        catch (IOException iOException) {
                            string3 = MiscUtil.reason(iOException);
                        }
                        break block12;
                    }
                    try {
                        FileUtil.copyFile(file5, file4);
                    }
                    catch (IOException iOException) {
                        string3 = MiscUtil.reason(iOException);
                    }
                }
                if (string3 != null) {
                    throw new ProcessCommandItemException(Msg.msg("cannotCopyFile", file5, file4, string3));
                }
            }
            ++n;
        }
        return null;
    }

    private static void copyDirectory(File file, File file2) throws IOException {
        if (!file2.mkdir()) {
            throw new IOException("cannot create directory '" + file2 + "'");
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new IOException("cannot list files in directory '" + file + "'");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file3 = new File(file, string);
            File file4 = new File(file2, string);
            if (file3.isDirectory()) {
                CopyItem.copyDirectory(file3, file4);
            } else {
                FileUtil.copyFile(file3, file4);
            }
            ++n;
        }
    }
}

