/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class CopyProcessResourcesItem
extends ProcessCommandItem {
    private String srcPath;
    private String dstPath;

    public CopyProcessResourcesItem(String string, String string2) {
        this.srcPath = string;
        this.dstPath = string2;
    }

    public String getSourcePath() {
        return this.srcPath;
    }

    public String getDestinationPath() {
        return this.dstPath;
    }

    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        String string = ProcessCommandItem.substitute(this.srcPath, stringArray, stringArray2);
        String string2 = ProcessCommandItem.substitute(this.dstPath, stringArray, stringArray2);
        console.showMessage(Msg.msg("copyingProcessRessources", string, string2), 0);
        URL[] uRLArray = CopyProcessResourcesItem.listResources(this.processCommand.getConfigurationURL(), string);
        File file2 = ProcessCommandItem.resolve(string2, file);
        boolean bl = file2.isDirectory();
        if (uRLArray.length > 1) {
            if (!bl) {
                throw new ProcessCommandItemException(Msg.msg("cannotCopyToNonDir", file2));
            }
            int n = 0;
            while (n < uRLArray.length) {
                URL uRL = uRLArray[n];
                ProcessCommandItem.copyFile(uRL, new File(file2, URIUtil.unescape(URLUtil.getRawBaseName(uRL))), console);
                ++n;
            }
        } else if (uRLArray.length == 1) {
            URL uRL = uRLArray[0];
            if (bl) {
                file2 = new File(file2, URIUtil.unescape(URLUtil.getRawBaseName(uRL)));
            }
            ProcessCommandItem.copyFile(uRL, file2, console);
        }
        return null;
    }

    private static final URL[] listResources(URL uRL, String string) throws Exception {
        URL[] uRLArray;
        boolean bl = false;
        if (string.startsWith("@") && string.length() > 1) {
            bl = true;
            string = string.substring(1);
        }
        URL uRL2 = XMLCatalogs.resolveURI(string, uRL);
        if (!bl) {
            File file = FileUtil.urlToFile(uRL2);
            if (file != null) {
                file = new File(file.getParent(), URIUtil.unescape(URLPathUtil.baseName(string)));
                File[] fileArray = ProcessCommandItem.glob(file);
                URL[] uRLArray2 = new URL[fileArray.length];
                int n = 0;
                while (n < fileArray.length) {
                    uRLArray2[n] = FileUtil.fileToURL(fileArray[n]);
                    ++n;
                }
                return uRLArray2;
            }
            return new URL[]{uRL2};
        }
        String string2 = FileUtil.loadString(uRL2);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = stringTokenizer.nextToken();
            arrayList.add(new URL(uRL2, (String)uRLArray));
        }
        uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        return uRLArray;
    }
}

