/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;

public final class DeleteItem
extends ProcessCommandItem {
    private String pattern;
    private boolean recurse;
    private boolean quiet;

    public DeleteItem(String string, boolean bl, boolean bl2) {
        this.pattern = string;
        this.recurse = bl;
        this.quiet = bl2;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isRecursive() {
        return this.recurse;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        String string = ProcessCommandItem.substitute(this.pattern, stringArray, stringArray2);
        console.showMessage(Msg.msg("deletingFiles", string), 0);
        File file2 = ProcessCommandItem.resolve(string, file);
        File[] fileArray = ProcessCommandItem.glob(file2);
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            if (file3.exists() || !this.quiet) {
                if (file3.isDirectory()) {
                    if (!this.recurse) throw new ProcessCommandItemException(Msg.msg("willNotDeleteDir", file3));
                    if (!FileUtil.removeFile(file3, true)) {
                        throw new ProcessCommandItemException(Msg.msg("cannotDeleteDir", file3));
                    }
                } else if (!file3.delete()) {
                    throw new ProcessCommandItemException(Msg.msg("cannotDeleteFile", file3));
                }
            }
            ++n;
        }
        return null;
    }
}

