/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import com.xmlmind.xmleditapp.process.ZipItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;

public final class JarItem
extends ZipItem {
    private String manifestFile;
    private ManifestAttribute[] manifestAttributes;

    public JarItem(String string, ZipItem.FileSet[] fileSetArray) {
        this(string, fileSetArray, null, null);
    }

    public JarItem(String string, ZipItem.FileSet[] fileSetArray, String string2) {
        this(string, fileSetArray, string2, null);
    }

    public JarItem(String string, ZipItem.FileSet[] fileSetArray, ManifestAttribute[] manifestAttributeArray) {
        this(string, fileSetArray, null, manifestAttributeArray);
    }

    private JarItem(String string, ZipItem.FileSet[] fileSetArray, String string2, ManifestAttribute[] manifestAttributeArray) {
        super(string, fileSetArray);
        this.manifestFile = string2;
        this.manifestAttributes = manifestAttributeArray;
    }

    public String getManifestFile() {
        return this.manifestFile;
    }

    public ManifestAttribute[] getManifestAttributes() {
        return this.manifestAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws IOException, ProcessCommandItemException {
        Object object;
        String string = ProcessCommandItem.substitute(this.archive, stringArray, stringArray2);
        console.showMessage(Msg.msg("creatingZipArchive", "jar", string), 0);
        File file2 = ProcessCommandItem.resolve(string, file);
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        if (this.manifestAttributes != null) {
            int n = 0;
            while (n < this.manifestAttributes.length) {
                object = this.manifestAttributes[n];
                String string2 = ProcessCommandItem.substitute(((ManifestAttribute)object).name, stringArray, stringArray2);
                String string3 = ProcessCommandItem.substitute(((ManifestAttribute)object).value, stringArray, stringArray2);
                try {
                    attributes.putValue(string2, string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ProcessCommandItemException(Msg.msg("cannotAddManifestAttribute", string2, string3, MiscUtil.reason(illegalArgumentException)));
                }
                ++n;
            }
        } else if (this.manifestFile != null) {
            String string4 = ProcessCommandItem.substitute(this.manifestFile, stringArray, stringArray2);
            object = ProcessCommandItem.resolve(string4, file);
            FileInputStream fileInputStream = new FileInputStream((File)object);
            try {
                manifest.read(fileInputStream);
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            {
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        object = new JarOutputStream((OutputStream)fileOutputStream, manifest);
        this.zipFiles((ZipOutputStream)object, file2, file, stringArray, stringArray2, console);
        return null;
    }

    public static final class ManifestAttribute {
        public String name;
        public String value;

        public ManifestAttribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

