/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.PostMultipartFormData;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public final class PostItem
extends ProcessCommandItem {
    private String url;
    private Field[] fields;
    private String valueCharset;
    private boolean readResponse;

    public PostItem(String string, Field[] fieldArray, String string2, boolean bl) {
        this.url = string;
        this.fields = fieldArray;
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        this.valueCharset = string2;
        this.readResponse = bl;
    }

    public String getURL() {
        return this.url;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getValueCharset() {
        return this.valueCharset;
    }

    public boolean isReadingResponse() {
        return this.readResponse;
    }

    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws IOException, ProcessCommandItemException {
        Object object;
        URL uRL;
        String string = ProcessCommandItem.substitute(this.url, stringArray, stringArray2);
        console.showMessage(Msg.msg("postingMultiPartFormData", string), 0);
        try {
            uRL = new URL(string);
            if (!uRL.getProtocol().startsWith("http")) {
                throw new RuntimeException(Msg.msg("notAnHTTPURL", uRL));
            }
        }
        catch (Exception exception) {
            throw new ProcessCommandItemException(MiscUtil.reason(exception));
        }
        if ("Professional".equals("Standard")) {
            throw new ProcessCommandItemException(Msg.msg("postingMultiPartFormDataDisabled") + "\n\n" + Msg.msg("notRestrictedInProEdition"));
        }
        PostMultipartFormData postMultipartFormData = null;
        try {
            object = (HttpURLConnection)uRL.openConnection();
            postMultipartFormData = new PostMultipartFormData((HttpURLConnection)object);
        }
        catch (Exception exception) {
            throw new ProcessCommandItemException(Msg.msg("cannotConnectToHTTPServer", uRL, MiscUtil.reason(exception)));
        }
        object = null;
        try {
            try {
                int n = 0;
                while (n < this.fields.length) {
                    String string2;
                    Field field;
                    Field field2 = this.fields[n];
                    String string3 = ProcessCommandItem.substitute(field2.name, stringArray, stringArray2);
                    if (field2 instanceof FileField) {
                        field = (FileField)field2;
                        string2 = ProcessCommandItem.substitute(field.file, stringArray, stringArray2);
                        File file2 = ProcessCommandItem.resolve(string2, file);
                        console.showMessage(Msg.msg("postingFile", file2, uRL), 0);
                        if (!file2.isFile()) {
                            throw new ProcessCommandItemException(Msg.msg("notAFile", file2));
                        }
                        String string4 = "application/octet-stream";
                        if (field.contentType != null) {
                            String string5 = FileUtil.fileExtension(file2.getPath());
                            if ("zip".equalsIgnoreCase(string5)) {
                                string4 = "application/zip";
                            } else if ("jar".equalsIgnoreCase(string5)) {
                                string4 = "application/x-java-archive";
                            } else if ("xml".equalsIgnoreCase(string5)) {
                                string4 = "text/xml";
                            }
                        }
                        postMultipartFormData.writeField(string3, file2, string4);
                    } else {
                        field = (ValueField)field2;
                        string2 = ProcessCommandItem.substitute(((ValueField)field).value, stringArray, stringArray2);
                        postMultipartFormData.writeField(string3, string2, this.valueCharset);
                    }
                    ++n;
                }
                object = postMultipartFormData.post(true, this.readResponse);
            }
            catch (Exception exception) {
                throw new ProcessCommandItemException(Msg.msg("cannotPostToHTTPServer", uRL, MiscUtil.reason(exception)));
            }
            Object var19_21 = null;
            postMultipartFormData.done();
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            postMultipartFormData.done();
            throw throwable;
        }
        return object;
    }

    public static final class FileField
    extends Field {
        public String file;
        public String contentType;

        public FileField(String string, String string2, String string3) {
            super(string);
            this.file = string2;
            this.contentType = string3;
        }
    }

    public static final class ValueField
    extends Field {
        public String value;

        public ValueField(String string, String string2) {
            super(string);
            this.value = string2;
        }
    }

    public static abstract class Field {
        public String name;

        protected Field(String string) {
            this.name = string;
        }
    }
}

