/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

public class PostMultipartFormData {
    public static final String NEWLINE = "\r\n";
    public static final String BOUNDARY_PREFIX = "--";
    protected HttpURLConnection connection;
    protected String boundary;
    protected OutputStream out;

    public PostMultipartFormData(HttpURLConnection httpURLConnection) throws IOException {
        this.connection = httpURLConnection;
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        this.boundary = "----------------------------------------" + Long.toString(System.currentTimeMillis(), 36);
        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data, boundary=" + this.boundary);
        this.out = httpURLConnection.getOutputStream();
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void writeField(String string, String string2) throws IOException {
        this.writeField(string, string2, "ISO-8859-1");
    }

    public void writeField(String string, String string2, String string3) throws IOException {
        this.writeBoundary();
        this.writeBytes("Content-Disposition: form-data; name=" + PostMultipartFormData.quoteFieldName(string));
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Type: text/plain; charset=" + string3);
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Transfer-Encoding: binary");
        this.writeBytes(NEWLINE);
        this.writeBytes(NEWLINE);
        this.writeBytes(string2, string3);
        this.writeBytes(NEWLINE);
        this.out.flush();
    }

    public static String quoteFieldName(String string) throws IOException {
        if (!PostMultipartFormData.isQtext(string)) {
            throw new IOException("not supported: '" + string + "' is not a plain ASCII field name");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static boolean isQtext(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': 
                case '\"': 
                case '\\': {
                    return false;
                }
            }
            if (c > '\u007f') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void writeField(String string, File file) throws IOException {
        this.writeField(string, file, "application/octet-stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeField(String string, File file, String string2) throws IOException {
        this.writeBoundary();
        this.writeBytes("Content-Disposition: form-data; name=" + PostMultipartFormData.quoteFieldName(string) + "; filename=" + PostMultipartFormData.quoteFieldName(file.getName()));
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Type: " + string2);
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Length: " + file.length());
        this.writeBytes(NEWLINE);
        this.writeBytes("Content-Transfer-Encoding: binary");
        this.writeBytes(NEWLINE);
        this.writeBytes(NEWLINE);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            PostMultipartFormData.copyBytes(fileInputStream, this.out);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        this.writeBytes(NEWLINE);
        this.out.flush();
    }

    public static final void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void writeBoundary() throws IOException {
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(this.boundary);
        this.writeBytes(NEWLINE);
    }

    public void writeBytes(String string) throws IOException {
        this.writeBytes(string, "US-ASCII");
    }

    public void writeBytes(String string, String string2) throws IOException {
        this.out.write(string.getBytes(string2));
    }

    public void post() throws IOException {
        this.post(true, false);
    }

    public String post(boolean bl, boolean bl2) throws IOException {
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(this.boundary);
        this.writeBytes(BOUNDARY_PREFIX);
        this.writeBytes(NEWLINE);
        this.out.flush();
        this.out.close();
        this.out = null;
        String string = null;
        if (bl) {
            int n = this.connection.getResponseCode();
            switch (n) {
                case 200: 
                case 201: 
                case 204: {
                    if (n == 204 || !bl2) break;
                    string = this.readResponse();
                    break;
                }
                default: {
                    StringBuffer stringBuffer = new StringBuffer("cannot POST to '");
                    stringBuffer.append(this.connection.getURL());
                    stringBuffer.append("': error ");
                    stringBuffer.append(n);
                    String string2 = this.connection.getResponseMessage();
                    if (string2 != null) {
                        stringBuffer.append(": ");
                        stringBuffer.append(string2);
                    }
                    throw new IOException(stringBuffer.toString());
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse() throws IOException {
        String string = this.connection.getContentType();
        if (string == null || !string.startsWith("text/")) {
            return null;
        }
        String string2 = FileUtil.contentTypeToCharsetName(string);
        if (string2 == null) {
            string2 = "ISO-8859-1";
        }
        InputStream inputStream = this.connection.getInputStream();
        String string3 = null;
        try {
            string3 = FileUtil.loadString(inputStream, string2);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return string3;
    }

    public void done() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out = null;
        }
        this.connection.disconnect();
    }
}

