/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmleditapp.command.Printer;
import com.xmlmind.xmleditapp.command.Printers;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;
import java.io.IOException;
import javax.print.PrintException;

public final class PrintItem
extends ProcessCommandItem {
    private String printer;
    private String file;

    public PrintItem(String string, String string2) {
        this.printer = string;
        this.file = string2;
    }

    public String getPrinter() {
        return this.printer;
    }

    public String getFile() {
        return this.file;
    }

    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws IOException, PrintException, ProcessCommandItemException {
        String string = ProcessCommandItem.substitute(this.printer, stringArray, stringArray2);
        String string2 = ProcessCommandItem.substitute(this.file, stringArray, stringArray2);
        console.showMessage(Msg.msg("printing", string2, string), 0);
        File file2 = ProcessCommandItem.resolve(string2, file);
        if (!file2.isFile()) {
            throw new ProcessCommandItemException(Msg.msg("notAFile", string2));
        }
        String string3 = null;
        String string4 = null;
        String[] stringArray3 = StringUtil.splitArguments(string);
        if (stringArray3.length >= 1) {
            string3 = stringArray3[0];
            if (stringArray3.length >= 2) {
                string4 = stringArray3[1];
            }
        }
        if (string3 == null) {
            throw new ProcessCommandItemException(Msg.msg("noPrinter"));
        }
        if (string4 == null) {
            string4 = FileUtil.fileExtension(file2.getPath());
        }
        if ("Professional".equals("Standard")) {
            throw new ProcessCommandItemException(Msg.msg("printingDisabled", string4) + "\n\n" + Msg.msg("notRestrictedInProEdition"));
        }
        Printer printer = Printers.getPrinter(string4, string3);
        if (printer == null) {
            throw new ProcessCommandItemException(Msg.msg("unknownPrinter", string3, string4));
        }
        printer.print(file2);
        return null;
    }
}

