/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.Log;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.macro.MacroCommandUtil;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommandDialog;
import com.xmlmind.xmleditapp.process.ProcessCommandDialogBase;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import com.xmlmind.xmleditapp.process.ProcessThread;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Timer;

public class ProcessCommand
extends RecordableCommand
implements ActionListener {
    private ProcessCommandItem[] items;
    private boolean showProgress;
    private URL configURL;
    private ProcessCommandDialogBase dialog = null;
    private ProcessThread processThread = null;
    private String processThreadError = null;

    public ProcessCommand(ProcessCommandItem[] processCommandItemArray, boolean bl, URL uRL) {
        this.items = processCommandItemArray;
        this.showProgress = bl;
        this.configURL = uRL;
        int n = 0;
        while (n < this.items.length) {
            this.items[n].setProcessCommand(this);
            ++n;
        }
    }

    public ProcessCommandItem[] getItems() {
        return this.items;
    }

    public boolean isShowingProgress() {
        return this.showProgress;
    }

    public URL getConfigurationURL() {
        return this.configURL;
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        return documentView.getDocument() != null;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Container container = documentView.getPanel();
        File file = null;
        try {
            file = ProcessCommand.createWorkingDir();
        }
        catch (IOException iOException) {
            Alert.showError(container, Msg.msg("commandExecutionFailed", MiscUtil.reason(iOException)));
            return Command.EXECUTION_FAILED;
        }
        Document document = documentView.getDocument();
        String[] stringArray = string == null ? new String[]{} : StringUtil.splitArguments(string);
        this.dialog = this.showProgress ? new ProcessCommandDialog(container) : new ProcessCommandDialogBase(container);
        String string2 = Msg.msg("commandExecution");
        Log.clear(string2);
        this.dialog.setMessageLog(string2);
        Object[] objectArray = new Object[1];
        this.startProcessThread(document, stringArray, file, this.dialog, objectArray);
        Timer timer = new Timer(250, this);
        timer.setRepeats(true);
        timer.setCoalesce(true);
        timer.start();
        String string3 = this.dialog.showProgress(this.processThread);
        timer.stop();
        timer = null;
        this.processThread = null;
        this.dialog = null;
        FileUtil.removeFile(file, true);
        if (this.processThreadError != null) {
            Alert.showError(container, this.processThreadError, string3, true, 20, 60);
            this.processThreadError = null;
            return Command.EXECUTION_FAILED;
        }
        ShowStatus.showStatus(Msg.msg("commandExecutionSuccessful"));
        return objectArray[0];
    }

    private static final File createWorkingDir() throws IOException {
        File file = File.createTempFile("xxe", "");
        file.delete();
        if (!file.mkdir()) {
            throw new IOException(Msg.msg("cannotCreateWorkingDir", file));
        }
        return file;
    }

    private void startProcessThread(final Document document, final String[] stringArray, final File file, final Console console, final Object[] objectArray) {
        final String[] stringArray2 = new String[MacroCommandUtil.VAR_NAMES.length + 2];
        MacroCommandUtil.setVariables(document.getLocation(), file, stringArray2);
        stringArray2[MacroCommandUtil.VAR_NAMES.length] = "";
        stringArray2[MacroCommandUtil.VAR_NAMES.length + 1] = "";
        if (this.configURL != null) {
            URL uRL;
            File file2 = FileUtil.urlToFile(this.configURL);
            if (file2 != null) {
                stringArray2[MacroCommandUtil.VAR_NAMES.length] = file2.getParent();
            }
            if ((uRL = URLUtil.getDirectory(this.configURL)) != null) {
                stringArray2[MacroCommandUtil.VAR_NAMES.length + 1] = MacroCommandUtil.dirToExternalForm(uRL);
            }
        }
        this.processThreadError = Msg.msg("commandExecutionInterrupted");
        this.processThread = new ProcessThread(){

            public void run() {
                int n = 0;
                while (n < ProcessCommand.this.items.length) {
                    Thread.yield();
                    if (ProcessThread.canceled()) {
                        return;
                    }
                    String string = null;
                    try {
                        string = ProcessCommand.this.items[n].execute(document, file, stringArray, stringArray2, console);
                    }
                    catch (ProcessCommandItemException processCommandItemException) {
                        ProcessCommand.this.processThreadError = Msg.msg("commandExecutionFailed", MiscUtil.reason(processCommandItemException));
                        return;
                    }
                    catch (Throwable throwable) {
                        ProcessCommand.this.processThreadError = Msg.msg("commandExecutionFailed", MiscUtil.detailedReason(throwable));
                        return;
                    }
                    if (string != null) {
                        objectArray[0] = string;
                    }
                    ++n;
                }
                ProcessCommand.this.processThreadError = null;
            }
        };
        this.processThread.setContextClassLoader(this.getClass().getClassLoader());
        this.processThread.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.processThread.isAlive() && this.dialog.isShowing()) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    public String execute(Document document, String[] stringArray, Console console) {
        File file = null;
        try {
            file = ProcessCommand.createWorkingDir();
        }
        catch (IOException iOException) {
            return MiscUtil.reason(iOException);
        }
        Object[] objectArray = new Object[1];
        this.startProcessThread(document, stringArray, file, console, objectArray);
        try {
            this.processThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String string = this.processThreadError;
        this.processThreadError = null;
        this.processThread = null;
        FileUtil.removeFile(file, true);
        return string;
    }
}

