/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.macro.MacroCommandUtil;
import com.xmlmind.xmleditapp.process.GlobFilter;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ParameterGroups;
import com.xmlmind.xmleditapp.process.ProcessCommand;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.PatternSyntaxException;

public abstract class ProcessCommandItem {
    private static char[] varNames = new char[MacroCommandUtil.VAR_NAMES.length + 2];
    protected ProcessCommand processCommand;

    void setProcessCommand(ProcessCommand processCommand) {
        this.processCommand = processCommand;
    }

    public ProcessCommand getProcessCommand() {
        return this.processCommand;
    }

    public abstract String execute(Document var1, File var2, String[] var3, String[] var4, Console var5) throws Exception;

    protected static final String[] substituteParameters(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        String[] stringArray4 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray4[n] = ProcessCommandItem.substitute(stringArray[n], stringArray2, stringArray3);
            stringArray4[n + 1] = stringArray[n + 1];
            n += 2;
        }
        String[] stringArray5 = ParameterGroups.expand(stringArray4);
        int n2 = 0;
        while (n2 < stringArray5.length) {
            stringArray5[n2 + 1] = ProcessCommandItem.substitute(stringArray5[n2 + 1], stringArray2, stringArray3);
            n2 += 2;
        }
        return stringArray5;
    }

    protected static final String[] substitute(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        String[] stringArray4 = (String[])stringArray.clone();
        int n = 0;
        while (n < stringArray.length) {
            stringArray4[n] = ProcessCommandItem.substitute(stringArray[n], stringArray2, stringArray3);
            ++n;
        }
        return stringArray4;
    }

    protected static final String substitute(String string, String[] stringArray, String[] stringArray2) {
        if (string.indexOf(37) < 0) {
            return string;
        }
        return StringUtil.substituteVars(string, stringArray, varNames, stringArray2);
    }

    protected static final File resolve(String string, File file) {
        File file2;
        File file3;
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        if (!(file3 = new File(string)).isAbsolute()) {
            file3 = new File(file, string);
        }
        try {
            file2 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {
            file2 = file3.getAbsoluteFile();
        }
        return file2;
    }

    protected static final File[] glob(File file) throws ProcessCommandItemException {
        File[] fileArray;
        GlobFilter globFilter;
        String string = file.getName();
        if (string.indexOf(42) < 0 && string.indexOf(63) < 0 && string.indexOf(91) < 0) {
            return new File[]{file};
        }
        try {
            globFilter = new GlobFilter(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return new File[]{file};
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = new File(".");
        }
        if ((fileArray = file2.listFiles(globFilter)) == null) {
            throw new ProcessCommandItemException(Msg.msg("cannotListDir", file2));
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void copyFile(URL uRL, File file, Console console) throws IOException {
        console.showMessage(Msg.msg("copyingFile", URLUtil.toDisplayForm(uRL), file), 0);
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setIfModifiedSince(0L);
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream == null) {
            console.showMessage(Msg.msg("fileNotFound", URLUtil.toDisplayForm(uRL)), 1);
            return;
        }
        try {
            ProcessCommandItem.doCopyFile(inputStream, file);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doCopyFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    static {
        System.arraycopy(MacroCommandUtil.VAR_NAMES, 0, varNames, 0, MacroCommandUtil.VAR_NAMES.length);
        ProcessCommandItem.varNames[MacroCommandUtil.VAR_NAMES.length] = 67;
        ProcessCommandItem.varNames[MacroCommandUtil.VAR_NAMES.length + 1] = 99;
    }
}

