/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmleditapp.process.FOProcessor;
import com.xmlmind.xmleditapp.process.FOProcessors;
import com.xmlmind.xmleditapp.process.Msg;
import com.xmlmind.xmleditapp.process.ProcessCommand;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.ProcessCommandItemException;
import java.io.File;

public final class ProcessFOItem
extends ProcessCommandItem {
    private String processorName;
    private String input;
    private String output;
    private String[] parameters;
    private ProcessFOItem fallback;

    public ProcessFOItem(String string, String string2, String string3, String[] stringArray, ProcessFOItem processFOItem) {
        this.processorName = string;
        this.input = string2;
        this.output = string3;
        this.parameters = stringArray;
        this.fallback = processFOItem;
    }

    void setProcessCommand(ProcessCommand processCommand) {
        super.setProcessCommand(processCommand);
        if (this.fallback != null) {
            this.fallback.setProcessCommand(processCommand);
        }
    }

    public String getProcessorName() {
        return this.processorName;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public ProcessFOItem getFallback() {
        return this.fallback;
    }

    public String execute(Document document, File file, String[] stringArray, String[] stringArray2, Console console) throws Exception {
        String[] stringArray3;
        FOProcessor fOProcessor = FOProcessors.get(this.processorName);
        if (fOProcessor == null && this.fallback != null) {
            return this.fallback.execute(document, file, stringArray, stringArray2, console);
        }
        String string = ProcessCommandItem.substitute(this.input, stringArray, stringArray2);
        String string2 = ProcessCommandItem.substitute(this.output, stringArray, stringArray2);
        console.showMessage(Msg.msg("processingFO", string, string2, this.processorName), 0);
        File file2 = ProcessCommandItem.resolve(string, file);
        if (!file2.isFile()) {
            throw new ProcessCommandItemException(Msg.msg("notAFile", file2));
        }
        File file3 = ProcessCommandItem.resolve(string2, file);
        if (file3.isDirectory()) {
            file3 = new File(file3, file2.getName());
        }
        if (fOProcessor == null) {
            throw new ProcessCommandItemException(Msg.msg("unknownFOProcessor", this.processorName, this.processorName.toLowerCase()));
        }
        boolean bl = "Professional".equals("Standard");
        if (bl && "XEP".equals(this.processorName) && (stringArray3 = fOProcessor.getDescription()) != null && ((stringArray3 = stringArray3.toLowerCase()).indexOf("personal") >= 0 || stringArray3.indexOf("trial") >= 0 || stringArray3.indexOf("stamp") >= 0 || stringArray3.indexOf("[[[") >= 0)) {
            bl = false;
        }
        if (bl) {
            throw new ProcessCommandItemException(Msg.msg("foProcessingDisabled", this.processorName) + "\n\n" + Msg.msg("notRestrictedInProEdition"));
        }
        stringArray3 = this.parameters != null ? ProcessCommandItem.substituteParameters(this.parameters, stringArray, stringArray2) : new String[]{};
        try {
            fOProcessor.processFO(file2, file3, stringArray3, console);
        }
        catch (Exception exception) {
            throw new ProcessCommandItemException(Msg.msg("foProcessorError", this.processorName, MiscUtil.reason(exception)));
        }
        return null;
    }
}

