/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.process;

import com.xmlmind.xmledit.util.FileUtil;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class StyleSheetCache {
    private static HashMap entries = new HashMap();
    private static boolean trace = false;

    public static final Transformer newTransformer(TransformerFactory transformerFactory, URL uRL) throws TransformerConfigurationException {
        Entry entry = (Entry)entries.get(uRL);
        if (!(entry == null || entry.file == null || entry.file.isFile() && entry.file.lastModified() < entry.date)) {
            StyleSheetCache.trace("discarding obsolete '" + entry.file + "'");
            entries.remove(uRL);
            entry = null;
        }
        if (entry == null) {
            StyleSheetCache.trace("caching '" + uRL + "'");
            Templates templates = transformerFactory.newTemplates(new StreamSource(uRL.toExternalForm()));
            entry = new Entry(uRL, templates);
            entries.put(uRL, entry);
        } else {
            StyleSheetCache.trace("fetched '" + uRL + "'");
        }
        return entry.templates.newTransformer();
    }

    public static final void clear() {
        entries.clear();
        StyleSheetCache.trace("cleared cache");
    }

    private static final void trace(String string) {
        if (trace) {
            System.err.println("StyleSheetCache >>> " + string);
        }
    }

    private static class Entry {
        public URL url;
        public Templates templates;
        public File file;
        public long date;

        public Entry(URL uRL, Templates templates) {
            this.url = uRL;
            this.templates = templates;
            this.file = FileUtil.urlToFile(uRL);
            this.date = System.currentTimeMillis();
        }
    }
}

